/*
    @author Hertz
    @version 1.0
*/

//const $ICurioItem = java('top.theillusivec4.curios.api.type.capability.ICurioItem')
var $CuriosAPI = Java.loadClass('top.theillusivec4.curios.api.CuriosApi');
var $UUID = Java.loadClass("java.util.UUID")
var KJSUtils = Java.loadClass('dev.latvian.mods.kubejs.util.UtilsJS');
var $ResourceLocation = Java.loadClass('net.minecraft.resources.ResourceLocation');

var PlayerUtil = Java.loadClass('net.threetag.palladium.util.PlayerUtil');

global.playSoundToAll = function(entity, range, sound, category, volume, pitch) {
    // PlayerUtil['playSoundToAll(net.minecraft.class_1937,double,double,double,double,net.minecraft.class_3414,net.minecraft.class_3419,float,float)'](entity.getLevel(), entity.x, entity.y, entity.z, range, sound, category, volume, pitch);
    PlayerUtil['playSoundToAll(net.minecraft.world.level.Level,double,double,double,double,net.minecraft.resources.ResourceLocation,net.minecraft.sounds.SoundSource,float,float)'](entity.getLevel(), entity.x, entity.y, entity.z, range, sound, category, volume, pitch);
}
/*
global.playSoundLocal = function(player, sound, category, volume, pitch) {
    PlayerUtil['playSound(net.minecraft.class_1657,double,double,double,net.minecraft.class_3414,net.minecraft.class_3419,float,float)'](player.getLevel(), player.x, player.y, player.z, sound, category, volume, pitch);
}
*/

global.curioFunctions = {
    'dampened:dampening_cuffs': {
        onEquip: (event) => {
            var entity = event.entity
            var curio = event.getStack()
            
            // PlayerUtil['playSoundToAll(net.minecraft.world.level.Level,double,double,double,double,net.minecraft.resources.ResourceLocation,net.minecraft.sounds.SoundSource,float,float)'](entity.getLevel(), entity.x, entity.y, entity.z, 8, new $ResourceLocation("dampened:cuffs_equip"), "ambient", 1, 1)
            // return

            if(entity.type != 'minecraft:player') return;
            if (!entity.getLevel().isClient) {
                // KJSUtils.staticServer.runCommandSilent(`playsound dampened:cuffs_equip master @a ${entity.getX()} ${entity.getY()} ${entity.getZ()}`)
                global.playSoundToAll(entity, 8, "dampened:cuffs_equip", "ambient", 1, 1)
            }
            // event.setResult("DEFAULT")
            if(curio.getNbt()?.locked == null || curio.getNbt()?.locked == undefined) {
                let newNbt = curio.getNbt()
                newNbt = (newNbt == "{}" || newNbt == null || newNbt == undefined) ? {locked: false} : newNbt
                newNbt.locked = false
                curio.setNbt(newNbt)
            }
            if (!curio.getNbt()?.uuid) {
                curio.setNbt({"uuid": $UUID.randomUUID().toString(), "locked": false})
            }
        },
        onUnequip: (event) => {
            var entity = event.entity
            var curio = event.getStack()
            // return

            if(entity.type != 'minecraft:player') return;
            if(curio.getNbt()?.locked == null || curio.getNbt()?.locked == undefined) {
                let newNbt = curio.getNbt()
                newNbt = (newNbt == "{}" || newNbt == null || newNbt == undefined) ? {locked: false} : newNbt
                newNbt.locked = false
                curio.setNbt(newNbt)
            }

            if (entity.isCreative() || curio.getNbt().locked != true) {
                event.setResult("DEFAULT")
            } else if (curio.getNbt()?.locked != null || curio.getNbt()?.locked != undefined) {
                if (curio.getNbt().locked == 1) {
                    event.setResult("DENY")
                    // playsound
                    if (!entity.getLevel().isClient) {
                        // KJSUtils.staticServer.runCommandSilent(`playsound dampened:cuffs_failure ambient ${entity.name.getString()} ${entity.getX()} ${entity.getY()} ${entity.getZ()}`)
                        global.playSoundToAll(entity, 8, "dampened:cuffs_failure", "ambient", 1, 1)
                    }
                }
            }
        }
    },
    'dampened:gold_cuffs': {
        onEquip: (event) => {
            var entity = event.entity
            var curio = event.getStack()
            // return

            if(entity.type != 'minecraft:player') return;
            if (!entity.getLevel().isClient) {
                // KJSUtils.staticServer.runCommandSilent(`playsound dampened:cuffs_equip master @a ${entity.getX()} ${entity.getY()} ${entity.getZ()}`)
                global.playSoundToAll(entity, 8, "dampened:cuffs_equip", "ambient", 1, 1)
            }
            // event.setResult("DEFAULT")
            if(curio.getNbt()?.locked == null || curio.getNbt()?.locked == undefined) {
                let newNbt = curio.getNbt()
                newNbt = (newNbt == "{}" || newNbt == null || newNbt == undefined) ? {locked: false} : newNbt
                newNbt.locked = false
                curio.setNbt(newNbt)
            }
            if (!curio.getNbt()?.uuid) {
                curio.setNbt({"uuid": $UUID.randomUUID().toString(), "locked": false})
            }
        },
        onUnequip: (event) => {
            var entity = event.entity
            var curio = event.getStack()
            // return

            if(entity.type != 'minecraft:player') return;
            if(curio.getNbt()?.locked == null || curio.getNbt()?.locked == undefined) {
                let newNbt = curio.getNbt()
                newNbt = (newNbt == "{}" || newNbt == null || newNbt == undefined) ? {locked: false} : newNbt
                newNbt.locked = false
                curio.setNbt(newNbt)
            }

            if (entity.isCreative() || curio.getNbt().locked != true) {
                event.setResult("DEFAULT")
            } else if (curio.getNbt()?.locked != null || curio.getNbt()?.locked != undefined) {
                if (curio.getNbt().locked == 1) {
                    event.setResult("DENY")
                    // playsound
                    if (!entity.getLevel().isClient) {
                        // KJSUtils.staticServer.runCommandSilent(`playsound dampened:cuffs_failure ambient ${entity.name.getString()} ${entity.getX()} ${entity.getY()} ${entity.getZ()}`)
                        global.playSoundToAll(entity, 8, "dampened:cuffs_failure", "ambient", 1, 1)
                    }
                }
            }
        }
    },
    'dampened:magic_cuffs': {
        onEquip: (event) => {
            var entity = event.entity
            var curio = event.getStack()
            // return

            if(entity.type != 'minecraft:player') return;
            if (!entity.getLevel().isClient) {
                global.playSoundToAll(entity, 8, "dampened:cuffs_equip", "ambient", 1, 1)
            }
            // event.setResult("DEFAULT")
            if(curio.getNbt()?.locked == null || curio.getNbt()?.locked == undefined) {
                let newNbt = curio.getNbt()
                newNbt = (newNbt == "{}" || newNbt == null || newNbt == undefined) ? {locked: false} : newNbt
                newNbt.locked = false
                curio.setNbt(newNbt)
            }
            if (!curio.getNbt()?.uuid) {
                curio.setNbt({"uuid": $UUID.randomUUID().toString(), "locked": false})
            }
        },
        onUnequip: (event) => {
            var entity = event.entity
            var curio = event.getStack()
            // return

            if(entity.type != 'minecraft:player') return;
            if(curio.getNbt()?.locked == null || curio.getNbt()?.locked == undefined) {
                let newNbt = curio.getNbt()
                newNbt = (newNbt == "{}" || newNbt == null || newNbt == undefined) ? {locked: false} : newNbt
                newNbt.locked = false
                curio.setNbt(newNbt)
            }

            if (entity.isCreative() || curio.getNbt().locked != true) {
                event.setResult("DEFAULT")
            } else if (curio.getNbt()?.locked != null || curio.getNbt()?.locked != undefined) {
                if (curio.getNbt().locked == 1) {
                    event.setResult("DENY")
                    // playsound
                    if (!entity.getLevel().isClient) {
                        global.playSoundToAll(entity, 8, "dampened:cuffs_failure", "ambient", 1, 1)
                    }
                }
            }
        }
    },
    'dampened:mutant_collar': {
        onEquip: (event) => {
            var entity = event.entity
            var curio = event.getStack()

            if(entity.type != 'minecraft:player') return;
            if (!entity.getLevel().isClient) {
                // KJSUtils.staticServer.runCommandSilent(`playsound dampened:cuffs_equip master @a ${entity.getX()} ${entity.getY()} ${entity.getZ()}`)
                global.playSoundToAll(entity, 8, "dampened:cuffs_equip", "ambient", 1, 1)
            }
            if(curio.getNbt()?.locked == null || curio.getNbt()?.locked == undefined) {
                let newNbt = curio.getNbt()
                newNbt = (newNbt == "{}" || newNbt == null || newNbt == undefined) ? {locked: false} : newNbt
                newNbt.locked = false
                curio.setNbt(newNbt)
            }
            if (!curio.getNbt()?.uuid) {
                curio.setNbt({"uuid": $UUID.randomUUID().toString(), "locked": false})
            }
        },
        onUnequip: (event) => {
            var entity = event.entity
            var curio = event.getStack()

            if(entity.type != 'minecraft:player') return;
            if(curio.getNbt()?.locked == null || curio.getNbt()?.locked == undefined) {
                let newNbt = curio.getNbt()
                newNbt = (newNbt == "{}" || newNbt == null || newNbt == undefined) ? {locked: false} : newNbt
                newNbt.locked = false
                curio.setNbt(newNbt)
            }
            if (!curio.getNbt()?.uuid) {
                curio.setNbt({"uuid": $UUID.randomUUID().toString(), "locked": false})
            }

            if (entity.isCreative() || curio.getNbt().locked != true) {
                event.setResult("DEFAULT")
            } else if (curio.getNbt()?.locked != null || curio.getNbt()?.locked != undefined) {
                if (curio.getNbt().locked == 1) {
                    event.setResult("DENY")
                    if (!entity.getLevel().isClient) {
                        // KJSUtils.staticServer.runCommandSilent(`playsound dampened:cuffs_failure ambient ${entity.name.getString()} ${entity.getX()} ${entity.getY()} ${entity.getZ()}`)
                        global.playSoundToAll(entity, 8, "dampened:cuffs_failure", "ambient", 1, 1)
                    }
                }
            }
        }
    },
    'dampened:waist_cuffs': {
        onEquip: (event) => {
            var entity = event.entity
            var curio = event.getStack()

            if(entity.type != 'minecraft:player') return;
            if (!entity.getLevel().isClient) {
                // KJSUtils.staticServer.runCommandSilent(`playsound dampened:cuffs_equip master @a ${entity.getX()} ${entity.getY()} ${entity.getZ()}`)
                global.playSoundToAll(entity, 8, "dampened:cuffs_equip", "ambient", 1, 1)
            }
            if(curio.getNbt()?.locked == null || curio.getNbt()?.locked == undefined) {
                let newNbt = curio.getNbt()
                newNbt = (newNbt == "{}" || newNbt == null || newNbt == undefined) ? {locked: false} : newNbt
                newNbt.locked = false
                curio.setNbt(newNbt)
            }
            if (!curio.getNbt()?.uuid) {
                curio.setNbt({"uuid": $UUID.randomUUID().toString(), "locked": false})
            }
        },
        onUnequip: (event) => {
            var entity = event.entity
            var curio = event.getStack()

            if(entity.type != 'minecraft:player') return;
            if(curio.getNbt()?.locked == null || curio.getNbt()?.locked == undefined) {
                let newNbt = curio.getNbt()
                newNbt = (newNbt == "{}" || newNbt == null || newNbt == undefined) ? {locked: false} : newNbt
                newNbt.locked = false
                curio.setNbt(newNbt)
            }
            if (!curio.getNbt()?.uuid) {
                curio.setNbt({"uuid": $UUID.randomUUID().toString(), "locked": false})
            }

            if (entity.isCreative() || curio.getNbt().locked != true) {
                event.setResult("DEFAULT")
            } else if (curio.getNbt()?.locked != null || curio.getNbt()?.locked != undefined) {
                if (curio.getNbt().locked == 1) {
                    event.setResult("DENY")
                    if (!entity.getLevel().isClient) {
                        // KJSUtils.staticServer.runCommandSilent(`playsound dampened:cuffs_failure ambient ${entity.name.getString()} ${entity.getX()} ${entity.getY()} ${entity.getZ()}`)
                        global.playSoundToAll(entity, 8, "dampened:cuffs_failure", "ambient", 1, 1)
                    }
                }
            }
        }
    }
}

// 1.20.x BRANCH
// https://github.com/TheIllusiveC4/Curios/blob/1.20.x/src/main/java/top/theillusivec4/curios/api/event/CurioEquipEvent.java
ForgeEvents.onEvent('top.theillusivec4.curios.api.event.CurioEquipEvent', (event) => {
    if(event.entity.getLevel().isClient) return;

    let curio = event.getStack()

    if(!global.curioFunctions[curio.id]) return;
    global.curioFunctions[curio.id].onEquip(event)
})

// 1.20.x BRANCH
// https://github.com/TheIllusiveC4/Curios/blob/1.20.x/src/main/java/top/theillusivec4/curios/api/event/CurioUnequipEvent.java
ForgeEvents.onEvent('top.theillusivec4.curios.api.event.CurioUnequipEvent', (event) => {
    if(event.entity.getLevel().isClient) return;

    let curio = event.getStack()

    if(!global.curioFunctions[curio.id]) return;
    global.curioFunctions[curio.id].onUnequip(event)
})



// 1.20.x BRANCH
//
ForgeEvents.onEvent('net.minecraftforge.event.ItemStackedOnOtherEvent', (event) => {
    if(event.getPlayer().getLevel().isClient) return;
    // if(event.getPlayer().isCreative()) return;
    // if(event.getPlayer().isSpectator()) return;

    let carried = event.getCarriedItem()
    let stacked = event.getStackedOnItem()
    let player = event.getPlayer()
    let clickAction = event.getClickAction()

    let lockableItems = [
        "dampened:dampening_cuffs",
        "dampened:gold_cuffs",
        "dampened:magic_cuffs",
        "dampened:waist_cuffs",
        "dampened:mutant_collar"
    ]
    //
    // console.log("CARRIED: " + carried.id)
    // console.log("STACKED: " + stacked.id)
    // console.log(player)
    // console.log(clickAction)
    // console.log(clickAction == "SECONDARY")
    //
    if (
        stacked.id == "dampened:key" &&
        lockableItems.includes(carried.id) &&
        clickAction == "SECONDARY"
    ) {
        if (carried.getNbt()?.uuid != undefined && carried.getNbt()?.locked != undefined) {
            if (stacked.getNbt()?.uuid == carried.getNbt()?.uuid) {
                let newNbt = carried.getNbt()
                newNbt.locked = false
                carried.setNbt(newNbt)
                // playsound
                if (!player.getLevel().isClient) {
                    // KJSUtils.staticServer.runCommandSilent(`playsound dampened:cuffs_unlock master @a ${player.getX()} ${player.getY()} ${player.getZ()}`)
                    global.playSoundToAll(player, 8, "dampened:cuffs_unlock", "ambient", 1, 1)
                }
                event.setCanceled(true)
            }
        }
    }
    if (
        stacked.id == "dampened:master_key" &&
        lockableItems.includes(carried.id) &&
        clickAction == "SECONDARY"
    ) {
        if (carried.getNbt()?.uuid != undefined && carried.getNbt()?.locked != undefined) {
            let newNbt = carried.getNbt()
            newNbt.locked = false
            carried.setNbt(newNbt)
            // playsound
            if (!player.getLevel().isClient) {
                // KJSUtils.staticServer.runCommandSilent(`playsound dampened:cuffs_unlock master @a ${player.getX()} ${player.getY()} ${player.getZ()}`)
                global.playSoundToAll(player, 8, "dampened:cuffs_unlock", "ambient", 1, 1)
            }
            event.setCanceled(true)
        }
    }
})