let lockableItems = [
    "dampened:dampening_cuffs",
    "dampened:gold_cuffs",
    "dampened:magic_cuffs",
    "dampened:waist_cuffs",
    "dampened:mutant_collar"
]

ItemEvents.crafted(lockableItems, (event) => {
    if (lockableItems.includes(event.getItem().id)) {
        let useuuid = $UUID.randomUUID().toString()
        event.getItem().setNbt({"uuid": useuuid, "locked": true})
    }
})

ServerEvents.recipes(event => {
    event.shaped('dampened:dampening_cuffs', [
        'AAA',
        'DCD',
        'ABA'
    ], {
        A: '#forge:ingots/titanium',
        B: 'palladium:vibranium_circuit',
        C: 'dampened:nether_star_fragment',
        D: 'palladium:redstone_flux_crystal',
    })
    event.shaped('dampened:mutant_collar', [
        'AAA',
        'A A',
        'ACB'
    ], {
        A: '#forge:ingots/titanium',
        B: 'palladium:vibranium_circuit',
        C: 'dampened:nether_star_fragment'
    })
    event.shaped('dampened:waist_cuffs', [
        'ABA',
        'A A',
        'DCD'
    ], {
        A: '#forge:ingots/titanium',
        B: 'palladium:vibranium_circuit',
        C: 'dampened:nether_star_fragment',
        D: '#forge:ingots/titanium_gold'
    })
    event.shaped('dampened:gold_cuffs', [
        'AAA',
        'ACA',
        'DBD'
    ], {
        A: '#forge:ingots/titanium_gold',
        B: 'palladium:vibranium_circuit',
        C: 'dampened:nether_star_fragment',
        D: '#forge:kryptonite',
    })
    event.shaped('dampened:magic_cuffs', [
        'AAA',
        'ACA',
        'DBD'
    ], {
        A: '#forge:ingots/vibranium',
        B: 'palladium:vibranium_circuit',
        C: 'dampened:nether_star_fragment',
        D: 'dampened:magic_rune',
    })
    event.shaped('dampened:dampening_block', [
        'AAA',
        'ACA',
        'ABA'
    ], {
        A: '#forge:ingots/titanium',
        B: 'palladium:vibranium_circuit',
        C: 'minecraft:nether_star'
    })
    event.shaped('dampened:emp_block', [
        'AAA',
        'ACA',
        'ABA'
    ], {
        A: '#forge:ingots/netherite',
        B: 'palladium:vibranium_circuit',
        C: 'minecraft:nether_star'
    })
    event.shaped('dampened:magic_rune', [
        'ABA',
        'BCB',
        'ABA'
    ], {
        A: '#forge:ingots/netherite',
        B: 'minecraft:lapis_lazuli',
        C: 'minecraft:nether_star'
    })

    event.shaped('dampened:blank_key', [
        ' B ',
        ' AA',
        ' AA'
    ], {
        A: 'minecraft:iron_ingot',
        B: 'minecraft:iron_block'
    })
    
    event.shapeless('dampened:key', [
        'dampened:mutant_collar',
        'dampened:blank_key',
        'minecraft:iron_nugget'
    ]).modifyResult((grid, result) => {
        var cuff = grid.get(0); // fallback
        for (var z = 0; z < 9; z++) {
            cuff = grid.get(z);
            if (cuff?.nbt?.uuid != undefined) { break; }
        }
        return transferNBT(cuff, result)
    }).keepIngredient('dampened:mutant_collar')

    event.shapeless('dampened:key', [
        'dampened:dampening_cuffs',
        'dampened:blank_key',
        'minecraft:iron_nugget'
    ]).modifyResult((grid, result) => {
        var cuff = grid.get(0); // fallback
        for (var z = 0; z < 9; z++) {
            cuff = grid.get(z);
            if (cuff?.nbt?.uuid != undefined) { break; }
        }
        return transferNBT(cuff, result)
    }).keepIngredient('dampened:dampening_cuffs')

    event.shapeless('dampened:key', [
        'dampened:gold_cuffs',
        'dampened:blank_key',
        'minecraft:iron_nugget'
    ]).modifyResult((grid, result) => {
        var cuff = grid.get(0); // fallback
        for (var z = 0; z < 9; z++) {
            cuff = grid.get(z);
            if (cuff?.nbt?.uuid != undefined) { break; }
        }
        return transferNBT(cuff, result)
    }).keepIngredient('dampened:gold_cuffs')

    event.shapeless('dampened:key', [
        'dampened:magic_cuffs',
        'dampened:blank_key',
        'minecraft:iron_nugget'
    ]).modifyResult((grid, result) => {
        var cuff = grid.get(0); // fallback
        for (var z = 0; z < 9; z++) {
            cuff = grid.get(z);
            if (cuff?.nbt?.uuid != undefined) { break; }
        }
        return transferNBT(cuff, result)
    }).keepIngredient('dampened:magic_cuffs')

    event.shapeless('dampened:key', [
        'dampened:waist_cuffs',
        'dampened:blank_key',
        'minecraft:iron_nugget'
    ]).modifyResult((grid, result) => {
        var cuff = grid.get(0); // fallback
        for (var z = 0; z < 9; z++) {
            cuff = grid.get(z);
            if (cuff?.nbt?.uuid != undefined) { break; }
        }
        return transferNBT(cuff, result)
    }).keepIngredient('dampened:waist_cuffs')



    event.smelting('3x dampened:nether_star_fragment', 'minecraft:nether_star')
})


const transferNBT = (item1, item2) => {
    let nbt1 = item1?.nbt || {};
    let nbt2 = item2?.nbt || {};

    // Merge NBT, adding item1's NBT onto item2 (enchanted book)
    let tmp = Object.assign({}, nbt2, nbt1)
    delete tmp.locked
    return Item.of(item2).withNBT(tmp);
};