var $CuriosTrinketsUtil = Java.loadClass('net.threetag.palladium.compat.curiostinkets.CuriosTrinketsUtil')
var $CuriosAPI = Java.loadClass('top.theillusivec4.curios.api.CuriosApi');
var $UUID = Java.loadClass("java.util.UUID")

var $ClipContext = Java.loadClass('net.minecraft.world.level.ClipContext')
var $ProjectileUtil = Java.loadClass('net.minecraft.world.entity.projectile.ProjectileUtil')

var advancedRayTrace = (entity, level, distance) => {
    let eyePos = entity.eyePosition;
    let viewVec = entity.getViewVector(1)
    let endPos = eyePos.add(viewVec.x() * distance, viewVec.y() * distance, viewVec.z() * distance)
    let aabb = AABB.of(eyePos.x(), eyePos.y(), eyePos.z(), endPos.x(), endPos.y(), endPos.z())

    let ray = $ProjectileUtil.getEntityHitResult(level, entity, eyePos, endPos, aabb, (e) => {
        return !e.isSpectator()
    }, 0)

    let clip = new $ClipContext(
        entity.getEyePosition(1), 
        entity.getEyePosition(1).add(entity.getLookAngle().scale(distance)), 
        'collider', 'none', 
        entity
    )
    let hit = level.clip(clip)
    if (ray == null) {
        return {
            block: hit.getBlockPos() ? level.getBlock(hit.getBlockPos()) : null,
            entity: null
        }
    }
    return {
        block: level.getBlock(hit.getBlockPos()),
        entity: ray.entity
    }
}

let lockableItems = [
    "dampened:dampening_cuffs",
    "dampened:gold_cuffs",
    "dampened:magic_cuffs",
    "dampened:waist_cuffs",
    "dampened:mutant_collar"
]

ItemEvents.entityInteracted((event) => {
    var victim = event.getTarget()
    var player = event.getEntity()
    var item = event.item
    if (!lockableItems.includes(event.item.id)) return
    // event.getTarget()
    // event.getEntity()

    // var victim = advancedRayTrace(player, player.getLevel(), 4).entity
    
    if (!victim) return
    if (victim.type != "minecraft:player") return
    if (victim.health >= 5.0) {
        event.server.runCommandSilent(`playsound dampened:cuffs_failure ambient @a[distance=..12] ${victim.getX()} ${victim.getY()} ${victim.getZ()}`)
        return
    }

    var curiosSlotTypes = ['curio', 'back', 'belt', 'body', 'bracelet', 'charm', 'head', 'hands', 'necklace', 'ring']

    // only works for dampening cuffs rn
    // change to work w collar
    $CuriosAPI.getCuriosInventory(victim).ifPresent((curiosInventory) => {
        let curios = curiosInventory.getCurios()
        var found = false

        curiosSlotTypes.forEach((slotType) => {
            if (found) return;

            let stax = curios.get(slotType)
            if (!stax) return;
            stax = stax.getStacks()
            if (!stax) return;

            if (event.item.hasTag(`curios:${slotType}`)) {
                for (let i = 0; i < stax.getSlots(); i++) {
                    if (stax.getStackInSlot(i) != 'minecraft:air') {
                        // not willing to destroy items
                        return;
                    } else {
                        
                    }

                    stax.setStackInSlot(i, Item.of(
                        item.id, 1, item.getNbt()
                    ))
                    // Play dampen sound
                    event.server.runCommandSilent(`playsound dampened:cuffs_equip master @a ${victim.getX()} ${victim.getY()} ${victim.getZ()}`)
                    event.item.count--
                    found = true
                    return;
                }
            }
        })
    })
})

var keys = [
    'dampened:key',
    'dampened:master_key'
]
ItemEvents.entityInteracted((event) => {
    var victim = event.getTarget()
    var player = event.getEntity()
    var item = event.item
    if (!keys.includes(event.item.id)) return
    // event.getTarget()
    // event.getEntity()

    // var victim = advancedRayTrace(player, player.getLevel(), 4).entity
    
    if (!victim) return
    if (victim.type != "minecraft:player") return

    // only works for dampening cuffs rn
    // change to work w collar
    var curiosSlotTypes = ['curio', 'back', 'belt', 'body', 'bracelet', 'charm', 'head', 'hands', 'necklace', 'ring']
    var locking = true;
    $CuriosAPI.getCuriosInventory(victim).ifPresent((curiosInventory) => {
        let curios = curiosInventory.getCurios();
    
        curiosSlotTypes.forEach((slotType) => {
            let stax = curios.get(slotType)
            if (!stax) return;
            stax = stax.getStacks()
            if (!stax) return;
    
            for (let i = 0; i < stax.getSlots(); i++) {
                // let thisItem = stax.getStackInSlot(i);
                // victim.tell("locked and key")
                // here's the error
                // victim.tell(stax.getStackInSlot(i).getNbt()?.locked)
                // victim.tell((stax.getStackInSlot(i).getNbt()?.uuid === event.item.getNbt()?.uuid || event.item.id === "dampened:master_key"))
    
                if (
                    stax.getStackInSlot(i).getNbt()?.locked == true &&
                    (stax.getStackInSlot(i).getNbt()?.uuid === event.item.getNbt()?.uuid ||
                        event.item.id === "dampened:master_key")
                ) {
                    let newNbt = stax.getStackInSlot(i).getNbt();
                    newNbt.locked = false;
                    locking = false;
                    stax.getStackInSlot(i).setNbt(newNbt);
    
                    event.server.runCommandSilent(`playsound dampened:cuffs_unlock master @a ${victim.getX()} ${victim.getY()} ${victim.getZ()}`);
                    return;
                }
            }
        })
    });
    
    if (locking) {
        $CuriosAPI.getCuriosInventory(victim).ifPresent((curiosInventory) => {
            let curios = curiosInventory.getCurios();
        
            curiosSlotTypes.forEach((slotType) => {
                let stax = curios.get(slotType)
                if (!stax) return;
                stax = stax.getStacks()
                if (!stax) return;
        
                for (let i = 0; i < stax.getSlots(); i++) {
                    let thisItem = stax.getStackInSlot(i);
        
                    if (
                        stax.getStackInSlot(i).getNbt()?.locked == false &&
                        (stax.getStackInSlot(i).getNbt()?.uuid === event.item.getNbt()?.uuid ||
                         event.item.id === "dampened:master_key")
                    ) {
                        let newNbt = stax.getStackInSlot(i).getNbt();
                        newNbt.locked = true;
                        stax.getStackInSlot(i).setNbt(newNbt);
        
                        event.server.runCommandSilent(`playsound dampened:cuffs_activate master @a ${victim.getX()} ${victim.getY()} ${victim.getZ()}`);
                        return;
                    }
                }
            });
        })
    }
})

ItemEvents.rightClicked(lockableItems, (event) => {
    var player = event.player
    var item = event.item
    if (player.isShiftKeyDown()) {
        if (item.getNbt()?.locked == false) {
            let useuuid = item.getNbt()?.uuid != undefined ? item.getNbt().uuid : $UUID.randomUUID().toString()
            item.setNbt({"uuid": useuuid, "locked": true})
            event.server.runCommandSilent(`playsound dampened:cuffs_activate master @a ${player.getX()} ${player.getY()} ${player.getZ()}`)
        }
    }
})

PlayerEvents.tick((event) => {
    let player = event.player
    let allCurios = [
        $CuriosTrinketsUtil.getInstance().getItemsInSlot(player, Platform.isForge() ? 'bracelet' : 'hand/glove'),      // forge, fabric
        $CuriosTrinketsUtil.getInstance().getItemsInSlot(player, Platform.isForge() ? 'necklace' : 'chest/necklace'),  // forge, fabric
        $CuriosTrinketsUtil.getInstance().getItemsInSlot(player, Platform.isForge() ? 'back' : 'chest/back'),
        $CuriosTrinketsUtil.getInstance().getItemsInSlot(player, Platform.isForge() ? 'belt' : 'legs/belt'),
        $CuriosTrinketsUtil.getInstance().getItemsInSlot(player, Platform.isForge() ? 'body' : 'head/face'),
        $CuriosTrinketsUtil.getInstance().getItemsInSlot(player, Platform.isForge() ? 'charm' : 'chest/cape'),
        $CuriosTrinketsUtil.getInstance().getItemsInSlot(player, Platform.isForge() ? 'head' : 'head/hat'),
        $CuriosTrinketsUtil.getInstance().getItemsInSlot(player, Platform.isForge() ? 'hands' : 'hand/glove'),
        $CuriosTrinketsUtil.getInstance().getItemsInSlot(player, Platform.isForge() ? 'ring' : 'hand/glove')
        // missing: 'feet/shoes', 'feet/aglet', 'offhand/glove', 'offhand/ring'
    ]

    allCurios.forEach((upperLayer) => {
        upperLayer.forEach((item) => {
            if (item.hasTag('dampened:handcuffs')) {
                player.potionEffects.add("minecraft:mining_fatigue", 2, 255, true, false)
            }
            if (item.hasTag('dampened:dark_matter') && item.getNbt()?.locked == true) {
                player.potionEffects.add("dampened:dark_matter", 2, 0, true, false)
            }
            if (item.hasTag('dampened:genetic') && item.getNbt()?.locked == true) {
                player.potionEffects.add("dampened:genetic", 2, 0, true, false)
                // player.potionEffects.add("dampened:univirus", 10, 0, true, false)
            }
            if (item.hasTag('dampened:emp') && item.getNbt()?.locked == true) {
                player.potionEffects.add("dampened:emp", 2, 0, true, false)
                // player.potionEffects.add("dampened:univirus", 10, 0, true, false)
            }
            if (item.hasTag('dampened:kryptonite') && item.getNbt()?.locked == true) {
                player.potionEffects.add("dampened:kryptonite", 2, 0, true, false)
                // player.potionEffects.add("dampened:univirus", 10, 0, true, false)
            }
            if (item.hasTag('dampened:magic') && item.getNbt()?.locked == true) {
                player.potionEffects.add("dampened:magic", 2, 0, true, false)
                // player.potionEffects.add("dampened:univirus", 10, 0, true, false)
            }
            if (item.hasTag('dampened:dampener') && item.getNbt()?.locked == true) {
                player.potionEffects.add("dampened:dampen", 2, 0, true, false)
            }
        })
    })
})

ServerEvents.tags('item', event => {
    event.add('dampened:dark_matter', 'dampened:dampening_cuffs')
    event.add('dampened:handcuffs', 'dampened:dampening_cuffs')
    event.add('dampened:genetic', 'dampened:mutant_collar')

    event.add('dampened:dark_matter', 'dampened:gold_cuffs')
    event.add('dampened:kryptonite', 'dampened:gold_cuffs')
    event.add('dampened:handcuffs', 'dampened:gold_cuffs')

    event.add('dampened:magic', 'dampened:magic_cuffs')
    event.add('dampened:handcuffs', 'dampened:magic_cuffs')

    event.add('dampened:emp', 'dampened:waist_cuffs')
    event.add('dampened:handcuffs', 'dampened:waist_cuffs')
    
    // event.add('dampened:dampener', 'dampened:dampening_cuffs')
    // event.add('dampened:dampener', 'dampened:gold_cuffs')
    // event.add('dampened:dampener', 'dampened:magic_cuffs')
    // event.add('dampened:dampener', 'dampened:waist_cuffs')
    // event.add('dampened:dampener', 'dampened:mutant_collar')

    // event.add('dampened:univirus', 'dampened:mutant_collar')
})