/*
 * Decompiled with CFR 0.152.
 */
package com.technobecet.minerscompass.item.custom;

import com.mojang.serialization.DynamicOps;
import com.technobecet.minerscompass.MinersCompassMod;
import com.technobecet.minerscompass.util.ModTags;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4208;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class OreCompass
extends class_1792 {
    public static final String TARGET_BLOCK_LIST_KEY = "TargetBlockList";
    public static final String TRACKED_BLOCK_KEY = "TrackedBlock";
    public static final String TARGET_BLOCK_POS_KEY = "TargetBlockPos";
    public static final String TARGET_BLOCK_DIMENSION_KEY = "TargetBlockDimension";
    public static final String TARGET_BLOCK_TRACKED_KEY = "TargetBlockTracked";

    public OreCompass(class_1792.class_1793 settings) {
        super(settings);
    }

    @Nullable
    public static class_4208 getTrackedPos(class_2487 nbt) {
        Optional<class_5321<class_1937>> worldKey;
        if (nbt == null) {
            return null;
        }
        boolean hasTrackedValue = OreCompass.hasNbtKey(nbt, TARGET_BLOCK_TRACKED_KEY);
        if (!hasTrackedValue) {
            return null;
        }
        boolean tracked = nbt.method_10577(TARGET_BLOCK_TRACKED_KEY);
        boolean hasPosKey = OreCompass.hasNbtKey(nbt, TARGET_BLOCK_POS_KEY);
        boolean hasDimKey = OreCompass.hasNbtKey(nbt, TARGET_BLOCK_DIMENSION_KEY);
        if (hasPosKey && hasDimKey && tracked && (worldKey = OreCompass.getTrackedDimension(nbt)).isPresent()) {
            class_2338 blockPos = class_2512.method_10691((class_2487)nbt.method_10562(TARGET_BLOCK_POS_KEY));
            return class_4208.method_19443(worldKey.get(), (class_2338)blockPos);
        }
        return null;
    }

    private static Optional<class_2338> findBlocks(class_1799 stack, class_1937 world, class_1297 entity, boolean force) {
        if (world.field_9236) {
            return Optional.empty();
        }
        List<class_2248> targetBlocks = OreCompass.getBlocksFromNbt(stack.method_7969());
        if (targetBlocks.isEmpty()) {
            class_2487 nbt = stack.method_7948();
            for (String key : nbt.method_10541()) {
                if (!key.startsWith(TARGET_BLOCK_LIST_KEY) && !key.equals(TARGET_BLOCK_POS_KEY) && !key.equals(TARGET_BLOCK_DIMENSION_KEY) && !key.equals(TARGET_BLOCK_TRACKED_KEY)) continue;
                nbt.method_10551(key);
            }
            return Optional.empty();
        }
        class_4208 trackedPos = OreCompass.getTrackedPos(stack.method_7969());
        if (!force && trackedPos != null) {
            class_2680 trackedBlockState = world.method_8320(trackedPos.method_19446());
            if (targetBlocks.contains(trackedBlockState.method_26204())) {
                return Optional.of(trackedPos.method_19446());
            }
            Optional<class_5321<class_1937>> dimKey = OreCompass.getTrackedDimension(stack.method_7969());
            if (dimKey.isPresent() && !dimKey.get().toString().equals(entity.method_37908().method_27983().toString())) {
                return Optional.empty();
            }
        }
        Optional<class_2338> closest = OreCompass.findBlocksInNearbyChunks(stack, world, entity.method_24515());
        OreCompass.playSoundOnStateChange(world, entity, stack, closest);
        OreCompass.writeNbt((class_5321<class_1937>)world.method_27983(), closest, stack.method_7948());
        return closest;
    }

    private static Optional<class_5321<class_1937>> getTrackedDimension(class_2487 nbt) {
        return class_1937.field_25178.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580(TARGET_BLOCK_DIMENSION_KEY)).result();
    }

    private static void playSoundOnStateChange(class_1937 world, class_1297 entity, class_1799 stack, Optional<class_2338> closest) {
        if (closest.isPresent()) {
            OreCompass.playSound(world, entity, true);
            return;
        }
        class_4208 trackedPos = OreCompass.getTrackedPos(stack.method_7969());
        if (!closest.isPresent() && trackedPos != null) {
            OreCompass.playSound(world, entity, false);
        }
    }

    private static void writeNbt(class_5321<class_1937> worldKey, Optional<class_2338> closest, class_2487 nbt) {
        if (nbt == null) {
            return;
        }
        if (closest.isPresent()) {
            class_2338 pos = closest.get();
            nbt.method_10566(TARGET_BLOCK_POS_KEY, (class_2520)class_2512.method_10692((class_2338)pos));
            class_1937.field_25178.encodeStart((DynamicOps)class_2509.field_11560, worldKey).resultOrPartial(arg_0 -> ((Logger)MinersCompassMod.LOGGER).error(arg_0)).ifPresent(nbtElement -> nbt.method_10566(TARGET_BLOCK_DIMENSION_KEY, nbtElement));
            nbt.method_10556(TARGET_BLOCK_TRACKED_KEY, true);
        } else {
            nbt.method_10566(TARGET_BLOCK_POS_KEY, (class_2520)class_2512.method_10692((class_2338)class_2338.field_10980));
            nbt.method_10556(TARGET_BLOCK_TRACKED_KEY, false);
            nbt.method_10551(TARGET_BLOCK_DIMENSION_KEY);
        }
    }

    private static void playSound(class_1937 world, class_1297 entity, boolean success) {
        world.method_8396(null, entity.method_24515(), success ? class_3417.field_23199 : class_3417.field_15102, class_3419.field_15248, 1.0f, 1.0f);
    }

    private static Optional<class_2338> findBlocksInNearbyChunks(class_1799 itemStack, class_1937 world, class_2338 entPos) {
        int chunkRadius = Math.max(0, MinersCompassMod.config.chunkRadius);
        Long2ObjectOpenHashMap blocks = new Long2ObjectOpenHashMap();
        class_1923 chunkPos = world.method_22350(entPos).method_12004();
        class_2487 nbt = itemStack.method_7948();
        List<class_2248> targetBlocks = OreCompass.getBlocksFromNbt(nbt);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        int startY = world.method_31607();
        int endY = world.method_31600();
        for (int x = chunkPos.field_9181 - chunkRadius; x <= chunkPos.field_9181 + chunkRadius; ++x) {
            for (int z = chunkPos.field_9180 - chunkRadius; z <= chunkPos.field_9180 + chunkRadius; ++z) {
                class_2818 chunk = world.method_8497(x, z);
                for (int i = 0; i < 16; ++i) {
                    for (int j = startY; j < endY; ++j) {
                        for (int k = 0; k < 16; ++k) {
                            mutableBlockPos.method_10103(x * 16 + i, j, z * 16 + k);
                            class_2680 blockState = world.method_8320((class_2338)mutableBlockPos);
                            if (!targetBlocks.contains(blockState.method_26204())) continue;
                            ((Set)blocks.computeIfAbsent(chunk.method_12004().method_8324(), key -> new HashSet())).add(mutableBlockPos.method_10062());
                        }
                    }
                }
            }
        }
        return OreCompass.getClosestBlockPos(itemStack, (Long2ObjectOpenHashMap<Set<class_2338>>)blocks, entPos, world);
    }

    private static Optional<class_2338> getClosestBlockPos(class_1799 itemStack, Long2ObjectOpenHashMap<Set<class_2338>> blockMap, class_2338 entPos, class_1937 world) {
        double closestDistanceSq = Double.MAX_VALUE;
        class_2338 closestPos = null;
        class_2248 closestBlock = null;
        for (Set positions : blockMap.values()) {
            for (class_2338 blockPos : positions) {
                double dz;
                double dy;
                double dx = blockPos.method_10263() - entPos.method_10263();
                double distanceSq = dx * dx + (dy = (double)(blockPos.method_10264() - entPos.method_10264())) * dy + (dz = (double)(blockPos.method_10260() - entPos.method_10260())) * dz;
                if (!(distanceSq < closestDistanceSq)) continue;
                closestPos = blockPos;
                closestDistanceSq = distanceSq;
                closestBlock = world.method_8320(closestPos).method_26204();
            }
        }
        if (closestPos != null && closestBlock != null) {
            class_2487 nbt = itemStack.method_7948();
            nbt.method_10582(TRACKED_BLOCK_KEY, class_7923.field_41175.method_10221(closestBlock).toString());
        }
        return Optional.ofNullable(closestPos);
    }

    private static List<class_2248> getBlocksFromNbt(class_2487 nbt) {
        if (nbt == null) {
            return Collections.emptyList();
        }
        ArrayList<class_2248> blocks = new ArrayList<class_2248>();
        for (String key : nbt.method_10541()) {
            if (!key.startsWith(TARGET_BLOCK_LIST_KEY)) continue;
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(new class_2960(nbt.method_10558(key)));
            blocks.add(block);
        }
        return blocks;
    }

    private static boolean hasNbtKey(class_2487 nbt, String key) {
        return nbt != null && nbt.method_10545(key);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (world.field_9236) {
            return class_1271.method_22427((Object)user.method_5998(hand));
        }
        class_1799 itemStack = user.method_5998(hand);
        class_2487 nbt = itemStack.method_7948();
        if (user.method_5715()) {
            this.clearNbtRecords(nbt);
            user.method_7353((class_2561)class_2561.method_43471((String)"item.miners-compass.ore_compass.cleared_blocks"), true);
            return class_1271.method_22427((Object)itemStack);
        }
        if (nbt == null || this.isBlockListEmpty(nbt)) {
            user.method_7353((class_2561)class_2561.method_43471((String)"item.miners-compass.ore_compass.no_blocks"), true);
            return class_1271.method_22427((Object)itemStack);
        }
        user.method_7357().method_7906((class_1792)this, 100);
        Optional<class_2338> pos = OreCompass.findBlocks(user.method_6047(), world, (class_1297)user, true);
        OreCompass.playSound(world, (class_1297)user, pos.isPresent());
        return class_1271.method_22427((Object)itemStack);
    }

    private void clearNbtRecords(class_2487 nbt) {
        if (nbt == null) {
            return;
        }
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (String key : nbt.method_10541()) {
            if (!key.startsWith(TARGET_BLOCK_LIST_KEY) && !key.equals(TARGET_BLOCK_POS_KEY) && !key.equals(TARGET_BLOCK_DIMENSION_KEY) && !key.equals(TARGET_BLOCK_TRACKED_KEY) && !key.equals(TRACKED_BLOCK_KEY)) continue;
            keysToRemove.add(key);
        }
        keysToRemove.forEach(arg_0 -> ((class_2487)nbt).method_10551(arg_0));
    }

    private boolean isBlockListEmpty(class_2487 nbt) {
        if (nbt == null) {
            return true;
        }
        for (String key : nbt.method_10541()) {
            if (!key.startsWith(TARGET_BLOCK_LIST_KEY)) continue;
            return false;
        }
        return true;
    }

    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        class_1799 itemStack = context.method_8041();
        class_2680 clickedBlockState = context.method_8045().method_8320(context.method_8037());
        class_2248 clickedBlock = clickedBlockState.method_26204();
        String clickedBlockId = class_7923.field_41175.method_10221((Object)clickedBlock).toString();
        String clickedBlockName = clickedBlock.method_9518().getString();
        if (player != null && player.method_5715()) {
            String message;
            if (!this.isValuableBlock(clickedBlockState)) {
                player.method_7353(class_2561.method_30163((String)class_2561.method_43469((String)"item.miners-compass.ore_compass.not_valuable", (Object[])new Object[]{clickedBlockName}).getString()), true);
                return class_1269.field_5812;
            }
            class_2487 nbt = itemStack.method_7948();
            String existingKey = this.findKeyForBlock(nbt, clickedBlockId);
            if (existingKey != null) {
                nbt.method_10551(existingKey);
                message = class_2561.method_43469((String)"item.miners-compass.ore_compass.removed_block", (Object[])new Object[]{clickedBlockName}).getString();
                if (this.isBlockListEmpty(nbt)) {
                    this.clearNbtRecords(nbt);
                }
            } else {
                List<class_2248> existingBlocks = OreCompass.getBlocksFromNbt(nbt);
                if (existingBlocks.size() < MinersCompassMod.config.maxBlocks) {
                    String nextBlockKey = this.findNextBlockKey(nbt);
                    nbt.method_10582(nextBlockKey, clickedBlockId);
                    message = class_2561.method_43469((String)"item.miners-compass.ore_compass.added_block", (Object[])new Object[]{clickedBlockName}).getString();
                } else {
                    message = class_2561.method_43471((String)"item.miners-compass.ore_compass.max_blocks").getString();
                }
            }
            player.method_7353((class_2561)class_2561.method_43470((String)message), true);
            return class_1269.field_5812;
        }
        return super.method_7884(context);
    }

    private String findNextBlockKey(class_2487 nbt) {
        int index = 0;
        while (OreCompass.hasNbtKey(nbt, TARGET_BLOCK_LIST_KEY + index)) {
            ++index;
        }
        return TARGET_BLOCK_LIST_KEY + index;
    }

    private String findKeyForBlock(class_2487 nbt, String blockId) {
        for (String key : nbt.method_10541()) {
            if (!key.startsWith(TARGET_BLOCK_LIST_KEY) || !nbt.method_10558(key).equals(blockId)) continue;
            return key;
        }
        return null;
    }

    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        List<class_2248> selectedBlocks;
        if (tooltipContext.method_47370()) {
            return;
        }
        class_2487 nbt = itemStack.method_7969();
        if (OreCompass.getTrackedPos(nbt) != null) {
            String trackedBlockName = OreCompass.hasNbtKey(nbt, TRACKED_BLOCK_KEY) ? ((class_2248)class_7923.field_41175.method_10223(new class_2960(nbt.method_10558(TRACKED_BLOCK_KEY)))).method_9518().getString() : "Unknown";
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.miners-compass.ore_compass.hint").method_27692(class_124.field_1080));
            Optional<class_5321<class_1937>> dimKey = OreCompass.getTrackedDimension(itemStack.method_7969());
            if (dimKey.isPresent() && !dimKey.get().toString().equals(world.method_27983().toString())) {
                tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.miners-compass.ore_compass.wrong_dim1", (Object[])new Object[]{trackedBlockName}).method_27692(class_124.field_1079).method_27692(class_124.field_1067));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.miners-compass.ore_compass.wrong_dim2").method_27692(class_124.field_1079).method_27692(class_124.field_1067));
            } else {
                tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.miners-compass.ore_compass.locked_on", (Object[])new Object[]{trackedBlockName}).method_27692(class_124.field_1061));
            }
        } else if (!this.isBlockListEmpty(nbt)) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.miners-compass.ore_compass.not_found").method_27692(class_124.field_1064));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.miners-compass.ore_compass.no_ores").method_27692(class_124.field_1064));
        }
        if (nbt != null && !this.isBlockListEmpty(nbt) && !(selectedBlocks = OreCompass.getBlocksFromNbt(nbt)).isEmpty()) {
            if (class_437.method_25442()) {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.miners-compass.ore_compass.selected_blocks").method_27692(class_124.field_1054));
                for (class_2248 block : selectedBlocks) {
                    String blockName = block.method_9518().getString();
                    tooltip.add((class_2561)class_2561.method_43470((String)(" - " + blockName)).method_27692(class_124.field_1068));
                }
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.miners-compass.ore_compass.tooltip"));
            }
        }
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        OreCompass.findBlocks(stack, world, entity, false);
    }

    private boolean isValuableBlock(class_2680 blockState) {
        return blockState.method_26164(ModTags.Blocks.ORE_COMPASS_DETECTABLE_BLOCKS);
    }
}

