/*
 * Decompiled with CFR 0.152.
 */
package net.pttheta.loveandwar.entity.custom;

import com.simibubi.create.foundation.utility.VecHelper;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DispenserMenu;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.pttheta.loveandwar.entity.ai.RobotDogAttackGoal;
import net.pttheta.loveandwar.item.ModItems;
import net.pttheta.loveandwar.sound.ModSounds;
import org.jetbrains.annotations.Nullable;

public class RobotdogEntity
extends TamableAnimal
implements NeutralMob,
ContainerListener {
    public static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(RobotdogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.m_135353_(RobotdogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(RobotdogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_ID_CHEST = SynchedEntityData.m_135353_(RobotdogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ID_TURRET = SynchedEntityData.m_135353_(RobotdogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> PAINTJOB = SynchedEntityData.m_135353_(RobotdogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_ID_ARMOR = SynchedEntityData.m_135353_(RobotdogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ID_SCANNER = SynchedEntityData.m_135353_(RobotdogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final TagKey<Item> bulletTag = ItemTags.create((ResourceLocation)new ResourceLocation("flansmod", "pistol_bullet"));
    public SimpleContainer dogInventory;
    public float scannerAngle = 0.0f;
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public final AnimationState attackAnimationState = new AnimationState();
    public int attackAnimationTimeout = 0;
    public int projectileAttackTick = 0;
    public final AnimationState sitAnimationState = new AnimationState();
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    @Nullable
    private UUID persistentAngerTarget;
    protected SimpleContainer inventory;
    private LazyOptional<?> itemHandler = null;

    public RobotdogEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.initDogInventory();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        } else {
            --this.projectileAttackTick;
        }
        this.scannerAngle += 0.5f;
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0 && !this.m_21825_()) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(30) + 60;
            if (!this.idleAnimationState.m_216984_()) {
                this.idleAnimationState.m_216977_(this.f_19797_);
            }
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isAttacking() && this.attackAnimationTimeout <= 0) {
            this.idleAnimationState.m_216973_();
            this.attackAnimationTimeout = 16;
            this.attackAnimationState.m_216977_(this.f_19797_);
            this.m_7910_(0.0f);
        } else {
            --this.attackAnimationTimeout;
        }
        if (!this.isAttacking()) {
            this.attackAnimationState.m_216973_();
            this.m_7910_(1.0f);
        }
        if (this.m_21825_()) {
            this.sitAnimationState.m_216977_(this.f_19797_);
            this.idleAnimationState.m_216973_();
        } else {
            this.sitAnimationState.m_216973_();
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.25f);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
        this.attackAnimationTimeout = 16;
        this.attackAnimationState.m_216977_(0);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_FLAGS, (Object)0);
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_CHEST, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_TURRET, (Object)false);
        this.f_19804_.m_135372_(PAINTJOB, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_ARMOR, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_SCANNER, (Object)false);
    }

    public void openGUI(Player playerEntity) {
        if (!this.m_9236_().f_46443_ && !this.m_20363_((Entity)playerEntity)) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerEntity), (MenuProvider)new MenuProvider(){

                public AbstractContainerMenu m_7208_(int p_createMenu_1_, Inventory p_createMenu_2_, Player p_createMenu_3_) {
                    return new DispenserMenu(p_createMenu_1_, p_createMenu_2_, (Container)RobotdogEntity.this.dogInventory);
                }

                public Component m_5446_() {
                    return Component.m_237113_((String)"Storage");
                }
            });
        }
    }

    private void initDogInventory() {
        SimpleContainer animalchest = this.dogInventory;
        this.dogInventory = new SimpleContainer(9){

            public void m_5785_(Player player) {
                RobotdogEntity.this.resetSlots();
            }

            public boolean m_6542_(Player player) {
                return RobotdogEntity.this.m_6084_() && !RobotdogEntity.this.f_19817_;
            }
        };
        this.dogInventory.m_19164_((ContainerListener)this);
        if (animalchest != null) {
            int i = Math.min(animalchest.m_6643_(), this.dogInventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = animalchest.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.dogInventory.m_6836_(j, itemstack.m_41777_());
            }
            this.resetSlots();
        }
    }

    public void resetSlots() {
        if (!this.m_9236_().f_46443_) {
            for (int i = 0; i < this.dogInventory.m_6643_(); ++i) {
                ItemStack stack = this.dogInventory.m_8020_(i);
                if (stack.m_41619_()) continue;
            }
            this.updateClientInventory();
        }
    }

    private void updateClientInventory() {
        if (!this.m_9236_().f_46443_) {
            for (int i = 0; i < 9; ++i) {
            }
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RobotDogAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 2.0f));
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42153_}), false));
        this.f_21345_.m_25352_(3, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new SearchForItemsGoal());
        this.f_21345_.m_25352_(5, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.1));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, FlyingMob.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22285_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 5.0);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public boolean m_6898_(ItemStack pStack) {
        Item item = pStack.m_41720_();
        return item == Items.f_42416_;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.m_21660_()) {
            return (SoundEvent)ModSounds.ROBOT_DOG_AMBIENT.get();
        }
        if (this.f_19796_.m_188503_(3) == 0) {
            return this.m_21824_() && this.m_21223_() < 10.0f ? SoundEvents.f_12625_ : SoundEvents.f_12622_;
        }
        return SoundEvents.f_12617_;
    }

    @Nullable
    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_((SoundEvent)ModSounds.SERVO.get(), 0.08f, 1.0f);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12058_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12059_;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        if (this.m_9236_().f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)pPlayer) || this.m_21824_() || itemstack.m_150930_(Items.f_42500_) && !this.m_21824_() && !this.m_21660_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(itemstack.getFoodProperties((LivingEntity)this).m_38744_());
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
                return InteractionResult.SUCCESS;
            }
            if (!this.hasChest() && itemstack.m_150930_(Items.f_42009_)) {
                this.equipChest(pPlayer, itemstack);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (this.hasChest() && !this.hasTurret() && itemstack.m_150930_((Item)ModItems.TURRET_UPGRADE.get())) {
                this.equipTurret(pPlayer, itemstack);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (!this.hasArmor() && itemstack.m_150930_((Item)ModItems.ARMOR_UPGRADE.get())) {
                this.setArmor(true);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (this.hasChest() && !this.hasScanner() && itemstack.m_150930_((Item)ModItems.SCANNER_UPGRADE.get())) {
                this.setScanner(true);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (item instanceof DyeItem || item == ModItems.ROBOT_DOG_VALKYRIE_SKIN.get() || item == ModItems.ROBOT_DOG_BUBBLEGUM_SKIN.get() || item == ModItems.ROBOT_DOG_RACING_SKIN.get()) {
                this.SetPaintFromDye(item);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            InteractionResult interactionresult = super.m_6071_(pPlayer, pHand);
            if (interactionresult != InteractionResult.SUCCESS && pPlayer.m_6144_() && this.m_21830_((LivingEntity)pPlayer) && this.hasChest()) {
                if (!this.m_6162_()) {
                    this.openGUI(pPlayer);
                    this.m_20153_();
                }
                return InteractionResult.SUCCESS;
            }
            if ((!interactionresult.m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)pPlayer)) {
                this.m_21839_(!this.m_21827_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
            return interactionresult;
        }
        if (itemstack.m_150930_(Items.f_42153_) && !this.m_21660_()) {
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)pPlayer)) {
                this.m_21828_(pPlayer);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public void SetPaintFromDye(Item item) {
        if (item == Items.f_42539_) {
            this.setPaintjob(0);
        } else if (item == Items.f_42497_) {
            this.setPaintjob(1);
        } else if (item == Items.f_42535_) {
            this.setPaintjob(2);
        } else if (item == Items.f_42491_) {
            this.setPaintjob(3);
        } else if (item == Items.f_42490_) {
            this.setPaintjob(4);
        } else if (item == Items.f_42498_) {
            this.setPaintjob(5);
        } else if (item == Items.f_42495_) {
            this.setPaintjob(6);
        } else if (item == Items.f_42536_) {
            this.setPaintjob(7);
        } else if (item == Items.f_42540_) {
            this.setPaintjob(8);
        } else if (item == Items.f_42496_) {
            this.setPaintjob(9);
        } else if (item == Items.f_42492_) {
            this.setPaintjob(10);
        } else if (item == Items.f_42538_) {
            this.setPaintjob(11);
        } else if (item == Items.f_42494_) {
            this.setPaintjob(12);
        } else if (item == Items.f_42493_) {
            this.setPaintjob(13);
        } else if (item == Items.f_42537_) {
            this.setPaintjob(14);
        } else if (item == Items.f_42489_) {
            this.setPaintjob(15);
        } else if (item == ModItems.ROBOT_DOG_VALKYRIE_SKIN.get()) {
            this.setPaintjob(16);
        } else if (item == ModItems.ROBOT_DOG_BUBBLEGUM_SKIN.get()) {
            this.setPaintjob(17);
        } else if (item == ModItems.ROBOT_DOG_RACING_SKIN.get()) {
            this.setPaintjob(18);
        }
    }

    public void m_7105_(boolean pTamed) {
        super.m_7105_(pTamed);
        if (pTamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            this.m_21153_(20.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
        }
        this.m_21051_(Attributes.f_22281_).m_22100_(4.0);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int pTime) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)pTime);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @javax.annotation.Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@javax.annotation.Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        Entity entity = pSource.m_7639_();
        if (!this.m_9236_().f_46443_) {
            this.m_21839_(false);
        }
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            pAmount = (pAmount + 1.0f) / 2.0f;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_21666_(ServerLevel pServerLevel, boolean pUpdateAnger) {
        LivingEntity livingentity = this.m_5448_();
        UUID uuid = this.m_6120_();
        if ((livingentity == null || livingentity.m_21224_()) && uuid != null && pServerLevel.m_8791_(uuid) instanceof Mob) {
            this.m_21662_();
        } else {
            if (livingentity != null && !Objects.equals(uuid, livingentity.m_20148_())) {
                this.m_6925_(livingentity.m_20148_());
                this.m_6825_();
            }
            if (!(this.m_6784_() <= 0 || livingentity != null && livingentity.m_6095_() == EntityType.f_20532_ && pUpdateAnger)) {
                this.m_7870_(this.m_6784_() - 1);
                if (this.m_6784_() == 0) {
                    this.m_21662_();
                }
            }
        }
    }

    public boolean hasChest() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_CHEST);
    }

    public void setChest(boolean pChested) {
        this.f_19804_.m_135381_(DATA_ID_CHEST, (Object)pChested);
    }

    public boolean hasArmor() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_ARMOR);
    }

    public void setArmor(boolean pChested) {
        this.f_19804_.m_135381_(DATA_ID_ARMOR, (Object)pChested);
        if (pChested) {
            this.m_21051_(Attributes.f_22284_).m_22100_(8.0);
        } else {
            this.m_21051_(Attributes.f_22284_).m_22100_(0.0);
        }
    }

    public int getPaintjob() {
        return (Integer)this.f_19804_.m_135370_(PAINTJOB);
    }

    public void setPaintjob(int id) {
        this.f_19804_.m_135381_(PAINTJOB, (Object)id);
    }

    public boolean hasTurret() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_TURRET);
    }

    public boolean hasTurretAmmo() {
        for (int i = 0; i < this.dogInventory.m_6643_(); ++i) {
            ItemStack s = this.dogInventory.m_8020_(i);
            if (!s.m_204117_(bulletTag)) continue;
            return true;
        }
        return false;
    }

    public void ConsumeAmmo() {
        for (int i = 0; i < this.dogInventory.m_6643_(); ++i) {
            ItemStack s = this.dogInventory.m_8020_(i);
            if (!s.m_204117_(bulletTag)) continue;
            s.m_41774_(1);
            ItemStack casing = new ItemStack((ItemLike)ModItems.PISTOL_CASING.get(), 1);
            ItemEntity created = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), casing);
            created.m_32060_();
            created.m_32060_();
            created.m_20256_(VecHelper.offsetRandomly((Vec3)new Vec3(0.0, 0.5, 0.0), (RandomSource)this.m_9236_().f_46441_, (float)0.05f));
            this.m_9236_().m_7967_((Entity)created);
            return;
        }
    }

    public void setTurret(boolean turret) {
        this.f_19804_.m_135381_(DATA_ID_TURRET, (Object)turret);
    }

    public boolean hasScanner() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_SCANNER);
    }

    public void setScanner(boolean turret) {
        this.f_19804_.m_135381_(DATA_ID_SCANNER, (Object)turret);
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.hasChest()) {
            if (!this.m_9236_().f_46443_) {
                this.m_19998_((ItemLike)Blocks.f_50087_);
            }
            for (int i = 0; i < this.dogInventory.m_6643_(); ++i) {
                this.m_19983_(this.dogInventory.m_8020_(i));
            }
            this.dogInventory.m_6211_();
            this.setChest(false);
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("robotdog_chest", this.hasChest());
        pCompound.m_128379_("robotdog_turret", this.hasTurret());
        pCompound.m_128405_("robotdog_paint", this.getPaintjob());
        pCompound.m_128379_("robotdog_armor", this.hasArmor());
        pCompound.m_128379_("robotdog_scanner", this.hasScanner());
        if (this.hasChest()) {
            ListTag nbttaglist = new ListTag();
            for (int i = 0; i < this.dogInventory.m_6643_(); ++i) {
                ItemStack itemstack = this.dogInventory.m_8020_(i);
                if (itemstack.m_41619_()) continue;
                CompoundTag CompoundNBT = new CompoundTag();
                CompoundNBT.m_128344_("Slot", (byte)i);
                itemstack.m_41739_(CompoundNBT);
                nbttaglist.add((Object)CompoundNBT);
            }
            pCompound.m_128365_("Items", (Tag)nbttaglist);
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setChest(pCompound.m_128471_("robotdog_chest"));
        this.setTurret(pCompound.m_128471_("robotdog_turret"));
        this.setPaintjob(pCompound.m_128451_("robotdog_paint"));
        this.setArmor(pCompound.m_128471_("robotdog_armor"));
        this.setScanner(pCompound.m_128471_("robotdog_scanner"));
        if (this.hasChest()) {
            if (this.dogInventory != null) {
                ListTag nbttaglist = pCompound.m_128437_("Items", 10);
                this.initDogInventory();
                for (int i = 0; i < nbttaglist.size(); ++i) {
                    CompoundTag CompoundNBT = nbttaglist.m_128728_(i);
                    int j = CompoundNBT.m_128445_("Slot") & 0xFF;
                    this.dogInventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)CompoundNBT));
                }
            } else {
                ListTag nbttaglist = pCompound.m_128437_("Items", 10);
                this.initDogInventory();
                for (int i = 0; i < nbttaglist.size(); ++i) {
                    CompoundTag CompoundNBT = nbttaglist.m_128728_(i);
                    int j = CompoundNBT.m_128445_("Slot") & 0xFF;
                    this.initDogInventory();
                    this.dogInventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)CompoundNBT));
                }
            }
            this.resetSlots();
        }
    }

    public SlotAccess m_141942_(int pSlot) {
        return pSlot == 499 ? new SlotAccess(){

            public ItemStack m_142196_() {
                return RobotdogEntity.this.hasChest() ? new ItemStack((ItemLike)Items.f_42009_) : ItemStack.f_41583_;
            }

            public boolean m_142104_(ItemStack p_149485_) {
                if (p_149485_.m_41619_()) {
                    if (RobotdogEntity.this.hasChest()) {
                        RobotdogEntity.this.setChest(false);
                    }
                    return true;
                }
                if (p_149485_.m_150930_(Items.f_42009_)) {
                    if (!RobotdogEntity.this.hasChest()) {
                        RobotdogEntity.this.setChest(true);
                    }
                    return true;
                }
                return false;
            }
        } : super.m_141942_(pSlot);
    }

    private void equipChest(Player pPlayer, ItemStack pChestStack) {
        this.setChest(true);
        if (!pPlayer.m_150110_().f_35937_) {
            pChestStack.m_41774_(1);
        }
    }

    private void equipTurret(Player pPlayer, ItemStack pChestStack) {
        this.setTurret(true);
    }

    public void m_5757_(Container pContainer) {
    }

    protected void m_7581_(ItemEntity pItemEntity) {
        if (!this.hasScanner()) {
            return;
        }
        ItemStack itemstack = pItemEntity.m_32055_();
        if (this.dogInventory.m_19183_(itemstack)) {
            int i = itemstack.m_41613_();
            this.dogInventory.m_19173_(itemstack);
            pItemEntity.m_146870_();
        }
    }

    public boolean m_7066_(ItemStack pItemstack) {
        return this.hasScanner();
    }

    class SearchForItemsGoal
    extends Goal {
        public SearchForItemsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!RobotdogEntity.this.hasScanner()) {
                return false;
            }
            if (RobotdogEntity.this.m_5448_() == null) {
                List list = RobotdogEntity.this.m_9236_().m_45976_(ItemEntity.class, RobotdogEntity.this.m_20191_().m_82377_(8.0, 8.0, 8.0));
                return !list.isEmpty();
            }
            return false;
        }

        public void m_8037_() {
            List list = RobotdogEntity.this.m_9236_().m_45976_(ItemEntity.class, RobotdogEntity.this.m_20191_().m_82377_(8.0, 8.0, 8.0));
            if (!list.isEmpty() && RobotdogEntity.this.dogInventory.m_19183_(((ItemEntity)list.get(0)).m_32055_())) {
                RobotdogEntity.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
                if (RobotdogEntity.this.m_20280_((Entity)list.get(0)) <= 2.0) {
                    RobotdogEntity.this.m_7581_((ItemEntity)list.get(0));
                }
            }
        }

        public void m_8056_() {
            List list = RobotdogEntity.this.m_9236_().m_45976_(ItemEntity.class, RobotdogEntity.this.m_20191_().m_82377_(8.0, 8.0, 8.0));
            if (!list.isEmpty() && RobotdogEntity.this.dogInventory.m_19183_(((ItemEntity)list.get(0)).m_32055_())) {
                RobotdogEntity.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }
    }
}

