/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.undertalemod;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.undertalemod.UndertaleModMod;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.forgespi.language.ModFileScanData;

public class UndertaleModModElements {
    public final List<ModElement> elements = new ArrayList<ModElement>();
    public final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    public final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    public final List<Supplier<EntityType<?>>> entities = new ArrayList();
    public final List<Supplier<Enchantment>> enchantments = new ArrayList<Supplier<Enchantment>>();
    public static Map<ResourceLocation, SoundEvent> sounds = new HashMap<ResourceLocation, SoundEvent>();
    private int messageID = 0;

    public UndertaleModModElements() {
        sounds.put(new ResourceLocation("undertale_mod", "yellow_shoot"), new SoundEvent(new ResourceLocation("undertale_mod", "yellow_shoot")));
        sounds.put(new ResourceLocation("undertale_mod", "level_up"), new SoundEvent(new ResourceLocation("undertale_mod", "level_up")));
        sounds.put(new ResourceLocation("undertale_mod", "use"), new SoundEvent(new ResourceLocation("undertale_mod", "use")));
        sounds.put(new ResourceLocation("undertale_mod", "save"), new SoundEvent(new ResourceLocation("undertale_mod", "save")));
        sounds.put(new ResourceLocation("undertale_mod", "dust"), new SoundEvent(new ResourceLocation("undertale_mod", "dust")));
        sounds.put(new ResourceLocation("undertale_mod", "chara"), new SoundEvent(new ResourceLocation("undertale_mod", "chara")));
        sounds.put(new ResourceLocation("undertale_mod", "chara_death"), new SoundEvent(new ResourceLocation("undertale_mod", "chara_death")));
        sounds.put(new ResourceLocation("undertale_mod", "chara_crit"), new SoundEvent(new ResourceLocation("undertale_mod", "chara_crit")));
        sounds.put(new ResourceLocation("undertale_mod", "knife_attack"), new SoundEvent(new ResourceLocation("undertale_mod", "knife_attack")));
        sounds.put(new ResourceLocation("undertale_mod", "heal"), new SoundEvent(new ResourceLocation("undertale_mod", "heal")));
        sounds.put(new ResourceLocation("undertale_mod", "flowey_theme"), new SoundEvent(new ResourceLocation("undertale_mod", "flowey_theme")));
        sounds.put(new ResourceLocation("undertale_mod", "flowey_hit"), new SoundEvent(new ResourceLocation("undertale_mod", "flowey_hit")));
        sounds.put(new ResourceLocation("undertale_mod", "omega_flowey_theme"), new SoundEvent(new ResourceLocation("undertale_mod", "omega_flowey_theme")));
        sounds.put(new ResourceLocation("undertale_mod", "wind"), new SoundEvent(new ResourceLocation("undertale_mod", "wind")));
        sounds.put(new ResourceLocation("undertale_mod", "omega_flowey_hurt"), new SoundEvent(new ResourceLocation("undertale_mod", "omega_flowey_hurt")));
        sounds.put(new ResourceLocation("undertale_mod", "flowey_talkink"), new SoundEvent(new ResourceLocation("undertale_mod", "flowey_talkink")));
        sounds.put(new ResourceLocation("undertale_mod", "flee"), new SoundEvent(new ResourceLocation("undertale_mod", "flee")));
        sounds.put(new ResourceLocation("undertale_mod", "fan_activate"), new SoundEvent(new ResourceLocation("undertale_mod", "fan_activate")));
        sounds.put(new ResourceLocation("undertale_mod", "none"), new SoundEvent(new ResourceLocation("undertale_mod", "none")));
        sounds.put(new ResourceLocation("undertale_mod", "stone"), new SoundEvent(new ResourceLocation("undertale_mod", "stone")));
        sounds.put(new ResourceLocation("undertale_mod", "pisc"), new SoundEvent(new ResourceLocation("undertale_mod", "pisc")));
        sounds.put(new ResourceLocation("undertale_mod", "hoi1"), new SoundEvent(new ResourceLocation("undertale_mod", "hoi1")));
        sounds.put(new ResourceLocation("undertale_mod", "hoi2"), new SoundEvent(new ResourceLocation("undertale_mod", "hoi2")));
        sounds.put(new ResourceLocation("undertale_mod", "buy"), new SoundEvent(new ResourceLocation("undertale_mod", "buy")));
        sounds.put(new ResourceLocation("undertale_mod", "temmy_theme"), new SoundEvent(new ResourceLocation("undertale_mod", "temmy_theme")));
        sounds.put(new ResourceLocation("undertale_mod", "sans_tp"), new SoundEvent(new ResourceLocation("undertale_mod", "sans_tp")));
        try {
            ModFileScanData modFileInfo = ModList.get().getModFileById("undertale_mod").getFile().getScanResult();
            Set annotations = modFileInfo.getAnnotations();
            for (ModFileScanData.AnnotationData annotationData : annotations) {
                Class<?> clazz;
                if (!annotationData.getAnnotationType().getClassName().equals(ModElement.Tag.class.getName()) || (clazz = Class.forName(annotationData.getClassType().getClassName())).getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (Map.Entry<ResourceLocation, SoundEvent> sound : sounds.entrySet()) {
            event.getRegistry().register(sound.getValue().setRegistryName(sound.getKey()));
        }
    }

    public <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        UndertaleModMod.PACKET_HANDLER.registerMessage(this.messageID, messageType, encoder, decoder, messageConsumer);
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<EntityType<?>>> getEntities() {
        return this.entities;
    }

    public List<Supplier<Enchantment>> getEnchantments() {
        return this.enchantments;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final UndertaleModModElements elements;
        protected final int sortid;

        public ModElement(UndertaleModModElements elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLCommonSetupEvent event) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public void clientLoad(FMLClientSetupEvent event) {
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }
}

