/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.infernalcraft.init;

import net.mcreator.infernalcraft.entity.BadgerEntity;
import net.mcreator.infernalcraft.entity.DaisyEntity;
import net.mcreator.infernalcraft.entity.EtherealSpecterEntity;
import net.mcreator.infernalcraft.entity.InfernalspiritEntity;
import net.mcreator.infernalcraft.entity.MadGuardEntity;
import net.mcreator.infernalcraft.entity.SilentButcherEntity;
import net.mcreator.infernalcraft.entity.SilentWandererEntity;
import net.mcreator.infernalcraft.entity.SpidraptorEntity;
import net.mcreator.infernalcraft.entity.SswEntity;
import net.mcreator.infernalcraft.entity.TwilightWolfEntity;
import net.mcreator.infernalcraft.entity.ZephyrEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class InfernalCraftModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"infernal_craft");
    public static final RegistryObject<EntityType<SpidraptorEntity>> SPIDRAPTOR = InfernalCraftModEntities.register("spidraptor", EntityType.Builder.m_20704_(SpidraptorEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(SpidraptorEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<ZephyrEntity>> ZEPHYR = InfernalCraftModEntities.register("zephyr", EntityType.Builder.m_20704_(ZephyrEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(ZephyrEntity::new).m_20699_(0.4f, 1.3f));
    public static final RegistryObject<EntityType<InfernalspiritEntity>> INFERNALSPIRIT = InfernalCraftModEntities.register("infernalspirit", EntityType.Builder.m_20704_(InfernalspiritEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(InfernalspiritEntity::new).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<EtherealSpecterEntity>> ETHEREAL_SPECTER = InfernalCraftModEntities.register("ethereal_specter", EntityType.Builder.m_20704_(EtherealSpecterEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(EtherealSpecterEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<MadGuardEntity>> MAD_GUARD = InfernalCraftModEntities.register("mad_guard", EntityType.Builder.m_20704_(MadGuardEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(MadGuardEntity::new).m_20699_(1.2f, 1.4f));
    public static final RegistryObject<EntityType<SswEntity>> SSW = InfernalCraftModEntities.register("ssw", EntityType.Builder.m_20704_(SswEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(SswEntity::new).m_20699_(1.0f, 2.0f));
    public static final RegistryObject<EntityType<DaisyEntity>> DAISY = InfernalCraftModEntities.register("daisy", EntityType.Builder.m_20704_(DaisyEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(DaisyEntity::new).m_20699_(1.2f, 0.8f));
    public static final RegistryObject<EntityType<BadgerEntity>> BADGER = InfernalCraftModEntities.register("badger", EntityType.Builder.m_20704_(BadgerEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(BadgerEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<TwilightWolfEntity>> TWILIGHT_WOLF = InfernalCraftModEntities.register("twilight_wolf", EntityType.Builder.m_20704_(TwilightWolfEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(TwilightWolfEntity::new).m_20699_(2.0f, 1.8f));
    public static final RegistryObject<EntityType<SilentWandererEntity>> SILENT_WANDERER = InfernalCraftModEntities.register("silent_wanderer", EntityType.Builder.m_20704_(SilentWandererEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(SilentWandererEntity::new).m_20699_(0.8f, 1.8f));
    public static final RegistryObject<EntityType<SilentButcherEntity>> SILENT_BUTCHER = InfernalCraftModEntities.register("silent_butcher", EntityType.Builder.m_20704_(SilentButcherEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(SilentButcherEntity::new).m_20699_(0.8f, 1.8f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            SpidraptorEntity.init();
            ZephyrEntity.init();
            InfernalspiritEntity.init();
            EtherealSpecterEntity.init();
            MadGuardEntity.init();
            SswEntity.init();
            DaisyEntity.init();
            BadgerEntity.init();
            TwilightWolfEntity.init();
            SilentWandererEntity.init();
            SilentButcherEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SPIDRAPTOR.get(), SpidraptorEntity.createAttributes().m_22265_());
        event.put((EntityType)ZEPHYR.get(), ZephyrEntity.createAttributes().m_22265_());
        event.put((EntityType)INFERNALSPIRIT.get(), InfernalspiritEntity.createAttributes().m_22265_());
        event.put((EntityType)ETHEREAL_SPECTER.get(), EtherealSpecterEntity.createAttributes().m_22265_());
        event.put((EntityType)MAD_GUARD.get(), MadGuardEntity.createAttributes().m_22265_());
        event.put((EntityType)SSW.get(), SswEntity.createAttributes().m_22265_());
        event.put((EntityType)DAISY.get(), DaisyEntity.createAttributes().m_22265_());
        event.put((EntityType)BADGER.get(), BadgerEntity.createAttributes().m_22265_());
        event.put((EntityType)TWILIGHT_WOLF.get(), TwilightWolfEntity.createAttributes().m_22265_());
        event.put((EntityType)SILENT_WANDERER.get(), SilentWandererEntity.createAttributes().m_22265_());
        event.put((EntityType)SILENT_BUTCHER.get(), SilentButcherEntity.createAttributes().m_22265_());
    }
}

