/*
 * Decompiled with CFR 0.152.
 */
package net.notbrianbob.lightoverlay;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.notbrianbob.lightoverlay.LightOverlay;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LightLevel {
    private static final int radius = 10;

    @SubscribeEvent
    public static void onRenderWorld(RenderLevelStageEvent event) {
        if (LightOverlay.isOverlayEnabled) {
            Minecraft mc = Minecraft.m_91087_();
            if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS || mc.f_91074_ == null || mc.f_91073_ == null) {
                return;
            }
            PoseStack poseStack = event.getPoseStack();
            EntityRenderDispatcher dispatcher = mc.m_91290_();
            Vec3 cameraPos = dispatcher.f_114358_.m_90583_();
            poseStack.m_85836_();
            poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
            LightLevel.checkLightLevelsAroundPlayer(poseStack, mc.f_91062_, Minecraft.m_91087_().m_91269_().m_110104_());
            poseStack.m_85849_();
        }
    }

    public static void checkLightLevelsAroundPlayer(PoseStack poseStack, Font font, MultiBufferSource.BufferSource buffer) {
        Minecraft mc = Minecraft.m_91087_();
        BlockPos playerPos = mc.f_91074_.m_20183_();
        for (int x = -10; x <= 10; ++x) {
            for (int z = -10; z <= 10; ++z) {
                for (int y = -10; y <= 10; ++y) {
                    BlockPos checkPos = playerPos.m_7918_(x, y, z);
                    BlockPos blockBelowPos = checkPos.m_7495_();
                    if (mc.f_91073_.m_46859_(blockBelowPos)) continue;
                    int blockLightLevel = mc.f_91073_.m_45517_(LightLayer.BLOCK, checkPos);
                    int color = LightLevel.getColorByLightLevel(blockLightLevel);
                    LightLevel.renderTextAtBlock(poseStack, font, String.valueOf(blockLightLevel), checkPos, color, (MultiBufferSource)buffer);
                }
            }
        }
    }

    private static int getColorByLightLevel(int blockLightLevel) {
        Minecraft mc = Minecraft.m_91087_();
        int skyLightLevel = mc.f_91073_.m_45517_(LightLayer.SKY, mc.f_91074_.m_20183_().m_7494_());
        if (blockLightLevel >= 8) {
            return 65280;
        }
        if (blockLightLevel < 8 && skyLightLevel >= 8) {
            return 0xFFFF00;
        }
        return 0xFF0000;
    }

    private static void renderTextAtBlock(PoseStack poseStack, Font font, String text, BlockPos pos, int color, MultiBufferSource buffer) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.3, (double)pos.m_123343_() + 0.5);
        poseStack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
        poseStack.m_85841_(-0.03f, -0.03f, 0.03f);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        int packedLight = 0xF000F0;
        int transparentColor = -1728053248;
        font.m_271703_(text, (float)(-font.m_92895_(text)) / 2.0f, 0.0f, color, false, matrix, buffer, Font.DisplayMode.NORMAL, transparentColor, packedLight);
        poseStack.m_85849_();
    }
}

