/*
 * Decompiled with CFR 0.152.
 */
package com.dementia.neurocraft.client;

import com.dementia.neurocraft.common.Common;
import com.dementia.neurocraft.network.PacketHandler;
import com.dementia.neurocraft.network.SRefreshClientBlockList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="neurocraft", value={Dist.CLIENT})
public class ClientBlockVerify {
    public static final List<BlockPos> hallucinationBlocks = new ArrayList<BlockPos>();
    private static int tickC = 1;

    @SubscribeEvent
    public static void onClientBreakBlockEvent(PlayerInteractEvent.LeftClickBlock event) {
        BlockPos pos;
        if (event.getAction() == PlayerInteractEvent.LeftClickBlock.Action.STOP && ClientBlockVerify.arrayContainsBlockPos(pos = event.getPos())) {
            ClientBlockVerify.removeHallucinationBlocks(pos);
        }
    }

    public static void addToHallucinationBlocks(List<BlockPos> blocks) {
        hallucinationBlocks.addAll(blocks);
    }

    public static int getHallucinationBlockSize(int[] blocks) {
        return hallucinationBlocks.size();
    }

    public static List<BlockPos> getHallucinationBlocks() {
        return hallucinationBlocks;
    }

    @SubscribeEvent
    public static void onClientPlaceBlockEvent(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        BlockPos pos = ClientBlockVerify.getPlayerPOVHitResult((Level)event.getLevel(), player, ClipContext.Fluid.NONE).m_82425_();
        if (ClientBlockVerify.arrayContainsBlockPos(pos)) {
            ClientBlockVerify.removeHallucinationBlocks(pos);
            event.setCanceled(true);
        }
    }

    @NotNull
    public static Vec3 clipWithDistance(@NotNull Player player, @NotNull Level level, double clipDistance) {
        double vecX = Math.sin((double)(-player.m_146908_()) * (Math.PI / 180) - Math.PI) * -Math.cos((double)(-player.m_146909_()) * (Math.PI / 180));
        double vecY = Math.sin((double)(-player.m_146909_()) * (Math.PI / 180));
        double vecZ = Math.cos((double)(-player.m_146908_()) * (Math.PI / 180) - Math.PI) * -Math.cos((double)(-player.m_146909_()) * (Math.PI / 180));
        return level.m_45547_(new ClipContext(player.m_146892_(), player.m_146892_().m_82520_(vecX * clipDistance, vecY * clipDistance, vecZ * clipDistance), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player)).m_82450_();
    }

    public static void removeHallucinationBlocks(BlockPos pos) {
        hallucinationBlocks.remove(pos);
        PacketHandler.sendToServer(new SRefreshClientBlockList(SRefreshClientBlockList.toIntArray(pos)));
        Common.HallucinationOccuredClient();
    }

    public static void removeHallucinationBlocks(BlockPos pos, Iterator<BlockPos> ite) {
        ite.remove();
        hallucinationBlocks.remove(pos);
        PacketHandler.sendToServer(new SRefreshClientBlockList(SRefreshClientBlockList.toIntArray(pos)));
        Common.HallucinationOccuredClient();
    }

    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.side != LogicalSide.CLIENT) {
            return;
        }
        Player player = event.player;
        if (tickC++ == 5) {
            BlockPos onPos = player.m_20097_();
            Iterator<BlockPos> iterator = hallucinationBlocks.iterator();
            while (iterator.hasNext()) {
                BlockPos block = iterator.next();
                if (player.m_9236_().m_8055_(block).m_60734_() == Blocks.f_50016_) {
                    int dx = Math.abs(onPos.m_123341_() - block.m_123341_());
                    int dy = Math.abs(onPos.m_123342_() - block.m_123342_());
                    int dz = Math.abs(onPos.m_123343_() - block.m_123343_());
                    if (dx > 1 || dy > 3 || dz > 1) continue;
                    ClientBlockVerify.removeHallucinationBlocks(block, iterator);
                    continue;
                }
                if (block.m_123341_() != onPos.m_123341_() || block.m_123342_() != onPos.m_123342_() || block.m_123343_() != onPos.m_123343_()) continue;
                ClientBlockVerify.removeHallucinationBlocks(block, iterator);
            }
            tickC = 0;
        }
    }

    protected static BlockHitResult getPlayerPOVHitResult(Level level, Player player, ClipContext.Fluid context) {
        float f = player.m_146909_();
        float f1 = player.m_146908_();
        Vec3 vec3 = player.m_146892_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.getBlockReach();
        Vec3 vec31 = vec3.m_82520_((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return level.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, context, (Entity)player));
    }

    public static boolean arrayContainsBlockPos(BlockPos blockPos) {
        for (BlockPos block : hallucinationBlocks) {
            if (block.m_123341_() != blockPos.m_123341_() || block.m_123342_() != blockPos.m_123342_() || block.m_123343_() != blockPos.m_123343_()) continue;
            return true;
        }
        return false;
    }
}

