/*
 * Decompiled with CFR 0.152.
 */
package com.dementia.neurocraft.client;

import com.dementia.neurocraft.common.Common;
import com.dementia.neurocraft.network.PacketHandler;
import com.dementia.neurocraft.network.SRemoveHallucinationPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;

public class ClientHallucinations {
    static int c = 1;
    public static List<Entity> playerEntities = new ArrayList<Entity>();
    static Map<Entity, Boolean> hallucinationsViewed = new HashMap<Entity, Boolean>();

    public static void onClientTick(TickEvent.PlayerTickEvent tick) {
        if (tick.phase == TickEvent.Phase.END && ++c == 5) {
            if (Minecraft.m_91087_().f_91073_ != null) {
                ClientHallucinations.checkPlayerHallucinationViewings();
            }
            c = 1;
        }
    }

    public static void checkPlayerHallucinationViewings() {
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        if (p == null) {
            return;
        }
        for (int i = playerEntities.size() - 1; i >= 0; --i) {
            boolean isInPlayerFOV;
            Entity entity = playerEntities.get(i);
            if (!(entity instanceof LivingEntity)) continue;
            if (entity.m_20270_((Entity)p) >= 12.0f) {
                PacketHandler.sendToServer(new SRemoveHallucinationPacket(entity.m_19879_()));
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if ((isInPlayerFOV = ClientHallucinations.inPlayerFOV((Player)p, entity)) && !ClientHallucinations.getHallucinationViewed(entity)) {
                ClientHallucinations.setHallucinationViewed(entity, true);
                continue;
            }
            if (isInPlayerFOV || !ClientHallucinations.getHallucinationViewed(entity) || entity.m_213877_()) continue;
            PacketHandler.sendToServer(new SRemoveHallucinationPacket(entity.m_19879_()));
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
            Common.HallucinationOccuredClient();
        }
    }

    private static boolean inPlayerFOV(Player player, Entity entity) {
        if (player == null) {
            return true;
        }
        Vec3 visionVec = player.m_20154_().m_82541_();
        Vec3 targetVec = new Vec3(entity.m_20185_() - player.m_20185_(), entity.m_20191_().f_82289_ + (double)(entity.m_20192_() / 2.0f) - (player.m_20186_() + (double)player.m_20192_()), entity.m_20189_() - player.m_20189_());
        double dotProduct = visionVec.m_82526_(targetVec = targetVec.m_82541_());
        boolean inFOV = dotProduct > 0.1 && player.m_142582_(entity);
        return inFOV;
    }

    public static boolean getHallucinationViewed(Entity entity) {
        Boolean hallViewed = hallucinationsViewed.get(entity);
        if (hallViewed == null) {
            return false;
        }
        return hallViewed;
    }

    public static void setHallucinationViewed(Entity entity, boolean state) {
        hallucinationsViewed.put(entity, state);
    }
}

