/*
 * Decompiled with CFR 0.152.
 */
package com.dementia.neurocraft.client;

import com.dementia.neurocraft.client.ClientOptionsChanges;
import com.dementia.neurocraft.common.ClientSoundManager;
import com.dementia.neurocraft.network.PacketHandler;
import com.dementia.neurocraft.network.SForceBlockUpdatePacket;
import com.dementia.neurocraft.network.SRefreshClientBlockList;
import com.dementia.neurocraft.server.BlockPlaceHallucinations;
import com.dementia.neurocraft.util.ModBlocksRegistry;
import com.dementia.neurocraft.util.ModSoundEventsRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="neurocraft", value={Dist.CLIENT})
public class RandomizeTextures {
    public static boolean crazyRenderingActive = false;
    private static boolean prevCRA = false;
    private static boolean typeWASNORENDER = false;
    private static int c = 0;
    public static final HashSet<BlockPos> changedBlocks = new HashSet();
    public static final HashSet<BlockPos> changedLiquids = new HashSet();

    @SubscribeEvent
    public static void onClientRenderEvent(RenderLevelStageEvent event) {
        if (c++ % 400 == 0 || prevCRA != crazyRenderingActive) {
            if (prevCRA != crazyRenderingActive) {
                prevCRA = crazyRenderingActive;
            }
            Minecraft instance = Minecraft.m_91087_();
            LocalPlayer player = instance.f_91074_;
            if (player == null) {
                return;
            }
            Level level = player.m_9236_();
            if (crazyRenderingActive) {
                HashMap<BlockPos, BlockState> nearbyBlocks = RandomizeTextures.getBlocksInRadius(level, player.m_20097_(), 5);
                if (new Random().nextBoolean()) {
                    nearbyBlocks.forEach((pos, state) -> {
                        Block block = state.m_60734_();
                        if (block != Blocks.f_50016_ && block != Blocks.f_50627_ && block != Blocks.f_50626_) {
                            Block v1 = (Block)ModBlocksRegistry.SMOOTH_BLOCK.get();
                            player.f_108545_.m_7731_(pos, v1.m_49966_(), 1);
                            if (block instanceof LiquidBlock || block instanceof IFluidBlock) {
                                changedLiquids.add((BlockPos)pos);
                            } else {
                                changedBlocks.add((BlockPos)pos);
                            }
                        }
                    });
                    if (!typeWASNORENDER) {
                        ClientSoundManager.playSoundRandomPitchVolume((SoundEvent)ModSoundEventsRegistry.STATICSWITCH.get());
                    }
                    typeWASNORENDER = true;
                } else {
                    nearbyBlocks.forEach((pos, state) -> {
                        Block block = state.m_60734_();
                        if (block != Blocks.f_50016_ && block != Blocks.f_50627_ && block != Blocks.f_50626_) {
                            BlockState v1 = BlockPlaceHallucinations.getRandomBlock();
                            player.f_108545_.m_7731_(pos, v1, 1);
                            if (block instanceof LiquidBlock || block instanceof IFluidBlock) {
                                changedLiquids.add((BlockPos)pos);
                            } else {
                                changedBlocks.add((BlockPos)pos);
                            }
                        }
                    });
                    if (typeWASNORENDER) {
                        ClientSoundManager.playSound((SoundEvent)ModSoundEventsRegistry.STATICSWITCH.get(), 0.25f, 1.0f);
                    }
                    typeWASNORENDER = false;
                }
            }
            if (!crazyRenderingActive) {
                if (!changedBlocks.isEmpty()) {
                    for (BlockPos pos2 : changedBlocks) {
                        PacketHandler.sendToServer(new SForceBlockUpdatePacket(SRefreshClientBlockList.toIntArray(pos2)));
                    }
                    changedBlocks.clear();
                }
                if (!changedLiquids.isEmpty()) {
                    for (BlockPos pos2 : changedLiquids) {
                        PacketHandler.sendToServer(new SForceBlockUpdatePacket(SRefreshClientBlockList.toIntArray(pos2)));
                    }
                    changedBlocks.clear();
                }
            }
            c = 1;
        }
    }

    @SubscribeEvent
    public static void onRespawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        if (crazyRenderingActive) {
            Minecraft instance = Minecraft.m_91087_();
            LocalPlayer player = instance.f_91074_;
            if (player == null) {
                return;
            }
            crazyRenderingActive = false;
            if (ClientOptionsChanges.currentSchitzoMusic != null) {
                ClientSoundManager.stopSound(ClientOptionsChanges.currentSchitzoMusic);
            }
        }
    }

    public static HashMap<BlockPos, BlockState> getBlocksInRadius(Level level, BlockPos center, int radius) {
        HashMap<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -2; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos = center.m_7918_(x, y, z);
                    BlockState state = level.m_8055_(pos);
                    blocks.put(pos, state);
                }
            }
        }
        return blocks;
    }
}

