/*
 * Decompiled with CFR 0.152.
 */
package com.dementia.neurocraft.gui.OptionsMenus;

import com.dementia.neurocraft.config.NewWorldConfigs;
import com.dementia.neurocraft.config.ServerConfigs;
import com.mojang.serialization.Codec;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

public class ModOptionsScreen
extends Screen {
    protected final Screen lastScreen;
    protected OptionsList list;
    protected String lang_prefix;
    protected ArrayList<ForgeConfigSpec.ConfigValue> all_options = new ArrayList();
    private boolean newWorldConfig = false;

    public ModOptionsScreen(Screen lastScreen, Component title, String lang_prefix) {
        super(title);
        this.lastScreen = lastScreen;
        this.lang_prefix = lang_prefix;
    }

    protected void addSliders(Map<String, ForgeConfigSpec.ConfigValue<Integer>> options) {
        ArrayList<OptionInstance<Integer>> sliderOptions = new ArrayList<OptionInstance<Integer>>();
        for (Map.Entry<String, ForgeConfigSpec.ConfigValue<Integer>> entry : options.entrySet()) {
            sliderOptions.add(this.createSliderFromConfig(entry.getKey(), entry.getValue()));
        }
        OptionInstance[] ret = new OptionInstance[sliderOptions.size()];
        ret = sliderOptions.toArray(ret);
        this.list.m_232533_(ret);
    }

    protected void addBooleans(Map<String, ForgeConfigSpec.ConfigValue<Boolean>> options) {
        ArrayList<OptionInstance> sliderOptions = new ArrayList<OptionInstance>();
        for (Map.Entry<String, ForgeConfigSpec.ConfigValue<Boolean>> entry : options.entrySet()) {
            sliderOptions.add(this.createBooleanButtonFromConfig(entry.getKey(), entry.getValue()));
        }
        OptionInstance[] ret = new OptionInstance[sliderOptions.size()];
        ret = sliderOptions.toArray(ret);
        this.list.m_232533_(ret);
    }

    protected OptionInstance<Integer> createSliderFromConfig(String name, ForgeConfigSpec.ConfigValue<Integer> config) {
        String disp_name = Component.m_237115_((String)(this.lang_prefix + name)).getString();
        String prefix = disp_name + ": ";
        String suffix = name.equals("SCALING_INTERVAL") ? " sec" : "";
        Map.Entry<Integer, Integer> range = this.newWorldConfig ? NewWorldConfigs.RANGES.get(config) : ServerConfigs.RANGES.get(config);
        return new OptionInstance(disp_name, OptionInstance.m_231498_(), (label, val) -> Component.m_237113_((String)(prefix + val + suffix)), (OptionInstance.ValueSet)new OptionInstance.IntRange(range.getKey().intValue(), range.getValue().intValue()).m_231657_(val -> val, val -> val), Codec.intRange((int)range.getKey(), (int)range.getValue()), (Object)((Integer)config.get()), arg_0 -> config.set(arg_0));
    }

    protected void resetValuesToDefault() {
        for (ForgeConfigSpec.ConfigValue opt : this.all_options) {
            opt.set(opt.getDefault());
        }
        this.m_232761_();
    }

    protected OptionInstance createBooleanButtonFromConfig(String name, ForgeConfigSpec.ConfigValue<Boolean> config) {
        ArrayList<String> bools = new ArrayList<String>((Boolean)config.get() != false ? Arrays.asList("true", "false") : Arrays.asList("false", "true"));
        name = Component.m_237115_((String)(this.lang_prefix + name)).getString();
        return new OptionInstance(name, OptionInstance.m_231498_(), (label, val) -> val.equals("") ? this.styleBool((String)bools.get(0)) : this.styleBool((String)val), (OptionInstance.ValueSet)new OptionInstance.LazyEnum(() -> bools.stream().toList(), p_232011_ -> Optional.of(p_232011_), (Codec)Codec.STRING), (Object)"", val -> {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            config.set((Object)val.equals("true"));
        });
    }

    protected Component styleBool(String textBool) {
        return textBool.equals("true") ? Component.m_237113_((String)(ChatFormatting.DARK_GREEN + textBool)) : Component.m_237113_((String)(ChatFormatting.RED + textBool));
    }

    protected void addResetToDefaultsButton() {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Reset"), s -> this.resetValuesToDefault()).m_252987_(this.f_96543_ - 70, this.f_96544_ - 27, 60, 20).m_253136_());
    }

    protected void putAllConfigsInMenu(Class configClass) {
        if (configClass == NewWorldConfigs.class) {
            this.newWorldConfig = true;
        }
        List<Field> configFields = Stream.of(configClass.getFields()).filter(field -> ForgeConfigSpec.ConfigValue.class.isAssignableFrom(field.getType())).toList();
        HashMap<String, ForgeConfigSpec.ConfigValue<Integer>> intOptions = new HashMap<String, ForgeConfigSpec.ConfigValue<Integer>>();
        HashMap<String, ForgeConfigSpec.ConfigValue<Boolean>> boolOptions = new HashMap<String, ForgeConfigSpec.ConfigValue<Boolean>>();
        for (Field cf : configFields) {
            try {
                ForgeConfigSpec.ConfigValue option = (ForgeConfigSpec.ConfigValue)cf.get(null);
                if (option.get() instanceof Boolean) {
                    boolOptions.put(cf.getName(), (ForgeConfigSpec.ConfigValue<Boolean>)option);
                } else if (option.get() instanceof Integer) {
                    intOptions.put(cf.getName(), (ForgeConfigSpec.ConfigValue<Integer>)option);
                }
                this.all_options.add(option);
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        this.addSliders(intOptions);
        this.addBooleans(boolOptions);
    }

    protected static Component percentValueLabel(Component p_231898_, double p_231899_) {
        return Component.m_237110_((String)"options.percent_value", (Object[])new Object[]{p_231898_, (int)(p_231899_ * 100.0)});
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int cursorX, int cursorY, float frameTime) {
        super.m_88315_(graphics, cursorX, cursorY, frameTime);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
    }
}

