/*
 * Decompiled with CFR 0.152.
 */
package com.dementia.neurocraft.network;

import com.dementia.neurocraft.client.RandomizeHealthBars;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class CResetBarsPacket {
    private final int foodLevel;
    private final float healthLevel;

    public CResetBarsPacket(int foodLevel, float healthLevel) {
        this.foodLevel = foodLevel;
        this.healthLevel = healthLevel;
    }

    public CResetBarsPacket(FriendlyByteBuf buffer) {
        this(buffer.readInt(), buffer.readFloat());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.foodLevel);
        buffer.writeFloat(this.healthLevel);
    }

    public void handle(CustomPayloadEvent.Context context) {
        if (context.isClientSide()) {
            RandomizeHealthBars.resetBarsToServer(this.foodLevel, this.healthLevel);
            context.setPacketHandled(true);
        } else {
            context.setPacketHandled(false);
        }
    }
}

