/*
 * Decompiled with CFR 0.152.
 */
package com.dementia.neurocraft.server;

import com.dementia.neurocraft.common.Common;
import com.dementia.neurocraft.config.ServerConfigs;
import com.dementia.neurocraft.network.CAuditoryHallucinationPacket;
import com.dementia.neurocraft.network.PacketHandler;
import com.dementia.neurocraft.server.PlayerScaling;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="neurocraft")
public class AuditoryHallucinations {
    static int c = 0;
    static Map<Player, List<Entity>> playerEntityMap = new HashMap<Player, List<Entity>>();
    static List<SoundEvent> randomSoundEffects = Arrays.stream(SoundEvents.class.getFields()).filter(field -> field.getType() == SoundEvent.class).map(e -> {
        try {
            return (SoundEvent)e.get(null);
        }
        catch (IllegalAccessException ex) {
            return null;
        }
    }).collect(Collectors.toList());

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && c++ % 20 == 0) {
            AuditoryHallucinations.spawnAuditoryHallucinations(event);
        }
    }

    private static void spawnAuditoryHallucinations(TickEvent.ServerTickEvent event) {
        if (!((Boolean)ServerConfigs.AUDITORY_HALLUCINATIONS.get()).booleanValue()) {
            return;
        }
        for (ServerPlayer p : event.getServer().m_6846_().m_11314_()) {
            long playerSanity = PlayerScaling.getPlayerSanity((Player)p);
            boolean spawnHallucination = (long)new Random().nextInt((int)((double)((Integer)ServerConfigs.PEAK_SANITY.get()).intValue() / 1.5)) < playerSanity;
            List<SoundEvent> pool = randomSoundEffects;
            if (!spawnHallucination) continue;
            if (playerSanity >= (long)((Integer)ServerConfigs.PEAK_SANITY.get() / 2) && new Random().nextInt(2) == 1) {
                pool = List.of(new SoundEvent[]{SoundEvents.f_12598_, SoundEvents.f_12423_, SoundEvents.f_11837_, SoundEvents.f_215777_, SoundEvents.f_11923_, SoundEvents.f_12432_});
            }
            SoundEvent randomSound = pool.get(new Random().nextInt(pool.size()));
            PacketHandler.sendToPlayer(new CAuditoryHallucinationPacket(randomSound), p);
            Common.HallucinationOccured((Player)p, false, false);
        }
    }
}

