/*
 * Decompiled with CFR 0.152.
 */
package com.dementia.neurocraft.server;

import com.dementia.neurocraft.config.ServerConfigs;
import com.dementia.neurocraft.network.CHallBlockListUpdatePacket;
import com.dementia.neurocraft.network.PacketHandler;
import com.dementia.neurocraft.server.PlayerScaling;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="neurocraft")
public class BlockPlaceHallucinations {
    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        if (!((Boolean)ServerConfigs.FAKE_PLACE_BLOCKS.get()).booleanValue()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        BlockPlaceHallucinations.ConfuseBlocks(event, player);
        ServerPlayer nearestPlayer = (ServerPlayer)event.getLevel().m_45946_(TargetingConditions.f_26872_.m_26888_(e -> e != player), (LivingEntity)player);
        if (nearestPlayer == null) {
            return;
        }
        BlockPlaceHallucinations.ConfuseBlocks(event, nearestPlayer);
    }

    private static void ConfuseBlocks(BlockEvent.EntityPlaceEvent event, ServerPlayer player) {
        boolean replaceBlock;
        long playerSanity = PlayerScaling.getPlayerSanity((Player)player);
        boolean bl = replaceBlock = (long)new Random().nextInt((Integer)ServerConfigs.PEAK_SANITY.get()) < playerSanity;
        if (replaceBlock) {
            BlockPos bp = event.getPos();
            ClientboundBlockUpdatePacket packet = new ClientboundBlockUpdatePacket(bp, event.getPlacedBlock());
            event.getLevel().m_7731_(bp, Blocks.f_50016_.m_49966_(), 1);
            PacketHandler.sendVanillaPacket(packet, player, 2);
            PacketHandler.sendToPlayer(new CHallBlockListUpdatePacket(new int[]{bp.m_123341_(), bp.m_123342_(), bp.m_123343_()}), player);
        } else {
            boolean bl2 = replaceBlock = (long)new Random().nextInt((Integer)ServerConfigs.PEAK_SANITY.get()) < playerSanity;
            if (replaceBlock) {
                BlockPos bp = event.getPos();
                ClientboundBlockUpdatePacket packet = new ClientboundBlockUpdatePacket(bp, BlockPlaceHallucinations.getRandomBlock());
                PacketHandler.sendVanillaPacket(packet, player, 2);
                PacketHandler.sendToPlayer(new CHallBlockListUpdatePacket(new int[]{bp.m_123341_(), bp.m_123342_(), bp.m_123343_()}), player);
            }
        }
    }

    public static BlockState getRandomBlock() {
        List<Field> blockFields = Stream.of(Blocks.class.getDeclaredFields()).filter(field -> Block.class.isAssignableFrom(field.getType())).toList();
        while (true) {
            try {
                Field randomField = blockFields.get(new Random().nextInt(blockFields.size()));
                Block block = (Block)randomField.get(null);
                return block.m_49966_();
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            break;
        }
    }
}

