/*
 * Decompiled with CFR 0.152.
 */
package com.dementia.neurocraft.server;

import com.dementia.neurocraft.common.Common;
import com.dementia.neurocraft.config.ServerConfigs;
import com.dementia.neurocraft.server.PlayerScaling;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="neurocraft")
public class OreHallucinations {
    @SubscribeEvent
    public static void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        if (!((Boolean)ServerConfigs.ORE_HALLUCINATIONS.get()).booleanValue()) {
            return;
        }
        BlockState state = event.getState();
        Player player = event.getPlayer();
        event.getPos();
        if (state.m_60734_().m_49954_().toString().contains("ore")) {
            long playerSanity = PlayerScaling.getPlayerSanity(player);
            boolean replaceBlock = (long)new Random().nextInt((Integer)ServerConfigs.PEAK_SANITY.get()) < playerSanity;
            boolean shadowBlocks = new Random().nextBoolean();
            if (replaceBlock) {
                event.setCanceled(true);
                ArrayList<BlockPos> veinBlocks = OreHallucinations.getAllBlocksInVein(state, event.getPos(), event.getLevel());
                if (shadowBlocks) {
                    for (BlockPos blockPos : veinBlocks) {
                        if (state.m_60734_().m_49954_().toString().contains("deepslate")) {
                            event.getLevel().m_7731_(blockPos, Blocks.f_152550_.m_49966_(), 1);
                            continue;
                        }
                        event.getLevel().m_7731_(blockPos, Blocks.f_50069_.m_49966_(), 1);
                    }
                } else {
                    for (BlockPos blockPos : veinBlocks) {
                        if (state.m_60734_().m_49954_().toString().contains("deepslate")) {
                            event.getLevel().m_7731_(blockPos, Blocks.f_152550_.m_49966_(), 2);
                            continue;
                        }
                        event.getLevel().m_7731_(blockPos, Blocks.f_50069_.m_49966_(), 2);
                    }
                }
                player.m_146884_(player.m_20318_(0.0f));
                Common.HallucinationOccured(player);
            }
        }
    }

    private static List<BlockPos> getSurroundingBlocks(LevelAccessor level, BlockPos centerPos, int radius) {
        ArrayList<BlockPos> surroundingBlocks = new ArrayList<BlockPos>();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos targetPos = centerPos.m_7918_(x, y, z);
                    surroundingBlocks.add(targetPos);
                }
            }
        }
        return surroundingBlocks;
    }

    private static ArrayList<BlockPos> getAllBlocksInVein(BlockState state, BlockPos pos, LevelAccessor level) {
        ArrayList<BlockPos> blocksInVein = new ArrayList<BlockPos>();
        blocksInVein.add(pos);
        ArrayList<BlockPos> checkedBlocks = new ArrayList<BlockPos>();
        checkedBlocks.add(pos);
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        positions.add(pos);
        while (!positions.isEmpty()) {
            BlockPos currentPos = (BlockPos)positions.remove(0);
            OreHallucinations.getSurroundingBlocks(level, currentPos, 1).forEach(blockPos -> {
                BlockState blockState = level.m_8055_(blockPos);
                if (!checkedBlocks.contains(blockPos)) {
                    checkedBlocks.add((BlockPos)blockPos);
                    if (blockState.m_60734_() == state.m_60734_()) {
                        blocksInVein.add((BlockPos)blockPos);
                        positions.add((BlockPos)blockPos);
                    }
                }
            });
        }
        return blocksInVein;
    }
}

