/*
 * Decompiled with CFR 0.152.
 */
package com.dementia.neurocraft.server;

import com.dementia.neurocraft.config.ServerConfigs;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="neurocraft")
public class PlayerScaling {
    private static int c = 0;

    public static void giveInitialSanity(Player player) {
        player.getPersistentData().m_128356_("Sanity", (long)((Integer)ServerConfigs.INITIAL_SANITY.get()).intValue());
    }

    public static long getPlayerSanity(Player player) {
        if (!player.getPersistentData().m_128441_("Sanity")) {
            PlayerScaling.giveInitialSanity(player);
        }
        return player.getPersistentData().m_128454_("Sanity");
    }

    public static void incrementPlayerSanity(Player player) {
        long currentSanity = PlayerScaling.getPlayerSanity(player);
        if (currentSanity >= (long)((Integer)ServerConfigs.PEAK_SANITY.get()).intValue()) {
            return;
        }
        if (((Boolean)ServerConfigs.PLAYER_SCALING.get()).booleanValue()) {
            player.getPersistentData().m_128356_("Sanity", currentSanity + (long)((Integer)ServerConfigs.SCALING_INCREMENT.get()).intValue());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.type == TickEvent.Type.PLAYER && event.side == LogicalSide.SERVER && c++ == 20 * (Integer)ServerConfigs.SCALING_INTERVAL.get()) {
            PlayerScaling.incrementPlayerSanity(event.player);
            c = 0;
        }
    }

    @SubscribeEvent
    public static void onPlayerSpawn(PlayerEvent.PlayerRespawnEvent event) {
        if (((Boolean)ServerConfigs.SANITY_RESET_UPON_DEATH.get()).booleanValue()) {
            PlayerScaling.giveInitialSanity(event.getEntity());
        }
    }
}

