/*
 * Decompiled with CFR 0.152.
 */
package com.dementia.neurocraft.server;

import com.dementia.neurocraft.common.Common;
import com.dementia.neurocraft.config.ServerConfigs;
import com.dementia.neurocraft.network.CHallucinationListUpdatePacket;
import com.dementia.neurocraft.network.PacketHandler;
import com.dementia.neurocraft.server.PlayerScaling;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="neurocraft")
public class ServerHallucinations {
    static int c = 0;
    static Map<Player, List<Entity>> playerEntityMap = new HashMap<Player, List<Entity>>();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && c++ % 160 == 0) {
            ServerHallucinations.runHallucinationSpawns(event);
            for (ServerPlayer p : event.getServer().m_6846_().m_11314_()) {
                ServerHallucinations.sendNewHallucinationListPacket(p);
            }
            c = 1;
        }
    }

    private static void sendNewHallucinationListPacket(ServerPlayer p) {
        ServerHallucinations.getPlayerEntities((Player)p).removeIf(Entity::m_213877_);
        ServerHallucinations.getPlayerEntities((Player)p).removeIf(e -> !e.m_6084_());
        int[] entityIDList = ServerHallucinations.getPlayerEntities((Player)p).stream().mapToInt(Entity::m_19879_).toArray();
        PacketHandler.sendToPlayer(new CHallucinationListUpdatePacket(entityIDList), p);
    }

    @SubscribeEvent
    public static void onMobSpawnEvent(MobSpawnEvent.FinalizeSpawn event) {
        if (!((Boolean)ServerConfigs.ENEMY_HALLUCINATIONS.get()).booleanValue()) {
            return;
        }
        if (event.getSpawnType() != MobSpawnType.CHUNK_GENERATION && event.getSpawnType() != MobSpawnType.COMMAND && event.getSpawnType() != MobSpawnType.SPAWN_EGG) {
            Mob entity = event.getEntity();
            Player np = event.getLevel().m_45930_((Entity)entity, 50.0);
            if (np != null) {
                playerEntityMap.putIfAbsent(np, new ArrayList());
                if ((long)new Random().nextInt((Integer)ServerConfigs.PEAK_SANITY.get()) < PlayerScaling.getPlayerSanity(np)) {
                    playerEntityMap.get(np).add((Entity)entity);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onAttackEntityEvent(AttackEntityEvent event) {
        Entity entity = event.getTarget();
        Player player = event.getEntity();
        List<Entity> playerMap = playerEntityMap.get(player);
        if (playerMap == null || player.m_20194_() == null || entity == null || entity.m_213877_() || !entity.m_6084_()) {
            return;
        }
        if (playerMap.contains(entity)) {
            Vec3 pos = entity.m_20318_(0.0f);
            Vec3 oldPos = player.m_20318_(0.0f);
            entity.m_142687_(Entity.RemovalReason.KILLED);
            ServerPlayer sp = player.m_20194_().m_6846_().m_11259_(player.m_20148_());
            if (sp != null) {
                ServerHallucinations.sendNewHallucinationListPacket(sp);
            }
            if (new Random().nextInt(25) == 1) {
                player.m_146884_(pos);
                player.m_7618_(EntityAnchorArgument.Anchor.EYES, oldPos);
            }
            event.setCanceled(true);
            Common.HallucinationOccured(player);
        }
    }

    @SubscribeEvent
    public static void onLivingDropsEvent(LivingDropsEvent event) {
        for (List<Entity> entities : playerEntityMap.values()) {
            if (!entities.contains(event.getEntity())) continue;
            event.setCanceled(true);
        }
    }

    private static void runHallucinationSpawns(TickEvent.ServerTickEvent event) {
        if (!((Boolean)ServerConfigs.ENEMY_HALLUCINATIONS.get()).booleanValue()) {
            return;
        }
        for (Player p : event.getServer().m_6846_().m_11314_()) {
            long playerSanity = PlayerScaling.getPlayerSanity(p);
            boolean spawnHallucination = (long)new Random().nextInt((int)((double)((Integer)ServerConfigs.PEAK_SANITY.get()).intValue() * 1.5)) < playerSanity;
            Direction direction = p.m_6350_();
            Vec3 pos = p.m_20318_(0.0f);
            Vec3 spawnPos = pos.m_231075_(direction.m_122424_(), (double)new Random().nextInt(1, 5));
            if (!spawnHallucination) continue;
            EntityType[] pool = new EntityType[]{EntityType.f_20501_, EntityType.f_20479_, EntityType.f_20524_, EntityType.f_20558_, EntityType.f_20566_, EntityType.f_20554_, EntityType.f_217015_, EntityType.f_20518_, EntityType.f_20496_};
            EntityType entityType = pool[Math.min(pool.length - 1, (int)Math.floor(new Random().nextFloat((float)playerSanity / ((float)((Integer)ServerConfigs.PEAK_SANITY.get()).intValue() / (float)pool.length - 1.0f))))];
            ServerHallucinations.spawnEntityHallucination(entityType, p, playerSanity, spawnPos);
        }
    }

    private static void spawnEntityHallucination(EntityType<?> entityType, Player p, long sanity, Vec3 spawnPos) {
        Entity entity = entityType.m_20615_(p.m_9236_());
        if (entity != null) {
            Collection captureDrops;
            if (entityType == EntityType.f_20524_) {
                ItemStack bow = new ItemStack((ItemLike)Items.f_42411_);
                entity.m_8061_(EquipmentSlot.MAINHAND, bow);
            }
            if ((captureDrops = entity.captureDrops()) != null) {
                captureDrops.clear();
            }
            if (entity instanceof Monster) {
                ((Monster)entity).m_6710_((LivingEntity)p);
            }
            entity.m_146884_(spawnPos);
            p.m_9236_().m_7967_(entity);
            playerEntityMap.putIfAbsent(p, new ArrayList());
            if ((long)new Random().nextInt((Integer)ServerConfigs.PEAK_SANITY.get() * 2) >= sanity) {
                playerEntityMap.get(p).add(entity);
            }
        }
    }

    public static List<Entity> getPlayerEntities(Player player) {
        return playerEntityMap.getOrDefault(player, Collections.emptyList());
    }
}

