/*
 * Decompiled with CFR 0.152.
 */
package com.dementia.neurocraft.util;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="neurocraft", value={Dist.CLIENT})
public class ClientTimingHandler {
    private static final int maxTicks = 2000;
    private static int tickCount = 0;
    private static final Map<Map.Entry<Map.Entry<String, Integer>, Map.Entry<Runnable, Boolean>>, Integer> _scheduledEvents = new HashMap<Map.Entry<Map.Entry<String, Integer>, Map.Entry<Runnable, Boolean>>, Integer>();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ClientTickEvent event) {
        if (event.side != LogicalSide.CLIENT || event.type != TickEvent.Type.CLIENT) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            Iterator<Map.Entry<Map.Entry<Map.Entry<String, Integer>, Map.Entry<Runnable, Boolean>>, Integer>> iterator = _scheduledEvents.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Map.Entry<Map.Entry<String, Integer>, Map.Entry<Runnable, Boolean>>, Integer> entry = iterator.next();
                String name = entry.getKey().getKey().getKey();
                int maxTicks = entry.getKey().getKey().getValue();
                Runnable task = entry.getKey().getValue().getKey();
                Boolean runOnce = entry.getKey().getValue().getValue();
                int ticksRemaining = entry.getValue();
                entry.setValue(++ticksRemaining);
                if (ticksRemaining != maxTicks) continue;
                task.run();
                if (!runOnce.booleanValue()) continue;
                iterator.remove();
            }
            if (tickCount++ >= 2000) {
                tickCount = 0;
            }
        }
    }

    public static void scheduleEvent(String name, int ticks, Runnable task, boolean runsOnce) {
        _scheduledEvents.put(new AbstractMap.SimpleEntry<AbstractMap.SimpleEntry<String, Integer>, AbstractMap.SimpleEntry<Runnable, Boolean>>(new AbstractMap.SimpleEntry<String, Integer>(name, ticks), new AbstractMap.SimpleEntry<Runnable, Boolean>(task, runsOnce)), 0);
    }
}

