/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity.inventory;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.wanmine.wab.entity.Soarer;
import net.wanmine.wab.init.world.WabMenus;

public class SoarerInventoryMenu
extends AbstractContainerMenu {
    private final Container container;
    public final Soarer soarer;

    public SoarerInventoryMenu(int pContainerId, Inventory inventory, FriendlyByteBuf buf) {
        this(pContainerId, inventory, (Soarer)inventory.player.level().getEntity(buf.readInt()));
    }

    public SoarerInventoryMenu(int pContainerId, Inventory inventory, final Soarer soarer) {
        super((MenuType)WabMenus.SOARER_INVENTORY.get(), pContainerId);
        int j1;
        this.container = soarer.getInventory();
        this.soarer = soarer;
        inventory.startOpen(inventory.player);
        this.addSlot(new Slot(this, this.container, 0, 82, 7){

            public boolean mayPlace(ItemStack itemStack) {
                return itemStack.is(Items.SADDLE);
            }

            public boolean isActive() {
                return soarer.isSaddleable();
            }
        });
        for (j1 = 0; j1 < 3; ++j1) {
            for (int k1 = 0; k1 < 9; ++k1) {
                this.addSlot(new Slot((Container)inventory, k1 + j1 * 9 + 9, 8 + k1 * 18, 102 + j1 * 18 + -9));
            }
        }
        for (j1 = 0; j1 < 9; ++j1) {
            this.addSlot(new Slot((Container)inventory, j1, 8 + j1 * 18, 151));
        }
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player) && this.container.stillValid(player) && this.soarer.isAlive() && player.canInteractWithEntity((Entity)this.soarer, 4.0);
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            int i = this.container.getContainerSize();
            if (pIndex < i) {
                if (!this.moveItemStackTo(itemstack1, i, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(1).mayPlace(itemstack1) && !this.getSlot(1).hasItem()) {
                if (!this.moveItemStackTo(itemstack1, 1, 2, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(0).mayPlace(itemstack1)) {
                if (!this.moveItemStackTo(itemstack1, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (i <= 2 || !this.moveItemStackTo(itemstack1, 2, i, false)) {
                int j = i + 27;
                int k = j + 9;
                if (pIndex >= j && pIndex < k ? !this.moveItemStackTo(itemstack1, i, j, false) : (pIndex >= i && pIndex < j ? !this.moveItemStackTo(itemstack1, j, k, false) : !this.moveItemStackTo(itemstack1, j, j, false))) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.container.stopOpen(pPlayer);
    }
}

