/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.event.setup;

import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.DecoratedPotPattern;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import net.wanmine.wab.WanAncientBeasts;
import net.wanmine.wab.block.render.AncientSkullRenderer;
import net.wanmine.wab.block.render.model.AncientSkullModel;
import net.wanmine.wab.entity.inventory.SoarerInventoryScreen;
import net.wanmine.wab.entity.inventory.WalkerInventoryScreen;
import net.wanmine.wab.entity.render.EntityRenderer;
import net.wanmine.wab.entity.render.model.CrusherModel;
import net.wanmine.wab.entity.render.model.EaterModel;
import net.wanmine.wab.entity.render.model.SoarerModel;
import net.wanmine.wab.entity.render.model.SurferModel;
import net.wanmine.wab.entity.render.model.WabEntityModel;
import net.wanmine.wab.entity.render.model.WalkerModel;
import net.wanmine.wab.event.Keybindings;
import net.wanmine.wab.init.data.WabPotPatterns;
import net.wanmine.wab.init.world.WabBlocks;
import net.wanmine.wab.init.world.WabEntities;
import net.wanmine.wab.init.world.WabItems;
import net.wanmine.wab.init.world.WabMenus;
import net.wanmine.wab.item.HangGlider;

@EventBusSubscriber(modid="wan_ancient_beasts", value={Dist.CLIENT})
public class ClientSetup {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        WanAncientBeasts.LOGGER.info("Hello World from Wan's Ancient Beasts Client Side");
        WabPotPatterns.ITEM_TO_POT_TEXTURE.put((Item)WabItems.JAW_POTTERY_SHERD.get(), (ResourceKey<DecoratedPotPattern>)WabPotPatterns.JAW.getKey());
        WabPotPatterns.ITEM_TO_POT_TEXTURE.put((Item)WabItems.SPIKE_POTTERY_SHERD.get(), (ResourceKey<DecoratedPotPattern>)WabPotPatterns.SPIKE.getKey());
        WabPotPatterns.ITEM_TO_POT_TEXTURE.put((Item)WabItems.STROLL_POTTERY_SHERD.get(), (ResourceKey<DecoratedPotPattern>)WabPotPatterns.STROLL.getKey());
        WabPotPatterns.ITEM_TO_POT_TEXTURE.put((Item)WabItems.BEAK_POTTERY_SHERD.get(), (ResourceKey<DecoratedPotPattern>)WabPotPatterns.BEAK.getKey());
        WabPotPatterns.ITEM_TO_POT_TEXTURE.put((Item)WabItems.FALL_POTTERY_SHERD.get(), (ResourceKey<DecoratedPotPattern>)WabPotPatterns.FALL.getKey());
        WabPotPatterns.ITEM_TO_POT_TEXTURE.put((Item)WabItems.FOSSIL_POTTERY_SHERD.get(), (ResourceKey<DecoratedPotPattern>)WabPotPatterns.FOSSIL.getKey());
        WabPotPatterns.ITEM_TO_POT_TEXTURE.put((Item)WabItems.TIDE_POTTERY_SHERD.get(), (ResourceKey<DecoratedPotPattern>)WabPotPatterns.TIDE.getKey());
        ItemProperties.register((Item)((Item)WabItems.REINFORCED_SHIELD.get()), (ResourceLocation)WanAncientBeasts.resource("blocking"), (stack, world, entity, seed) -> {
            if (entity != null && entity.isUsingItem() && entity.getUseItem() == stack) {
                return 1.0f;
            }
            return 0.0f;
        });
        ClientSetup.registerHangGlider(WabItems.HANG_GLIDER);
        ClientSetup.registerHangGlider(WabItems.WHITE_HANG_GLIDER);
        ClientSetup.registerHangGlider(WabItems.LIGHT_GRAY_HANG_GLIDER);
        ClientSetup.registerHangGlider(WabItems.GRAY_HANG_GLIDER);
        ClientSetup.registerHangGlider(WabItems.BLACK_HANG_GLIDER);
        ClientSetup.registerHangGlider(WabItems.BROWN_HANG_GLIDER);
        ClientSetup.registerHangGlider(WabItems.RED_HANG_GLIDER);
        ClientSetup.registerHangGlider(WabItems.ORANGE_HANG_GLIDER);
        ClientSetup.registerHangGlider(WabItems.YELLOW_HANG_GLIDER);
        ClientSetup.registerHangGlider(WabItems.LIME_HANG_GLIDER);
        ClientSetup.registerHangGlider(WabItems.GREEN_HANG_GLIDER);
        ClientSetup.registerHangGlider(WabItems.LIGHT_BLUE_HANG_GLIDER);
        ClientSetup.registerHangGlider(WabItems.CYAN_HANG_GLIDER);
        ClientSetup.registerHangGlider(WabItems.BLUE_HANG_GLIDER);
        ClientSetup.registerHangGlider(WabItems.PURPLE_HANG_GLIDER);
        ClientSetup.registerHangGlider(WabItems.MAGENTA_HANG_GLIDER);
        ClientSetup.registerHangGlider(WabItems.PINK_HANG_GLIDER);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)WabBlocks.Entities.SNIFFER_SKULL.get()), AncientSkullRenderer.create(AncientSkullModel::new));
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)WabBlocks.Entities.EATER_SKULL.get()), AncientSkullRenderer.create(AncientSkullModel::new));
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)WabBlocks.Entities.WALKER_SKULL.get()), AncientSkullRenderer.create(AncientSkullModel::new));
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)WabBlocks.Entities.CRUSHER_SKULL.get()), AncientSkullRenderer.create(AncientSkullModel::new));
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)WabBlocks.Entities.GLIDER_SKULL.get()), AncientSkullRenderer.create(AncientSkullModel::new));
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)WabBlocks.Entities.SOARER_SKULL.get()), AncientSkullRenderer.create(AncientSkullModel::new));
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)WabBlocks.Entities.CHARGER_SKULL.get()), AncientSkullRenderer.create(AncientSkullModel::new));
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)WabBlocks.Entities.SURFER_SKULL.get()), AncientSkullRenderer.create(AncientSkullModel::new));
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)WabBlocks.Entities.RAIDER_SKULL.get()), AncientSkullRenderer.create(AncientSkullModel::new));
        EntityRenderers.register((EntityType)((EntityType)WabEntities.EATER.get()), EntityRenderer.create(EaterModel::new, 0.4f));
        EntityRenderers.register((EntityType)((EntityType)WabEntities.WALKER.get()), EntityRenderer.create(WalkerModel::new, 0.4f));
        EntityRenderers.register((EntityType)((EntityType)WabEntities.CRUSHER.get()), EntityRenderer.create(CrusherModel::new, 0.6f));
        EntityRenderers.register((EntityType)((EntityType)WabEntities.GLIDER.get()), EntityRenderer.create(() -> new WabEntityModel("glider"), 0.6f));
        EntityRenderers.register((EntityType)((EntityType)WabEntities.SOARER.get()), EntityRenderer.create(SoarerModel::new, 0.6f));
        EntityRenderers.register((EntityType)((EntityType)WabEntities.SURFER.get()), EntityRenderer.create(SurferModel::new, 0.6f));
        EntityRenderers.register((EntityType)((EntityType)WabEntities.PALEONTOLOGIST.get()), EntityRenderer.create(() -> new WabEntityModel("paleontologist"), 1.0f));
        EntityRenderers.register((EntityType)((EntityType)WabEntities.TOXLACANTH.get()), EntityRenderer.create(() -> new WabEntityModel("toxlacanth"), 0.8f));
    }

    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(Keybindings.SPECIAL_ABILITY);
    }

    @SubscribeEvent
    public static void registerScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)WabMenus.WALKER_INVENTORY.get(), WalkerInventoryScreen::new);
        event.register((MenuType)WabMenus.SOARER_INVENTORY.get(), SoarerInventoryScreen::new);
    }

    private static void registerHangGlider(DeferredItem<HangGlider> hangGlider) {
        ItemProperties.register((Item)((Item)hangGlider.get()), (ResourceLocation)WanAncientBeasts.resource("hanging"), (stack, world, entity, seed) -> {
            if (entity != null && entity.isUsingItem() && entity.getUseItem() == stack) {
                return 1.0f;
            }
            return 0.0f;
        });
    }
}

