/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.init.gen.data.loot;

import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.wanmine.wab.init.world.WabEntities;

public class WabEntityLootGenerator
extends EntityLootSubProvider {
    public WabEntityLootGenerator(HolderLookup.Provider lookUp) {
        super(FeatureFlags.REGISTRY.allFlags(), FeatureFlagSet.of(), lookUp);
    }

    public void generate() {
        this.noDrop((EntityType)WabEntities.EATER.get());
        this.noDrop((EntityType)WabEntities.WALKER.get());
        this.noDrop((EntityType)WabEntities.CRUSHER.get());
        this.noDrop((EntityType)WabEntities.GLIDER.get());
        this.noDrop((EntityType)WabEntities.SOARER.get());
        this.noDrop((EntityType)WabEntities.SURFER.get());
    }

    protected void noDrop(EntityType<?> entity) {
        this.add(entity, LootTable.lootTable());
    }

    protected void self(EntityType<?> entity, ItemLike item) {
        this.add(entity, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item))));
    }

    protected Stream<EntityType<?>> getKnownEntityTypes() {
        return WabEntities.ENTITIES.getEntries().stream().map(entity -> (EntityType)entity.getDelegate().value());
    }
}

