/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.network.client;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.wanmine.wab.WanAncientBeasts;
import net.wanmine.wab.entity.Eater;

public record EaterAlphaPacket(int eaterId, boolean alpha) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<EaterAlphaPacket> TYPE = new CustomPacketPayload.Type(WanAncientBeasts.resource("eater_alpha"));
    public static final StreamCodec<ByteBuf, EaterAlphaPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, EaterAlphaPacket::eaterId, (StreamCodec)ByteBufCodecs.BOOL, EaterAlphaPacket::alpha, EaterAlphaPacket::new);

    public void handle(IPayloadContext context) {
        Entity entity = Minecraft.getInstance().player.level().getEntity(this.eaterId);
        if (entity instanceof Eater) {
            Eater eater = (Eater)entity;
            eater.setAlpha(this.alpha);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

