/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.network.server;

import io.netty.buffer.ByteBuf;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.wanmine.wab.WanAncientBeasts;
import net.wanmine.wab.entity.Soarer;
import net.wanmine.wab.init.data.WabTriggers;

public record SoarerJumpPacket(int soarerId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SoarerJumpPacket> TYPE = new CustomPacketPayload.Type(WanAncientBeasts.resource("soarer_jump"));
    public static final StreamCodec<ByteBuf, SoarerJumpPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SoarerJumpPacket::soarerId, SoarerJumpPacket::new);

    public void handle(IPayloadContext context) {
        Soarer soarer;
        LivingEntity livingEntity;
        Entity entity = context.player().level().getEntity(this.soarerId);
        if (entity instanceof Soarer && (livingEntity = (soarer = (Soarer)entity).getControllingPassenger()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (context.player() == player) {
                soarer.addFlaps(-1);
                ((PlayerTrigger)WabTriggers.SOARER_FLYING_JUMP.get()).trigger(player);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

