/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.wanmine.wab.block.BeastEggBlock;
import net.wanmine.wab.config.WabWorldConfig;
import net.wanmine.wab.entity.goals.crusher.CrusherIdleGoal;
import net.wanmine.wab.entity.goals.crusher.CrusherMeleeAttackGoal;
import net.wanmine.wab.init.world.WabBlocks;
import net.wanmine.wab.init.world.WabEntities;
import net.wanmine.wab.init.world.WabItems;
import net.wanmine.wab.init.world.WabSounds;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Crusher
extends Animal
implements GeoEntity,
NeutralMob {
    public static final String ID = "crusher";
    public static final String SPAWN_EGG_ID = "crusher_spawn_egg";
    public static final EntityDataAccessor<Boolean> IS_IDLE2 = SynchedEntityData.m_135353_(Crusher.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> STATE_ATTACK = SynchedEntityData.m_135353_(Crusher.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> HIT_SPIKE = SynchedEntityData.m_135353_(Crusher.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Long> LAST_DROP_SPIKE = SynchedEntityData.m_135353_(Crusher.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    private static final RawAnimation IDLE2 = RawAnimation.begin().thenPlay("misc.idle2");
    private static final RawAnimation BABY = RawAnimation.begin().thenPlay("misc.baby");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int ticksLeft = -20;
    private final HashMap<LivingEntity, Integer> hasDamage = new HashMap();

    public Crusher(EntityType<? extends Animal> animal, Level level) {
        super(animal, level);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)WabWorldConfig.CRUSHER_HEALTH.get()).doubleValue());
        this.m_21051_(Attributes.f_22281_).m_22100_(((Double)WabWorldConfig.CRUSHER_DAMAGE.get()).doubleValue());
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)WabWorldConfig.CRUSHER_ARMOR.get()).doubleValue());
        this.m_21051_(Attributes.f_22285_).m_22100_(((Double)WabWorldConfig.CRUSHER_ARMOR_TOUGHNESS.get()).doubleValue());
        this.m_21153_(((Double)WabWorldConfig.CRUSHER_HEALTH.get()).floatValue());
        return super.m_6518_(level, difficulty, spawnType, groupData, tag);
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, Attributes.f_22279_.m_22082_()).m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22285_, 4.0).m_22268_(Attributes.f_22284_, 20.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_IDLE2, (Object)false);
        this.f_19804_.m_135372_(STATE_ATTACK, (Object)0);
        this.f_19804_.m_135372_(HIT_SPIKE, (Object)-1);
        this.f_19804_.m_135372_(LAST_DROP_SPIKE, (Object)-1L);
    }

    public static boolean canSpawn(EntityType<? extends Crusher> entity, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return Crusher.m_186209_((BlockAndTintGetter)level, (BlockPos)pos);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_151017_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new CrusherMeleeAttackGoal(this, 0.6, false));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 0.4));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 0.4, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151017_}), false));
        this.f_21345_.m_25352_(4, (Goal)new CrusherIdleGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.4));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 0.6f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)WabEntities.CRUSHER.get()).m_20615_((Level)level);
    }

    @NotNull
    public InteractionResult m_6071_(Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_41720_() == WabItems.CHISEL.get() && this.m_9236_().m_46467_() - 6000L > (Long)this.f_19804_.m_135370_(LAST_DROP_SPIKE)) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
            itemstack.m_41622_(1, (LivingEntity)pPlayer, player -> player.m_21190_(pHand));
            ItemStack spike = new ItemStack((ItemLike)WabBlocks.CRUSHER_SPIKE.get());
            ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20182_().m_7096_(), this.m_20182_().m_7098_() + 1.0, this.m_20182_().m_7094_(), spike);
            itementity.m_32060_();
            this.m_9236_().m_7967_((Entity)itementity);
            this.setHitSpike(pPlayer);
            this.f_19804_.m_135381_(LAST_DROP_SPIKE, (Object)this.m_9236_().m_46467_());
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public void m_27563_(@NotNull ServerLevel level, @NotNull Animal mate) {
        ItemStack itemstack = new ItemStack((ItemLike)((BeastEggBlock)((Object)WabBlocks.CRUSHER_EGG.get())).m_5456_());
        ItemEntity itementity = new ItemEntity((Level)level, this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), itemstack);
        itementity.m_32060_();
        this.m_277117_(level, mate, null);
        this.m_5496_(SoundEvents.f_279531_, 1.2f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 0.5f);
        level.m_7967_((Entity)itementity);
    }

    public boolean m_7327_(Entity pEntity) {
        float f = (float)this.m_21133_(Attributes.f_22281_);
        float f1 = (float)(this.m_21133_(Attributes.f_22282_) + (this.getStateAttack() == StateAttack.ATTACK_KNOCKBACK ? 1.0 : 0.0));
        boolean flag = pEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f);
        if (flag) {
            if (f1 > 0.0f && pEntity instanceof LivingEntity) {
                ((LivingEntity)pEntity).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            this.m_19970_((LivingEntity)this, pEntity);
            this.m_21335_(pEntity);
        }
        return flag;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_269533_(DamageTypeTags.f_268524_)) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
            if (this.isIdle2()) {
                this.m_20334_(0.0, 0.0, 0.0);
            }
            this.ticksLeft = Math.max(this.ticksLeft - 1, -20);
            if (this.ticksLeft > 0 && this.m_6084_()) {
                LivingEntity target = this.m_5448_();
                StateAttack state = this.getStateAttack();
                if (state == StateAttack.ATTACK_AREA && state.isHitTick(state.getDuration() - (this.ticksLeft + 1))) {
                    try {
                        for (LivingEntity l : this.hasDamage.keySet()) {
                            int tick = this.hasDamage.get(l);
                            if (tick > 0) {
                                this.hasDamage.put(l, this.hasDamage.get(l) - 1);
                                continue;
                            }
                            this.hasDamage.remove(l);
                        }
                        for (LivingEntity target2 : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(0.5, 2.0, 0.5))) {
                            if (target2 instanceof Crusher || this.hasDamage.containsKey(target2)) continue;
                            this.m_6674_(InteractionHand.MAIN_HAND);
                            this.m_7327_((Entity)target2);
                            this.hasDamage.put(target2, 15);
                        }
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {}
                } else if (target != null && target.m_6084_() && this.m_217066_(target) && state.isHitTick(state.getDuration() - (this.ticksLeft + 1)) && !this.hasDamage.containsKey(target)) {
                    this.m_6674_(InteractionHand.MAIN_HAND);
                    this.m_7327_((Entity)target);
                    this.hasDamage.put(target, Integer.MAX_VALUE);
                }
            } else if (this.ticksLeft == 0) {
                this.hasDamage.clear();
                this.setStateAttack(StateAttack.NONE);
                Player player = this.hitSpike();
                this.setHitSpike(null);
                if (player != null && !player.m_7500_() && !player.m_5833_()) {
                    this.m_6710_((LivingEntity)player);
                }
            } else if (this.hitSpike() != null) {
                this.setStateAttack(StateAttack.ATTACK_AREA);
                this.ticksLeft = StateAttack.ATTACK_AREA.getDuration();
            }
        }
    }

    public void setHitSpike(Player player) {
        this.f_19804_.m_135381_(HIT_SPIKE, (Object)(player == null ? -1 : player.m_19879_()));
    }

    public Player hitSpike() {
        int id = (Integer)this.f_19804_.m_135370_(HIT_SPIKE);
        return id == -1 ? null : (Player)this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(HIT_SPIKE)).intValue());
    }

    public void setIdle2(boolean hitSpike) {
        this.f_19804_.m_135381_(IS_IDLE2, (Object)hitSpike);
    }

    public boolean isIdle2() {
        return (Boolean)this.f_19804_.m_135370_(IS_IDLE2);
    }

    public StateAttack getStateAttack() {
        StateAttack[] states = StateAttack.values();
        return states[Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(STATE_ATTACK)), (int)0, (int)(states.length - 1))];
    }

    public void setStateAttack(StateAttack state) {
        this.f_19804_.m_135381_(STATE_ATTACK, (Object)state.ordinal());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controller) {
        controller.add(new AnimationController[]{Crusher.baby(this)});
        controller.add(new AnimationController[]{Crusher.idle(this)});
        controller.add(new AnimationController[]{Crusher.attack(this)});
    }

    private static <T extends LivingEntity> AnimationController<T> baby(T entity) {
        return new AnimationController(entity, "baby", 1, state -> {
            if (entity.m_6162_()) {
                return state.setAndContinue(BABY);
            }
            state.getController().forceAnimationReset();
            return PlayState.CONTINUE;
        });
    }

    private static AnimationController<Crusher> idle(Crusher crusher) {
        return new AnimationController((GeoAnimatable)crusher, "idle", 1, state -> {
            if (crusher.isIdle2()) {
                return state.setAndContinue(IDLE2);
            }
            return state.setAndContinue(crusher.isMoving() ? DefaultAnimations.WALK : DefaultAnimations.IDLE);
        });
    }

    private static AnimationController<Crusher> attack(Crusher crusher) {
        return new AnimationController((GeoAnimatable)crusher, "attack", 1, state -> {
            if (crusher.getStateAttack() != StateAttack.NONE) {
                return state.setAndContinue(crusher.getStateAttack().getAnimation());
            }
            state.getController().forceAnimationReset();
            return PlayState.CONTINUE;
        });
    }

    public boolean isMoving() {
        return this.m_20184_().f_82479_ != 0.0 || this.m_20184_().f_82481_ != 0.0;
    }

    public MobType m_6336_() {
        return WabEntities.ANCIENT_MOB;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)WabSounds.CRUSHER_HURT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)WabSounds.CRUSHER_IDLE.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int m_6784_() {
        return 0;
    }

    public void m_7870_(int p_21673_) {
    }

    @Nullable
    public UUID m_6120_() {
        return null;
    }

    public void m_6925_(@Nullable UUID p_21672_) {
    }

    public void m_6825_() {
    }

    public static enum StateAttack {
        NONE(null, 0, 0, 0),
        ATTACK(RawAnimation.begin().thenPlay("attack.attack"), 16, 9, 11),
        ATTACK_KNOCKBACK(RawAnimation.begin().thenPlay("attack.attack knockback"), 18, 10, 13),
        ATTACK_AREA(RawAnimation.begin().thenPlay("attack.attack area"), 73, 6, 65);

        private final RawAnimation animation;
        private final int duration;
        private final int hitTickStart;
        private final int hitTickStop;

        private StateAttack(RawAnimation animation, int duration, int hitTickStart, int hitTickStop) {
            this.animation = animation;
            this.duration = duration;
            this.hitTickStart = hitTickStart;
            this.hitTickStop = hitTickStop;
        }

        public RawAnimation getAnimation() {
            return this.animation;
        }

        public int getDuration() {
            return this.duration;
        }

        public boolean isHitTick(int tick) {
            return tick >= this.hitTickStart && tick <= this.hitTickStop;
        }
    }
}

