/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.wanmine.wab.block.BeastEggBlock;
import net.wanmine.wab.config.WabWorldConfig;
import net.wanmine.wab.entity.Toxlacanth;
import net.wanmine.wab.entity.goals.soarer.SoarerMeleeAttackGoal;
import net.wanmine.wab.entity.inventory.SoarerInventoryMenu;
import net.wanmine.wab.entity.part.WabEntityPart;
import net.wanmine.wab.entity.part.soarer.SoarerHead;
import net.wanmine.wab.entity.part.soarer.SoarerNeck;
import net.wanmine.wab.init.world.WabBlocks;
import net.wanmine.wab.init.world.WabEntities;
import net.wanmine.wab.init.world.WabItems;
import net.wanmine.wab.init.world.WabSounds;
import net.wanmine.wab.network.PacketHandler;
import net.wanmine.wab.network.client.InitSoarerPacket;
import net.wanmine.wab.network.client.SoarerScreenOpenPacket;
import net.wanmine.wab.network.server.SoarerJumpPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Soarer
extends TamableAnimal
implements Saddleable,
PlayerRideableJumping,
HasCustomInventoryScreen,
ContainerListener,
FlyingAnimal,
NeutralMob,
GeoEntity {
    public static final String ID = "soarer";
    public static final String SPAWN_EGG_ID = "soarer_spawn_egg";
    public static final int MAX_FLAPS = 15;
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(Soarer.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_ATTACKING = SynchedEntityData.m_135353_(Soarer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_SADDLED = SynchedEntityData.m_135353_(Soarer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final RawAnimation BABY = RawAnimation.begin().thenPlay("misc.baby");
    private static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("attack.attack");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected SimpleContainer inventory;
    private final WabEntityPart<Soarer>[] subEntities;
    private final SoarerNeck neck = new SoarerNeck(this);
    private final SoarerHead head = new SoarerHead(this);
    private int flaps = 15;
    private int tickLeft = 0;
    public int attackTick = -10;
    private int flapTick = 0;
    private double powerFlap = 0.0;

    public Soarer(EntityType<Soarer> animal, Level level) {
        super(animal, level);
        this.subEntities = new WabEntityPart[]{this.neck, this.head};
        this.m_20234_(f_19843_.getAndAdd(this.subEntities.length + 1) + 1);
        this.m_274367_(1.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.createInventory();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)WabWorldConfig.SOARER_HEALTH.get()).doubleValue());
        this.m_21051_(Attributes.f_22281_).m_22100_(((Double)WabWorldConfig.SOARER_DAMAGE.get()).doubleValue());
        this.m_21153_(((Double)WabWorldConfig.SOARER_HEALTH.get()).floatValue());
        return super.m_6518_(level, difficulty, spawnType, groupData, tag);
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.11).m_22268_(Attributes.f_22280_, 0.6).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22282_, 0.6);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)0);
        this.f_19804_.m_135372_(IS_ATTACKING, (Object)false);
        this.f_19804_.m_135372_(IS_SADDLED, (Object)false);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("flaps", this.flaps);
        if (!this.inventory.m_8020_(0).m_41619_()) {
            pCompound.m_128365_("SaddleItem", (Tag)this.inventory.m_8020_(0).m_41739_(new CompoundTag()));
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        ItemStack itemstack;
        super.m_7378_(pCompound);
        this.flaps = pCompound.m_128451_("flaps");
        if (pCompound.m_128425_("SaddleItem", 10) && (itemstack = ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("SaddleItem"))).m_150930_(Items.f_42450_)) {
            this.inventory.m_6836_(0, itemstack);
        }
        this.updateContainerEquipment();
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        PacketHandler.sendToPlayer(new InitSoarerPacket(this.m_19879_(), this.m_6254_(), this.getFlaps()), player);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SoarerMeleeAttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)WabItems.TOXLACANTH.get()}), false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 0.6f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Toxlacanth.class, false, false));
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)WabEntities.SOARER.get()).m_20615_((Level)level);
    }

    public void m_27563_(@NotNull ServerLevel level, @NotNull Animal mate) {
        ItemStack itemstack = new ItemStack((ItemLike)((BeastEggBlock)((Object)WabBlocks.SOARER_EGG.get())).m_5456_());
        ItemEntity itementity = new ItemEntity((Level)level, this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), itemstack);
        itementity.m_32060_();
        this.m_277117_(level, mate, null);
        this.m_5496_(SoundEvents.f_279531_, 1.2f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 0.5f);
        level.m_7967_((Entity)itementity);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == WabItems.TOXLACANTH.get();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controller) {
        controller.add(new AnimationController[]{Soarer.state(this), Soarer.attack(this), Soarer.baby(this)});
    }

    private static <T extends LivingEntity> AnimationController<T> baby(T entity) {
        return new AnimationController(entity, "baby", 1, state -> {
            if (entity.m_6162_()) {
                return state.setAndContinue(BABY);
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        });
    }

    private static AnimationController<Soarer> attack(Soarer entity) {
        return new AnimationController((GeoAnimatable)entity, "attack", 1, state -> {
            if (entity.isAttacking()) {
                return state.setAndContinue(ATTACK);
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        });
    }

    private static AnimationController<Soarer> state(Soarer soarer) {
        return new AnimationController((GeoAnimatable)soarer, "state", 1, state -> {
            if (soarer.tickLeft <= 0) {
                if (soarer.flapTick > 0) {
                    soarer.setState(State.FLAP);
                } else if (soarer.m_29443_()) {
                    if (soarer.m_20142_()) {
                        soarer.setState(State.DIVE);
                    } else {
                        soarer.setState(State.GLIDE);
                    }
                } else {
                    if (soarer.isAttacking()) {
                        state.getController().forceAnimationReset();
                        return PlayState.STOP;
                    }
                    if (soarer.isMoving()) {
                        soarer.setState(State.WALK);
                    } else {
                        soarer.setState(State.IDLE);
                    }
                }
            }
            return state.setAndContinue(soarer.getState().getAnimation());
        });
    }

    public int getFlaps() {
        return this.flaps;
    }

    public void setFlaps(int flaps) {
        this.flaps = Math.min(15, Math.max(0, flaps));
    }

    public void addFlaps(int flaps) {
        this.setFlaps(this.getFlaps() + flaps);
    }

    public void setAttacking(boolean isAttacking) {
        this.f_19804_.m_135381_(IS_ATTACKING, (Object)isAttacking);
        if (isAttacking) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)WabSounds.SOARER_ATTACK.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
        }
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(IS_ATTACKING);
    }

    public State getState() {
        State[] states = State.values();
        return states[Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(STATE)), (int)0, (int)(states.length - 1))];
    }

    public void setState(State state) {
        State oldState = this.getState();
        if (state.isFly() && !oldState.isFly()) {
            state = State.START_FLYING;
        } else if (!state.isFly() && oldState.isFly()) {
            state = State.STOP_FLYING;
        } else if (state == State.DIVE && (oldState == State.GLIDE || oldState == State.FLAP)) {
            state = State.GLIDE_TO_DIVE;
        } else if ((state == State.GLIDE || state == State.FLAP) && oldState == State.DIVE) {
            state = State.DIVE_TO_GLIDE;
        }
        this.tickLeft = state.getDuration();
        this.f_19804_.m_135381_(STATE, (Object)state.ordinal());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            Vec3 currentMotion;
            if (this.getState() == State.FLAP && this.tickLeft == State.FLAP.getDuration() - 8) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)WabSounds.SOARER_FLAP.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            } else if (this.getState() == State.START_FLYING && this.tickLeft == State.START_FLYING.getDuration() - 25) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)WabSounds.SOARER_FLAP_START.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            } else if (this.getState() == State.STOP_FLYING && this.tickLeft == State.STOP_FLYING.getDuration()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)WabSounds.SOARER_LANDING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            }
            this.tickLeft = Math.max(this.tickLeft - 1, 0);
            this.flapTick = Math.max(this.flapTick - 1, 0);
            if (this.flapTick == 16) {
                currentMotion = this.m_20184_();
                this.m_20334_(currentMotion.f_82479_, this.powerFlap, currentMotion.f_82481_);
            }
            if (this.m_20069_()) {
                currentMotion = this.m_20184_();
                this.m_20334_(currentMotion.f_82479_, -0.4, currentMotion.f_82481_);
            }
            currentMotion = this.m_20184_();
            if (currentMotion.f_82480_ < 0.0 && this.m_29443_()) {
                this.m_20334_(currentMotion.f_82479_, currentMotion.f_82480_ * (this.m_20142_() ? 0.9 : 0.5), currentMotion.f_82481_);
            }
        } else {
            this.attackTick = Math.max(this.attackTick - 1, -10);
            LivingEntity target = this.m_5448_();
            if (this.attackTick == 12 && target != null && target.m_6084_() && this.m_6084_()) {
                if (this.m_217066_(target)) {
                    this.m_6674_(InteractionHand.MAIN_HAND);
                    this.m_7327_((Entity)target);
                }
            } else if (this.attackTick == 0) {
                this.setAttacking(false);
            }
        }
        if (!this.m_29443_() && this.m_9236_().m_46467_() % 160L == 0L) {
            this.addFlaps(1);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        for (WabEntityPart<Soarer> part : this.subEntities) {
            part.update();
        }
    }

    @NotNull
    public InteractionResult m_6071_(Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (this.m_6898_(itemstack)) {
            if (!this.m_21824_() && !this.m_6162_()) {
                this.m_142075_(pPlayer, pHand, itemstack);
                if (!this.m_9236_().f_46443_) {
                    if (this.f_19796_.m_188503_(2) == 0) {
                        this.m_21828_(pPlayer);
                        this.m_9236_().m_7605_((Entity)this, (byte)7);
                    } else {
                        this.m_9236_().m_7605_((Entity)this, (byte)6);
                    }
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (this.getFlaps() < 15) {
                this.m_142075_(pPlayer, pHand, itemstack);
                this.addFlaps(10);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (this.m_21223_() < this.m_21233_()) {
                this.m_142075_(pPlayer, pHand, itemstack);
                this.m_5634_(6.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (this.m_6162_()) {
                this.m_142075_(pPlayer, pHand, itemstack);
                this.m_146740_(Soarer.m_216967_((int)(-this.m_146764_())), true);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        } else {
            if (itemstack.m_41720_() == Items.f_42529_ && !this.m_6162_() && !this.m_27593_()) {
                this.m_142075_(pPlayer, pHand, itemstack);
                this.m_27595_(pPlayer);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (itemstack.m_41720_() == Items.f_42450_ && !this.m_6254_() && this.m_6741_()) {
                this.m_142075_(pPlayer, pHand, itemstack);
                this.m_5853_(null);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        }
        if (pPlayer.m_36341_()) {
            this.m_213583_(pPlayer);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_7310_((Entity)pPlayer)) {
            if (!this.m_9236_().f_46443_) {
                pPlayer.m_20329_((Entity)this);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_213583_(Player player) {
        if (!this.m_9236_().f_46443_ && (!this.m_20160_() || this.m_20363_((Entity)player)) && this.m_21824_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.f_36096_ != serverPlayer.f_36095_) {
                serverPlayer.m_6915_();
            }
            serverPlayer.m_9217_();
            PacketHandler.sendToPlayer(new SoarerScreenOpenPacket(serverPlayer.f_8940_, serverPlayer.m_150109_().m_6643_() + 1, this.m_19879_()), serverPlayer);
            serverPlayer.f_36096_ = new SoarerInventoryMenu(serverPlayer.f_8940_, serverPlayer.m_150109_(), (Container)this.inventory, this);
            serverPlayer.m_143399_(serverPlayer.f_36096_);
            MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)serverPlayer, serverPlayer.f_36096_));
        }
    }

    protected void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(1);
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
    }

    public SlotAccess m_141942_(final int pSlot) {
        int i = pSlot - 400;
        if (i == 0) {
            return new SlotAccess(){

                public ItemStack m_142196_() {
                    return Soarer.this.inventory.m_8020_(pSlot);
                }

                public boolean m_142104_(ItemStack itemStack) {
                    if (itemStack.m_41619_() || itemStack.m_150930_(Items.f_42450_)) {
                        Soarer.this.inventory.m_6836_(pSlot, itemStack);
                        Soarer.this.updateContainerEquipment();
                        return true;
                    }
                    return false;
                }
            };
        }
        int j = pSlot - 500 + 1;
        return j > 0 && j < this.inventory.m_6643_() ? SlotAccess.m_147292_((Container)this.inventory, (int)j) : super.m_141942_(pSlot);
    }

    public void m_6710_(@Nullable LivingEntity pTarget) {
        if (!this.m_6162_()) {
            super.m_6710_(pTarget);
        }
    }

    public boolean m_217066_(LivingEntity entity) {
        return this.m_20280_((Entity)entity) < 8.0;
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
                this.m_19983_(itemstack);
            }
        }
    }

    public boolean m_29443_() {
        return !this.m_20096_() && this.height() > 4.0;
    }

    public double height() {
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(this.m_146903_(), this.m_146904_(), this.m_146907_());
        Level level = this.m_9236_();
        while (blockPos.m_123342_() > level.m_141937_() && level.m_8055_((BlockPos)blockPos).m_60795_()) {
            blockPos.m_122184_(0, -1, 0);
        }
        return this.m_20186_() - (double)blockPos.m_123342_();
    }

    protected void m_274498_(Player player, Vec3 vec3) {
        Vec2 vec2 = new Vec2(player.m_146909_() * 0.5f, player.m_146908_());
        this.m_19915_(vec2.f_82471_, vec2.f_82470_);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
    }

    protected Vec3 m_274312_(Player player, Vec3 vec3) {
        if (this.m_29443_()) {
            return new Vec3(0.0, 0.0, 1.0);
        }
        if (this.flapTick <= 0) {
            return new Vec3(0.0, 0.0, (double)Math.max(player.f_20902_, 0.0f));
        }
        return new Vec3(0.0, 0.0, 0.0);
    }

    protected boolean m_7310_(Entity pPassenger) {
        if (pPassenger instanceof LivingEntity) {
            LivingEntity passenger = (LivingEntity)pPassenger;
            return !this.m_6162_() && this.m_20197_().isEmpty() && this.m_21830_(passenger);
        }
        return false;
    }

    public LivingEntity m_6688_() {
        return this.m_146895_() == this.m_269323_() && this.m_6254_() ? this.m_269323_() : null;
    }

    protected void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        Vec3 vec3 = new Vec3(0.0, 1.3, 0.0).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
        moveFunction.m_20372_(entity, this.m_20185_() + vec3.f_82479_, this.m_20186_() + vec3.f_82480_, this.m_20189_() + vec3.f_82481_);
        this.clampRotation(entity);
    }

    protected Vector3f m_292594_(Entity entity, EntityDimensions dim, float p_299886_) {
        return new Vector3f(0.0f, 1.3f, 0.0f);
    }

    public void m_7340_(Entity pEntityToUpdate) {
        if (this.m_6688_() != pEntityToUpdate) {
            this.clampRotation(pEntityToUpdate);
        }
    }

    private void clampRotation(Entity pEntity) {
        pEntity.m_5618_(this.m_146908_());
        float f = pEntity.m_146908_();
        float f1 = Mth.m_14177_((float)(f - this.m_146908_()));
        float f2 = Mth.m_14036_((float)f1, (float)-160.0f, (float)160.0f);
        pEntity.f_19859_ += f2 - f1;
        float f3 = f + f2 - f1;
        pEntity.m_146922_(f3);
        pEntity.m_5616_(f3);
    }

    public boolean m_6147_() {
        return false;
    }

    public boolean m_6107_() {
        return super.m_6107_() || this.m_6688_() != null;
    }

    protected float m_245547_(Player player) {
        if (!this.m_29443_()) {
            return (float)this.m_21133_(Attributes.f_22279_) * 0.6f;
        }
        return (float)this.m_21133_(Attributes.f_22280_) + (this.m_20142_() ? 0.4f : 0.0f);
    }

    public boolean m_6094_() {
        return !this.m_20160_();
    }

    @NotNull
    public Vec3 m_7688_(@NotNull LivingEntity pLivingEntity) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() != Direction.Axis.Y) {
            int[][] aint = DismountHelper.m_38467_((Direction)direction);
            BlockPos blockpos = this.m_20183_();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (Pose pose : pLivingEntity.m_7431_()) {
                AABB aabb = pLivingEntity.m_21270_(pose);
                for (int[] aint1 : aint) {
                    blockpos$mutableblockpos.m_122178_(blockpos.m_123341_() + aint1[0], blockpos.m_123342_(), blockpos.m_123343_() + aint1[1]);
                    double d0 = this.m_9236_().m_45573_((BlockPos)blockpos$mutableblockpos);
                    if (!DismountHelper.m_38439_((double)d0)) continue;
                    Vec3 vec3 = Vec3.m_82514_((Vec3i)blockpos$mutableblockpos, (double)d0);
                    if (!DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)pLivingEntity, (AABB)aabb.m_82383_(vec3))) continue;
                    pLivingEntity.m_20124_(pose);
                    return vec3;
                }
            }
        }
        return super.m_7688_(pLivingEntity);
    }

    protected void updateContainerEquipment() {
        if (!this.m_9236_().f_46443_) {
            this.setSaddled(!this.inventory.m_8020_(0).m_41619_());
        }
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_() && this.m_21824_();
    }

    public void m_5853_(@Nullable SoundSource soundSource) {
        this.inventory.m_6836_(0, new ItemStack((ItemLike)Items.f_42450_));
        this.updateContainerEquipment();
    }

    public boolean m_6254_() {
        return (Boolean)this.f_19804_.m_135370_(IS_SADDLED);
    }

    public void setSaddled(boolean isSaddled) {
        this.f_19804_.m_135381_(IS_SADDLED, (Object)isSaddled);
    }

    public boolean m_7848_(@NotNull Animal pOtherAnimal) {
        if (pOtherAnimal != this && pOtherAnimal instanceof Soarer) {
            Soarer soarer = (Soarer)pOtherAnimal;
            return this.canParent() && soarer.canParent();
        }
        return false;
    }

    protected boolean canParent() {
        return !this.m_20160_() && !this.m_20159_() && !this.m_6162_() && this.m_27593_();
    }

    public void m_5757_(Container container) {
        boolean flag = this.m_6254_();
        this.updateContainerEquipment();
        if (this.f_19797_ > 20 && !flag && this.m_6254_()) {
            this.m_5496_(this.m_246265_(), 0.5f, 1.0f);
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_7888_(int power) {
        if (this.m_29443_()) {
            this.powerFlap = 1.5 + Math.pow(this.powerFlap, 2.0) / 1500.0;
            this.flapTick = State.FLAP.getDuration() + (this.getState() == State.DIVE ? State.DIVE_TO_GLIDE.getDuration() : 0);
        } else {
            this.powerFlap = 2.0 + Math.pow(this.powerFlap, 2.0) / 1000.0;
            this.flapTick = State.START_FLYING.getDuration() + 6;
            this.setState(State.START_FLYING);
        }
        this.addFlaps(-1);
        PacketHandler.sendToServer(new SoarerJumpPacket(this.m_19879_(), -1));
    }

    public boolean isMultipartEntity() {
        return true;
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public void m_20234_(int id) {
        super.m_20234_(id);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(id + i + 1);
        }
    }

    public boolean m_264410_() {
        return this.flapTick <= 0 && this.m_29443_();
    }

    public boolean m_20142_() {
        return super.m_20142_() || this.m_269323_() != null && this.m_20160_() && this.m_269323_().m_20142_() && this.m_264410_();
    }

    public boolean isMoving() {
        return this.m_20184_().f_82479_ != 0.0 || this.m_20184_().f_82481_ != 0.0;
    }

    public MobType m_6336_() {
        return WabEntities.ANCIENT_MOB;
    }

    public boolean m_7132_() {
        return this.m_6254_() && this.getFlaps() > 0 && !this.m_20069_() && !this.f_146808_ && !this.m_20077_();
    }

    public void m_7199_(int i) {
    }

    public void m_8012_() {
    }

    public int m_6784_() {
        return 0;
    }

    public void m_7870_(int i) {
    }

    @Nullable
    public UUID m_6120_() {
        return null;
    }

    public void m_6925_(@Nullable UUID uuid) {
    }

    public void m_6825_() {
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.m_29443_()) {
            return this.getState() == State.GLIDE ? (SoundEvent)WabSounds.SOARER_GLIDE.get() : null;
        }
        return (SoundEvent)WabSounds.SOARER_IDLE.get();
    }

    public static enum State {
        IDLE(RawAnimation.begin().thenPlay("misc.ground_idle"), false),
        WALK(RawAnimation.begin().thenPlay("move.walk"), false),
        START_FLYING(RawAnimation.begin().thenPlay("move.start_flying"), true, 40),
        GLIDE(RawAnimation.begin().thenPlay("move.glide"), true),
        GLIDE_TO_DIVE(RawAnimation.begin().thenPlay("move.glide_dive_trasition"), true, 18),
        DIVE_TO_GLIDE(RawAnimation.begin().thenPlay("move.dive_glide_transition"), true, 18),
        DIVE(RawAnimation.begin().thenPlay("move.dive"), true),
        FLAP(RawAnimation.begin().thenPlay("move.wing_flap"), true, 28),
        STOP_FLYING(RawAnimation.begin().thenPlay("move.landing"), false, 30);

        private final RawAnimation animation;
        private final boolean isFly;
        private final int duration;

        private State(RawAnimation animation, boolean isFly) {
            this.animation = animation;
            this.isFly = isFly;
            this.duration = 0;
        }

        private State(RawAnimation animation, boolean isFly, int duration) {
            this.animation = animation;
            this.isFly = isFly;
            this.duration = duration;
        }

        public RawAnimation getAnimation() {
            return this.animation;
        }

        public boolean isFly() {
            return this.isFly;
        }

        public int getDuration() {
            return this.duration;
        }
    }
}

