/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.wanmine.wab.block.entity.AncientSkullEntity;
import net.wanmine.wab.init.world.WabBlocks;
import org.jetbrains.annotations.Nullable;

public class AncientSkull
extends BaseEntityBlock {
    public static final int ROTATIONS = RotationSegment.m_247348_() + 1;
    public static final IntegerProperty ROTATION = BlockStateProperties.f_61390_;
    public static final BooleanProperty ON_WALL = BooleanProperty.m_61465_((String)"on_wall");
    public final Type type;

    public AncientSkull(Type type, BlockBehaviour.Properties properties) {
        super(properties);
        this.type = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(0))).m_61124_((Property)ON_WALL, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new AncientSkullEntity(this.type, blockPos, blockState);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)ON_WALL)).booleanValue()) {
            return this.type.getWallShape((Integer)state.m_61143_((Property)ROTATION) / 4 * 90);
        }
        return this.type.shape;
    }

    public BlockState m_5573_(BlockPlaceContext placeContext) {
        if (placeContext.m_43719_().m_122434_() == Direction.Axis.Y) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(RotationSegment.m_246374_((float)placeContext.m_7074_())))).m_61124_((Property)ON_WALL, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)ROTATION, (Comparable)Integer.valueOf((int)(placeContext.m_43719_().m_122424_().m_122435_() / 90.0f) * 4))).m_61124_((Property)ON_WALL, (Comparable)Boolean.valueOf(true));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(rotation.m_55949_(((Integer)state.m_61143_((Property)ROTATION)).intValue(), ROTATIONS)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(mirror.m_54843_(((Integer)state.m_61143_((Property)ROTATION)).intValue(), ROTATIONS)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_56329_) {
        p_56329_.m_61104_(new Property[]{ROTATION, ON_WALL});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean m_7357_(BlockState blockState, BlockGetter getter, BlockPos pos, PathComputationType computationType) {
        return false;
    }

    public static enum Type {
        SNIFFER("sniffer", (Supplier<BlockEntityType<AncientSkullEntity>>)WabBlocks.Entities.SNIFFER_SKULL, Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), Block.m_49796_((double)2.0, (double)1.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0)),
        EATER("eater", (Supplier<BlockEntityType<AncientSkullEntity>>)WabBlocks.Entities.EATER_SKULL, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)),
        WALKER("walker", (Supplier<BlockEntityType<AncientSkullEntity>>)WabBlocks.Entities.WALKER_SKULL, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)),
        CRUSHER("crusher", (Supplier<BlockEntityType<AncientSkullEntity>>)WabBlocks.Entities.CRUSHER_SKULL, Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), Block.m_49796_((double)3.0, (double)3.0, (double)4.0, (double)13.0, (double)13.0, (double)16.0)),
        GLIDER("glider", (Supplier<BlockEntityType<AncientSkullEntity>>)WabBlocks.Entities.GLIDER_SKULL, Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), Block.m_49796_((double)5.0, (double)5.0, (double)2.0, (double)11.0, (double)11.0, (double)16.0)),
        SOARER("soarer", (Supplier<BlockEntityType<AncientSkullEntity>>)WabBlocks.Entities.SOARER_SKULL, Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0), Block.m_49796_((double)3.0, (double)2.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0)),
        CHARGER("charger", (Supplier<BlockEntityType<AncientSkullEntity>>)WabBlocks.Entities.CHARGER_SKULL, Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0), Block.m_49796_((double)2.0, (double)2.0, (double)1.0, (double)14.0, (double)15.0, (double)16.0)),
        SURFER("surfer", (Supplier<BlockEntityType<AncientSkullEntity>>)WabBlocks.Entities.SURFER_SKULL, Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), Block.m_49796_((double)3.0, (double)4.0, (double)0.0, (double)13.0, (double)12.0, (double)16.0)),
        RAIDER("raider", (Supplier<BlockEntityType<AncientSkullEntity>>)WabBlocks.Entities.RAIDER_SKULL, Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0), Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)15.0, (double)16.0));

        public final String name;
        public final Supplier<BlockEntityType<AncientSkullEntity>> entity;
        public final VoxelShape shape;
        public final VoxelShape wallShape;

        private Type(String name, Supplier<BlockEntityType<AncientSkullEntity>> entity, VoxelShape shape, VoxelShape wallShape) {
            this.name = name;
            this.entity = entity;
            this.shape = shape;
            this.wallShape = wallShape;
        }

        public VoxelShape getWallShape(int rotation) {
            VoxelShape shape = this.wallShape;
            for (int i = 0; i < rotation / 90; ++i) {
                shape = Type.rotate90(shape);
            }
            return shape;
        }

        private static VoxelShape rotate90(VoxelShape shape) {
            VoxelShape rotated = Shapes.m_83040_();
            for (AABB box : shape.m_83299_()) {
                AABB newBox = new AABB(1.0 - box.f_82293_, box.f_82289_, box.f_82288_, 1.0 - box.f_82290_, box.f_82292_, box.f_82291_);
                rotated = Shapes.m_83110_((VoxelShape)rotated, (VoxelShape)Shapes.m_83064_((AABB)newBox));
            }
            return rotated;
        }
    }
}

