/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.init.gen.assets;

import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.SoundDefinition;
import net.minecraftforge.common.data.SoundDefinitionsProvider;
import net.minecraftforge.registries.RegistryObject;
import net.wanmine.wab.WanAncientBeasts;
import net.wanmine.wab.init.world.WabSounds;

public class WabSoundsGenerator
extends SoundDefinitionsProvider {
    public WabSoundsGenerator(PackOutput output, ExistingFileHelper helper) {
        super(output, "wan_ancient_beasts", helper);
    }

    public void registerSounds() {
        this.addWanSound(WabSounds.EGG_HATCHED, "Egg Hatched", 3);
        this.addWanSound(WabSounds.EATER_IDLE, "Eater Ambient", 2);
        this.addWanSound(WabSounds.EATER_SLEEP, "Eater Sleep", 3);
        this.addWanSound(WabSounds.EATER_STEP, "Eater Step", 6);
        this.addWanSound(WabSounds.EATER_BITE, "Eater Bite");
        this.addWanSound(WabSounds.EATER_HIT, "Eater Hurt");
        this.addWanSound(WabSounds.BABY_EATER_ROAR, "Eater Roar");
        this.addWanSound(WabSounds.EATER_ROAR, "Eater Roar");
        this.addWanSound(WabSounds.EATER_DEATH, "Eater Death");
        this.addWanSound(WabSounds.WALKER_IDLE, "Walker Ambient", 5);
        this.addWanSound(WabSounds.WALKER_STEP, "Walker Step", 6);
        this.addWanSound(WabSounds.WALKER_HIT, "Walker Hurt", 3);
        this.addWanSound(WabSounds.WALKER_DEATH, "Walker Death");
        this.addWanSound(WabSounds.CRUSHER_IDLE, "Crusher Ambient");
        this.addWanSound(WabSounds.CRUSHER_ATTACK, "Crusher Attack", 2);
        this.addWanSound(WabSounds.CRUSHER_ATTACK_AREA, "Crusher Attack");
        this.addWanSound(WabSounds.CRUSHER_HURT, "Crusher Hurt", 2);
        this.addWanSound(WabSounds.GLIDER_IDLE, "Glider Ambient", 3);
        this.addWanSound(WabSounds.GLIDER_FLAP_START, "Eater Flap");
        this.addWanSound(WabSounds.GLIDER_FLAP, "Eater Flap", 2);
        this.addWanSound(WabSounds.GLIDER_LANDING, "Eater Flap");
        this.addWanSound(WabSounds.GLIDER_HURT, "Eater Hurt");
        this.addWanSound(WabSounds.GLIDER_DEATH, "Eater Death");
        this.addWanSound(WabSounds.SOARER_IDLE, "Soarer Ambient", 2);
        this.addWanSound(WabSounds.SOARER_FLAP_START, "Soarer Flap");
        this.addWanSound(WabSounds.SOARER_FLAP, "Soarer Flap");
        this.addWanSound(WabSounds.SOARER_LANDING, "Soarer Flap");
        this.addWanSound(WabSounds.SOARER_GLIDE, "Soarer Glide");
        this.addWanSound(WabSounds.SOARER_ATTACK, "Soarer Attack");
        this.addWanSound(WabSounds.SURFER_IDLE, "Surfer Ambient");
        this.addWanSound(WabSounds.SURFER_WALK, "Surfer Step");
        this.addWanSound(WabSounds.SURFER_RUN, "Surfer Step");
        this.addWanSound(WabSounds.SURFER_IDLE_WATER, "Surfer Ambient");
        this.addWanSound(WabSounds.SURFER_SWIM, "Surfer Swimming", 1, 2);
        this.addWanSound(WabSounds.SURFER_FAST_SWIM, "Surfer Swimming");
        this.addWanSound(WabSounds.SURFER_IDLE_TO_RELAX, "Surfer Relaxing");
        this.addWanSound(WabSounds.SURFER_RELAX, "Surfer Relaxing");
        this.addWanSound(WabSounds.SURFER_RELAX_TO_IDLE, "Surfer Relaxing");
        this.addWanSound(WabSounds.SURFER_JUMP_START, "Surfer Jumping");
        this.addWanSound(WabSounds.SURFER_JUMP_POSE, "Surfer Jumping");
        this.addWanSound(WabSounds.SURFER_JUMP_LANDING, "Surfer Jumping");
        this.addWanSound(WabSounds.SURFER_ROAR, "Surfer Roar", 4, 4);
        this.addWanSound(WabSounds.SURFER_HURT, "Surfer Hurt", 3);
        this.addWanSound(WabSounds.SURFER_DEATH, "Surfer Death");
    }

    protected void addWanSound(RegistryObject<SoundEvent> sound, String subtitle) {
        String[] name = sound.getId().m_135815_().split("\\.");
        this.addWanSound(sound, WabSoundsGenerator.resource(name[1] + "_" + name[2]), subtitle);
    }

    protected void addWanSound(WabSounds.AgeableSoundRegistry sound, String subtitle) {
        this.addWanSound(sound.adult(), subtitle);
        this.addWanSound(sound.baby(), subtitle);
    }

    protected void addWanSound(RegistryObject<SoundEvent> sound, ResourceLocation resource, String subtitle) {
        this.add((Supplier)sound, SoundDefinition.definition().subtitle(subtitle).with(WabSoundsGenerator.sound((ResourceLocation)resource)));
    }

    protected void addWanSound(RegistryObject<SoundEvent> sound, String subtitle, int count) {
        String[] name = sound.getId().m_135815_().split("\\.");
        this.addWanSound(sound, name[1] + "_" + name[2], subtitle, count);
    }

    protected void addWanSound(WabSounds.AgeableSoundRegistry sound, String subtitle, int countBaby, int countAdult) {
        this.addWanSound(sound.adult(), subtitle, countAdult);
        this.addWanSound(sound.baby(), subtitle, countBaby);
    }

    protected void addWanSound(RegistryObject<SoundEvent> sound, String name, String subtitle, int count) {
        this.add((Supplier)sound, SoundDefinition.definition().subtitle(subtitle).with(WabSoundsGenerator.sounds(name, count)));
    }

    protected static SoundDefinition.Sound[] sounds(String name, int count) {
        if (count == 1) {
            return new SoundDefinition.Sound[]{WabSoundsGenerator.sound((ResourceLocation)WabSoundsGenerator.resource(name))};
        }
        SoundDefinition.Sound[] sounds = new SoundDefinition.Sound[count];
        for (int i = 0; i < count; ++i) {
            sounds[i] = WabSoundsGenerator.sound((ResourceLocation)WabSoundsGenerator.resource(name + "_" + (i + 1)));
        }
        return sounds;
    }

    private static ResourceLocation resource(String name) {
        return WanAncientBeasts.resource(name);
    }
}

