/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.client.entity.render.blocks;

import com.mojang.math.Axis;
import java.util.Objects;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.block.AzBlockEntityRenderer;
import mod.azure.azurelib.rewrite.render.block.AzBlockEntityRendererConfig;
import mod.azure.azurelib.rewrite.render.layer.AzBlockAndItemLayer;
import mod.azure.azurelib.rewrite.render.layer.AzRenderLayer;
import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.common.block.animators.StatueHuggerAnimator;
import mods.cybercat.gigeresque.common.block.entity.AlienStorageHuggerEntity;
import mods.cybercat.gigeresque.common.entity.GigEntities;
import mods.cybercat.gigeresque.common.entity.impl.classic.FacehuggerEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class SarcophagusHuggerRender<T extends AlienStorageHuggerEntity>
extends AzBlockEntityRenderer<T> {
    private static final ResourceLocation MODEL = Constants.modResource("geo/block/sarcophagus/sarcophagus.geo.json");
    private static final ResourceLocation TEXTURE = Constants.modResource("textures/block/sarcophagus/sarcophagus.png");

    public SarcophagusHuggerRender() {
        super(AzBlockEntityRendererConfig.builder((ResourceLocation)MODEL, (ResourceLocation)TEXTURE).setAnimatorProvider(StatueHuggerAnimator::new).addRenderLayer((AzRenderLayer)new AzBlockAndItemLayer<T>(){

            public ItemStack itemStackForBone(AzBone bone, T animatable) {
                return bone.getName().equalsIgnoreCase("heldItem") ? new ItemStack((ItemLike)Items.AIR) : null;
            }

            protected ItemDisplayContext getTransformTypeForStack(AzBone bone, ItemStack stack, T animatable) {
                return ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
            }

            protected void renderItemForBone(AzRendererPipelineContext<T> context, AzBone bone, ItemStack itemStack, T animatable) {
                context.poseStack().mulPose(Axis.XP.rotationDegrees(-90.0f));
                context.poseStack().mulPose(Axis.YP.rotationDegrees(180.0f));
                context.poseStack().mulPose(Axis.ZP.rotationDegrees(0.0f));
                context.poseStack().translate(0.0, 0.0, -2.0);
                context.poseStack().scale(0.7f, 0.7f, 0.7f);
                if (((AlienStorageHuggerEntity)((Object)context.animatable())).checkHuggerstatus()) {
                    Minecraft.getInstance().getEntityRenderDispatcher().render((Entity)Objects.requireNonNull((FacehuggerEntity)GigEntities.FACEHUGGER.get().create(Objects.requireNonNull(((AlienStorageHuggerEntity)((Object)context.animatable())).getLevel()))), 0.0, 0.0, 0.0, 0.0f, context.partialTick(), context.poseStack(), context.multiBufferSource(), context.packedLight());
                }
                super.renderItemForBone(context, bone, itemStack, animatable);
            }
        }).build());
    }
}

