/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.client.entity.render.feature;

import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.layer.AzRenderLayer;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.client.entity.render.feature.EggmorphFeatureRenderer;
import mods.cybercat.gigeresque.common.tags.GigTags;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class EggmorphGeoFeatureRenderer<T extends Entity>
implements AzRenderLayer<T> {
    private int fovEggticker = 0;

    public void preRender(AzRendererPipelineContext<T> context) {
    }

    public void render(AzRendererPipelineContext<T> context) {
        LivingEntity livingEntity;
        Entity animatable = (Entity)context.animatable();
        AzRendererPipeline renderPipeline = context.rendererPipeline();
        ResourceLocation textureLocation = renderPipeline.config().textureLocation((Object)animatable);
        RenderType renderLayer = EggmorphFeatureRenderer.getEggmorphLayerTexture((ResourceLocation)textureLocation).renderLayer;
        if (animatable instanceof LivingEntity && (livingEntity = (LivingEntity)animatable).getInBlockState().is(GigTags.NEST_CROSS_BLOCKS)) {
            ++this.fovEggticker;
            float progress = (float)this.fovEggticker / CommonMod.config.getEggmorphTickTimer();
            context.setVertexConsumer(context.multiBufferSource().getBuffer(renderLayer));
            int alpha = (int)(progress * 255.0f) << 24;
            int color = context.renderColor() & 0xFFFFFF | alpha;
            context.setRenderColor(color);
            renderPipeline.reRender(context);
        }
    }

    public void renderForBone(AzRendererPipelineContext<T> context, AzBone bone) {
    }
}

