/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.ai.goals.attack;

import java.util.function.Predicate;
import mods.cybercat.gigeresque.bvanseg.Cooldown;
import mods.cybercat.gigeresque.common.block.GigBlocks;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class DelayedClassicAttackGoal
extends MeleeAttackGoal {
    private static final Predicate<BlockState> NEST = state -> state.is(GigBlocks.NEST_RESIN_WEB_CROSS.get());
    private final AlienEntity alienEntity;
    private final Cooldown attackAnimationCooldown;
    private boolean ranAttackAnimation;

    public DelayedClassicAttackGoal(AlienEntity alienEntity, double speedModifier, int delayTicksBeforeAttack) {
        super((PathfinderMob)alienEntity, speedModifier, true);
        this.alienEntity = alienEntity;
        this.attackAnimationCooldown = Cooldown.withCooldownTimeInTicks("attackAnimationCooldownInTicks", delayTicksBeforeAttack);
    }

    public void tick() {
        super.tick();
        this.attackAnimationCooldown.tick();
        if (this.alienEntity.getTarget() != null && this.ranAttackAnimation && !this.attackAnimationCooldown.isActive() && this.alienEntity.isWithinMeleeAttackRange(this.alienEntity.getTarget()) && this.alienEntity.getSensing().hasLineOfSight((Entity)this.alienEntity.getTarget())) {
            this.resetAttackCooldown();
            if (this.canGrab()) {
                this.alienEntity.grabTarget((Entity)this.alienEntity.getTarget());
            } else {
                this.mob.swing(InteractionHand.MAIN_HAND);
                this.mob.doHurtTarget((Entity)this.alienEntity.getTarget());
            }
            this.ranAttackAnimation = false;
        }
    }

    protected void checkAndPerformAttack(@NotNull LivingEntity target) {
        if (!this.ranAttackAnimation && this.canPerformAttack(target)) {
            this.alienEntity.animationSelector.select(this.alienEntity);
            this.ranAttackAnimation = true;
            this.attackAnimationCooldown.reset();
        }
    }

    public boolean canUse() {
        return this.isAbleToAttack() && super.canUse();
    }

    public boolean canContinueToUse() {
        return this.isAbleToAttack() && super.canContinueToUse();
    }

    private boolean isAbleToAttack() {
        if (this.alienEntity.isVehicle() || this.alienEntity.getTarget() == null) {
            return false;
        }
        return !NEST.test(this.alienEntity.getTarget().getInBlockState());
    }

    public void stop() {
        LivingEntity livingentity = this.alienEntity.getTarget();
        if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(livingentity)) {
            this.alienEntity.setTarget(null);
        }
        this.alienEntity.setAggressive(false);
    }

    private boolean canGrab() {
        LivingEntity livingEntity = this.mob.getTarget();
        if (livingEntity instanceof LivingEntity) {
            LivingEntity livingEntity2 = livingEntity;
            int randomPhase = this.mob.getRandom().nextInt(0, 100);
            return randomPhase < 33 && (double)livingEntity2.getHealth() <= (double)livingEntity2.getMaxHealth() * 0.5;
        }
        return false;
    }
}

