/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.ai.nav;

import mods.cybercat.gigeresque.common.entity.AlienEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;

public class WaterMoveControl
extends MoveControl {
    private final AlienEntity xenomorph;

    public WaterMoveControl(AlienEntity xenomorph) {
        super((Mob)xenomorph);
        this.xenomorph = xenomorph;
    }

    public void tick() {
        LivingEntity livingEntity = this.xenomorph.getTarget();
        if (this.xenomorph.isUnderWater()) {
            if (livingEntity != null && livingEntity.getY() > this.xenomorph.getY()) {
                this.xenomorph.setDeltaMovement(this.xenomorph.getDeltaMovement().add(0.0, 0.02, 0.0));
            }
            if (this.operation != MoveControl.Operation.MOVE_TO || this.xenomorph.getNavigation().isDone()) {
                this.xenomorph.setSpeed(0.0f);
                return;
            }
            double d = this.wantedX - this.xenomorph.getX();
            double e = this.wantedY - this.xenomorph.getY();
            double f = this.wantedZ - this.xenomorph.getZ();
            double g = Math.sqrt(d * d + e * e + f * f);
            e /= g;
            float h = (float)(Mth.atan2((double)f, (double)d) * 180.0 / 3.1415927410125732) - 90.0f;
            this.xenomorph.setYRot(this.rotlerp(this.xenomorph.getYRot(), h, 90.0f));
            this.xenomorph.yBodyRot = this.xenomorph.getYRot();
            float i = (float)(this.speedModifier * this.xenomorph.getAttributeValue(Attributes.MOVEMENT_SPEED));
            float j = Mth.lerp((float)0.525f, (float)this.xenomorph.getSpeed(), (float)i);
            this.xenomorph.setSpeed(j);
            this.xenomorph.setDeltaMovement(this.xenomorph.getDeltaMovement().add((double)j * d * 0.005, (double)j * e * 0.1, (double)j * f * 0.005));
        } else {
            if (!this.xenomorph.onGround()) {
                this.xenomorph.setDeltaMovement(this.xenomorph.getDeltaMovement().add(0.0, -0.008, 0.0));
            }
            super.tick();
        }
    }
}

