/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.helper;

import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.entity.helper.AnimationDispatcher;
import mods.cybercat.gigeresque.common.entity.helper.GigCommonMethods;
import mods.cybercat.gigeresque.common.entity.impl.misc.SpitterEntity;
import mods.cybercat.gigeresque.interfacing.AnimationSelector;
import net.minecraft.world.phys.Vec3;

public record GigMeleeAttackSelector() {
    public static final AnimationSelector<AlienEntity> CLASSIC_ANIM_SELECTOR = classicAlienEntity -> {
        boolean isCrawling = classicAlienEntity.crawlingManager.isCrawling();
        boolean isInWater = classicAlienEntity.isInWater();
        AnimationDispatcher dispatcher = classicAlienEntity.animationDispatcher;
        Runnable animKey = switch (classicAlienEntity.getRandom().nextInt(4)) {
            case 1 -> {
                if (isCrawling) {
                    yield dispatcher::sendRightClawCrawling;
                }
                if (isInWater) {
                    yield dispatcher::sendRightClawBasic;
                }
                yield dispatcher::sendRightClaw;
            }
            case 2 -> {
                if (isCrawling) {
                    yield dispatcher::sendLeftClawCrawling;
                }
                if (isInWater) {
                    yield dispatcher::sendLeftTailBasic;
                }
                yield dispatcher::sendLeftTail;
            }
            case 3 -> {
                if (isCrawling) {
                    yield dispatcher::sendRightClawCrawling;
                }
                if (isInWater) {
                    yield dispatcher::sendRightTailBasic;
                }
                yield dispatcher::sendRightTail;
            }
            default -> {
                if (isCrawling) {
                    yield dispatcher::sendLeftClawCrawling;
                }
                if (isInWater) {
                    yield dispatcher::sendLeftClawBasic;
                }
                yield dispatcher::sendLeftClaw;
            }
        };
        GigCommonMethods.setAnimation(animKey);
    };
    public static final AnimationSelector<AlienEntity> NORMAL_ANIM_SELECTOR = entity -> {
        boolean basicCheck = entity.crawlingManager.isCrawling() || entity.isInWater();
        Runnable animKey = switch (entity.getRandom().nextInt(4)) {
            case 1 -> entity.animationDispatcher::sendRightClaw;
            case 2 -> {
                if (basicCheck) {
                    yield entity.animationDispatcher::sendRightClaw;
                }
                yield entity.animationDispatcher::sendLeftTail;
            }
            case 3 -> {
                if (basicCheck) {
                    yield entity.animationDispatcher::sendLeftClaw;
                }
                yield entity.animationDispatcher::sendRightTail;
            }
            default -> entity.animationDispatcher::sendLeftClaw;
        };
        GigCommonMethods.setAnimation(animKey);
    };
    public static final AnimationSelector<AlienEntity> STALKER_ANIM_SELECTOR = stalker -> {
        Runnable animKey = switch (stalker.getRandom().nextInt(4)) {
            case 1, 3 -> stalker.animationDispatcher::sendHeavy;
            default -> stalker.animationDispatcher::sendNormal;
        };
        GigCommonMethods.setAnimation(animKey);
    };
    public static final AnimationSelector<AlienEntity> STANDARD_ANIM_SELECTOR = templeBeastEntity -> {
        boolean basicCheck = templeBeastEntity.crawlingManager.isCrawling();
        Runnable animKey = switch (templeBeastEntity.getRandom().nextInt(4)) {
            case 1 -> templeBeastEntity.animationDispatcher::sendRightClaw;
            case 2 -> {
                if (basicCheck) {
                    yield templeBeastEntity.animationDispatcher::sendLeftClaw;
                }
                yield templeBeastEntity.animationDispatcher::sendLeftTail;
            }
            case 3 -> {
                if (basicCheck) {
                    yield templeBeastEntity.animationDispatcher::sendRightClaw;
                }
                yield templeBeastEntity.animationDispatcher::sendRightTail;
            }
            default -> templeBeastEntity.animationDispatcher::sendLeftClaw;
        };
        GigCommonMethods.setAnimation(animKey);
    };
    public static final AnimationSelector<AlienEntity> HAMMER_ANIM_SELECTOR = hammerpedeEntity -> hammerpedeEntity.animationDispatcher.sendAttack();
    public static final AnimationSelector<AlienEntity> RBUSTER_ANIM_SELECTOR = runnerbursterEntity -> runnerbursterEntity.animationDispatcher.sendChomp2();
    public static final AnimationSelector<AlienEntity> NBUSTER_ANIM_SELECTOR = neobursterEntity -> {
        Runnable animKey = switch (neobursterEntity.getRandom().nextInt(4)) {
            case 1 -> neobursterEntity.animationDispatcher::sendRightClaw;
            case 2 -> neobursterEntity.animationDispatcher::sendLeftTail;
            case 3 -> neobursterEntity.animationDispatcher::sendRightTail;
            default -> neobursterEntity.animationDispatcher::sendLeftClaw;
        };
        GigCommonMethods.setAnimation(animKey);
    };
    public static final AnimationSelector<AlienEntity> HUGGER_SELECTOR = facehuggerEntity -> {
        if (facehuggerEntity.getTarget() != null && !facehuggerEntity.isInWater()) {
            Vec3 vec3d2 = new Vec3(facehuggerEntity.getTarget().getX() - facehuggerEntity.getX(), 0.0, facehuggerEntity.getTarget().getZ() - facehuggerEntity.getZ());
            vec3d2 = vec3d2.normalize().scale(0.2).add(facehuggerEntity.getDeltaMovement().scale(0.2));
            facehuggerEntity.setDeltaMovement(vec3d2.x, facehuggerEntity.getTarget().getEyeHeight() > 0.8f ? 0.5 : 0.4, vec3d2.z);
            facehuggerEntity.setJumping(true);
        }
    };
    public static final AnimationSelector<AlienEntity> POPPER_SELECTOR = popperEntity -> {
        if (popperEntity.getTarget() != null) {
            Vec3 vec3d2 = new Vec3(popperEntity.getTarget().getX() - popperEntity.getX(), 0.0, popperEntity.getTarget().getZ() - popperEntity.getZ());
            vec3d2 = vec3d2.normalize().scale(0.1).add(popperEntity.getDeltaMovement().scale(0.1));
            popperEntity.setDeltaMovement(vec3d2.x, 0.5, vec3d2.z);
        }
    };
    public static final AnimationSelector<SpitterEntity> SPITTER_RANGE_SELECTOR = spitterEntity -> spitterEntity.animationDispatcher.sendAcidSpit();
}

