/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.helper.managers;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class CrawlingManager {
    private static final String CRAWLING_TAG_KEY = "crawling";
    private final PathfinderMob entity;
    private final EntityDataAccessor<Boolean> isCrawlingEDA;

    public CrawlingManager(PathfinderMob entity, EntityDataAccessor<Boolean> isCrawlingEDA) {
        this.entity = entity;
        this.isCrawlingEDA = isCrawlingEDA;
    }

    public void tick() {
        if (this.entity.level().isClientSide) {
            return;
        }
        if (this.entity.isUnderWater()) {
            return;
        }
        if (!this.entity.isUnderWater()) {
            this.tryToCrawl();
        }
    }

    public boolean isCrawling() {
        return (Boolean)this.entity.getEntityData().get(this.isCrawlingEDA);
    }

    private void tryToCrawl() {
        BlockPos blockPosition = this.entity.blockPosition();
        Level level = this.entity.level();
        PathNavigation navigation = this.entity.getNavigation();
        if (level.isClientSide) {
            return;
        }
        if (this.entity.isVehicle()) {
            return;
        }
        Path path = navigation.getPath();
        boolean isTight = this.isTightSpace(blockPosition);
        if (path != null && path.getNextNodeIndex() < path.getNodeCount()) {
            Node previousNode = path.getPreviousNode();
            isTight = isTight || previousNode != null && this.isTightSpace(previousNode.asBlockPos());
            Node nextNode = path.getNextNode();
            boolean bl = isTight = isTight || this.isTightSpace(nextNode.asBlockPos());
        }
        if (this.entity.tickCount % 20 == 0) {
            this.entity.getEntityData().set(this.isCrawlingEDA, (Object)isTight);
        }
        if (this.entity.tickCount % 10 == 0) {
            this.entity.refreshDimensions();
        }
    }

    private boolean isTightSpace(BlockPos blockPos) {
        BlockPos above;
        Level level = this.entity.level();
        BlockState aboveState = level.getBlockState(above = blockPos.above());
        return !aboveState.isAir() && aboveState.entityCanStandOn((BlockGetter)this.entity.level(), blockPos, (Entity)this.entity) || level.getBlockState(blockPos.below()).is(BlockTags.STAIRS);
    }

    public void load(CompoundTag compoundTag) {
        this.entity.getEntityData().set(this.isCrawlingEDA, (Object)compoundTag.getBoolean(CRAWLING_TAG_KEY));
    }

    public void save(CompoundTag compoundTag) {
        compoundTag.putBoolean(CRAWLING_TAG_KEY, ((Boolean)this.entity.getEntityData().get(this.isCrawlingEDA)).booleanValue());
    }
}

