/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.mixins.common.entity;

import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.item.SurgeryKitItem;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractHorse.class})
public abstract class AbstractHorseMixin
extends Animal {
    protected AbstractHorseMixin(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    void gigeresque$noBuckling(CallbackInfo callbackInfo) {
        if (this.getPassengers().stream().anyMatch(AlienEntity.class::isInstance)) {
            this.removeFreeWill();
            this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 400, 10));
        }
    }

    @Inject(method={"doPlayerRide"}, at={@At(value="HEAD")}, cancellable=true)
    void gigeresque$noRidingWithSurgeryKit(Player player, CallbackInfo ci) {
        if (player.getItemInHand(player.getUsedItemHand()).getItem() instanceof SurgeryKitItem) {
            ci.cancel();
        }
    }
}

