/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.common.network.packet;

import mod.azure.azurelib.common.api.client.helper.ClientUtils;
import mod.azure.azurelib.common.internal.common.network.AbstractPacket;
import mod.azure.azurelib.common.platform.services.AzureLibNetwork;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.animation.AzAnimatorAccessor;
import mod.azure.azurelib.rewrite.animation.dispatch.AzDispatchSide;
import mod.azure.azurelib.rewrite.animation.dispatch.command.AzCommand;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public record AzEntityDispatchCommandPacket(int entityId, AzCommand dispatchCommand) implements AbstractPacket
{
    public static final CustomPacketPayload.Type<AzEntityDispatchCommandPacket> TYPE = new CustomPacketPayload.Type(AzureLibNetwork.AZ_ENTITY_DISPATCH_COMMAND_SYNC_PACKET_ID);
    public static final StreamCodec<FriendlyByteBuf, AzEntityDispatchCommandPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, AzEntityDispatchCommandPacket::entityId, AzCommand.CODEC, AzEntityDispatchCommandPacket::dispatchCommand, AzEntityDispatchCommandPacket::new);

    @Override
    public void handle() {
        Entity entity = ClientUtils.getLevel().getEntity(this.entityId);
        if (entity == null) {
            return;
        }
        AzAnimator<Entity> animator = AzAnimatorAccessor.getOrNull(entity);
        if (animator != null) {
            this.dispatchCommand.actions().forEach(action -> action.handle(AzDispatchSide.SERVER, animator));
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

