/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererConfig;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererPipeline;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.armor.bone.AzArmorBoneContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AzArmorModel<E extends LivingEntity>
extends HumanoidModel<E> {
    private final AzArmorRendererPipeline rendererPipeline;

    public AzArmorModel(AzArmorRendererPipeline rendererPipeline) {
        super(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.PLAYER_INNER_ARMOR));
        this.rendererPipeline = rendererPipeline;
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @Nullable VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        boolean shouldOutline;
        Minecraft mc = Minecraft.getInstance();
        AzArmorRendererPipelineContext context = this.rendererPipeline.context();
        Entity currentEntity = context.currentEntity();
        ItemStack currentStack = context.currentStack();
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().levelRenderer.renderBuffers.bufferSource();
        boolean bl = shouldOutline = Minecraft.getInstance().levelRenderer.shouldShowEntityOutlines() && mc.shouldEntityAppearGlowing(currentEntity);
        if (shouldOutline) {
            bufferSource = Minecraft.getInstance().levelRenderer.renderBuffers.outlineBufferSource();
        }
        AzArmorRendererConfig config = this.rendererPipeline.config();
        ItemStack animatable = (ItemStack)context.animatable();
        float partialTick = mc.getTimer().getGameTimeDeltaTicks();
        ResourceLocation textureLocation = config.textureLocation(animatable);
        RenderType renderType = context.getDefaultRenderType(animatable, textureLocation, (MultiBufferSource)bufferSource, partialTick);
        buffer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)bufferSource, (RenderType)renderType, (boolean)currentStack.hasFoil());
        AzBakedModel model = this.rendererPipeline.renderer().provider().provideBakedModel(animatable);
        this.rendererPipeline.render(poseStack, model, animatable, (MultiBufferSource)bufferSource, null, buffer, 0.0f, partialTick, packedLight);
    }

    public void applyBaseModel(HumanoidModel<?> baseModel) {
        this.young = baseModel.young;
        this.crouching = baseModel.crouching;
        this.riding = baseModel.riding;
        this.rightArmPose = baseModel.rightArmPose;
        this.leftArmPose = baseModel.leftArmPose;
    }

    public void setAllVisible(boolean pVisible) {
        super.setAllVisible(pVisible);
        AzArmorBoneContext boneContext = this.rendererPipeline.context().boneContext();
        boneContext.setAllVisible(pVisible);
    }
}

