/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.util;

import java.util.Objects;
import java.util.function.BiPredicate;
import mod.azure.azurelib.sblforked.util.RandomUtil;
import mods.cybercat.gigeresque.common.block.GigBlocks;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.entity.GigEntities;
import mods.cybercat.gigeresque.common.entity.impl.classic.ChestbursterEntity;
import mods.cybercat.gigeresque.common.entity.impl.classic.FacehuggerEntity;
import mods.cybercat.gigeresque.common.entity.impl.runner.RunnerbursterEntity;
import mods.cybercat.gigeresque.common.status.effect.GigStatusEffects;
import mods.cybercat.gigeresque.common.tags.GigTags;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1420;
import net.minecraft.class_1421;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3483;
import org.jetbrains.annotations.NotNull;

public record GigEntityUtils() {
    public static final BiPredicate<AlienEntity, class_1309> TARGET_PREDICATE = (xenomorph, potentialTarget) -> {
        if (xenomorph == null || potentialTarget == null) {
            return false;
        }
        if (xenomorph.method_37908() != potentialTarget.method_37908()) {
            return false;
        }
        if (!class_1301.field_6156.test(potentialTarget)) {
            return false;
        }
        if (potentialTarget.method_6059(GigStatusEffects.IMPREGNATION)) {
            return false;
        }
        if (xenomorph.method_5782()) {
            return false;
        }
        if (xenomorph.method_5722((class_1297)potentialTarget)) {
            return false;
        }
        if (!potentialTarget.method_5864().method_20210(GigTags.ALL_HOSTS)) {
            return false;
        }
        if (potentialTarget.method_5864().method_20210(class_3483.field_46232)) {
            return false;
        }
        if (potentialTarget.method_55667().method_26204() == GigBlocks.NEST_RESIN_WEB_CROSS) {
            return false;
        }
        if (potentialTarget.method_5864() == class_1299.field_6131 || potentialTarget.method_5864() == class_1299.field_38095 || potentialTarget instanceof class_1420) {
            return false;
        }
        if (GigEntityUtils.isFacehuggerAttached((class_1297)potentialTarget)) {
            return false;
        }
        if (potentialTarget.method_5655() || potentialTarget.method_29504()) {
            return false;
        }
        if (!xenomorph.method_37908().method_8621().method_11966(potentialTarget.method_5829())) {
            return false;
        }
        if (potentialTarget.method_5854() != null) {
            if (potentialTarget.method_5854().method_24204().anyMatch(AlienEntity.class::isInstance)) {
                return false;
            }
        }
        if (potentialTarget.method_5864().method_20210(GigTags.GIG_ALIENS)) {
            return false;
        }
        if (xenomorph.method_6510()) {
            return false;
        }
        return xenomorph.method_37908().method_8320(xenomorph.method_24515().method_10074()).method_26234((class_1922)xenomorph.method_37908(), xenomorph.method_24515().method_10074());
    };

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isFacehuggerAttached(class_1297 entity) {
        if (entity == null) return false;
        if (!entity.method_5685().stream().anyMatch(FacehuggerEntity.class::isInstance)) return false;
        return true;
    }

    public static boolean isTargetHostable(class_1297 target) {
        return target.method_5864().method_20210(GigTags.CLASSIC_HOSTS) || target.method_5864().method_20210(GigTags.AQUATIC_HOSTS) || target.method_5864().method_20210(GigTags.RUNNER_HOSTS);
    }

    public static boolean isTargetGooable(class_1297 target) {
        return GigEntityUtils.isTargetSmallMutantHost(target) || GigEntityUtils.isTargetLargeMutantHost(target);
    }

    public static boolean isTargetSmallMutantHost(class_1297 target) {
        return target.method_5864().method_20210(GigTags.MUTANT_SMALL_HOSTS);
    }

    public static boolean isTargetLargeMutantHost(class_1297 target) {
        return target.method_5864().method_20210(GigTags.MUTANT_LARGE_HOSTS);
    }

    public static boolean isTargetDNAImmune(class_1297 target) {
        return target.method_5864().method_20210(GigTags.DNAIMMUNE);
    }

    public static boolean convertToNeo(class_1309 target) {
        return target.method_5864().method_20210(GigTags.NEOHOST) && target.method_6059(GigStatusEffects.SPORE);
    }

    public static boolean faceHuggerTest(class_1309 target) {
        if (target.method_5864().method_20210(GigTags.GIG_ALIENS)) {
            return false;
        }
        if (target instanceof class_1421) {
            return false;
        }
        if (GigEntityUtils.passengerCheck(target)) {
            return false;
        }
        if (target.method_6059(GigStatusEffects.IMPREGNATION)) {
            return false;
        }
        if (target.method_6059(GigStatusEffects.EGGMORPHING)) {
            return false;
        }
        if (GigEntityUtils.isFacehuggerAttached((class_1297)target)) {
            return false;
        }
        if (target.method_5864().method_20210(GigTags.FACEHUGGER_BLACKLIST)) {
            return false;
        }
        return GigEntityUtils.isTargetHostable((class_1297)target);
    }

    public static boolean isValidTarget(class_1309 target) {
        return !target.method_5864().method_20210(GigTags.GIG_ALIENS) && !target.method_5864().method_20210(GigTags.XENO_ATTACK_BLACKLIST) && !GigEntityUtils.passengerCheck(target) && !target.method_6059(GigStatusEffects.IMPREGNATION) && !target.method_6059(GigStatusEffects.EGGMORPHING) && !GigEntityUtils.isFacehuggerAttached((class_1297)target) && target.method_5805() && !target.method_5655() && target.method_6102() && class_1301.field_6156.test(target);
    }

    public static boolean removeFaceHuggerTarget(class_1309 target) {
        if (target.method_5864().method_20210(GigTags.GIG_ALIENS)) {
            return false;
        }
        if (GigEntityUtils.passengerCheck(target)) {
            return false;
        }
        if (target.method_6059(GigStatusEffects.IMPREGNATION)) {
            return false;
        }
        if (target.method_6059(GigStatusEffects.EGGMORPHING)) {
            return false;
        }
        if (GigEntityUtils.isFacehuggerAttached((class_1297)target)) {
            return false;
        }
        if (target.method_6109()) {
            return false;
        }
        if (target.method_5864().method_20210(GigTags.FACEHUGGER_BLACKLIST)) {
            return false;
        }
        return GigEntityUtils.isTargetHostable((class_1297)target) && target.method_5805();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean passengerCheck(class_1309 target) {
        if (target.method_5854() == null) return false;
        if (!target.method_5854().method_24204().anyMatch(AlienEntity.class::isInstance)) return false;
        return true;
    }

    public static void spawnMutant(class_1309 entity) {
        class_1309 summon;
        int randomPhase2 = entity.method_59922().method_43051(0, 2);
        if (GigEntityUtils.isTargetSmallMutantHost((class_1297)entity)) {
            class_1309 summon2 = randomPhase2 == 1 ? (class_1309)GigEntities.MUTANT_HAMMERPEDE.get().method_5883(entity.method_37908()) : (class_1309)GigEntities.MUTANT_POPPER.get().method_5883(entity.method_37908());
            if (summon2 != null) {
                GigEntityUtils.moveToAndSpawn(entity, summon2);
            }
        } else if (GigEntityUtils.isTargetLargeMutantHost((class_1297)entity) && (summon = (class_1309)GigEntities.MUTANT_STALKER.get().method_5883(entity.method_37908())) != null) {
            GigEntityUtils.moveToAndSpawn(entity, summon);
        }
    }

    public static class_1309 spawnBurster(class_1309 entity) {
        ChestbursterEntity defaultBurster = (ChestbursterEntity)GigEntities.CHESTBURSTER.get().method_5883(entity.method_37908());
        if (!entity.method_6059(GigStatusEffects.SPORE) && !entity.method_6059(GigStatusEffects.DNA)) {
            if (entity.method_5864().method_20210(GigTags.RUNNER_HOSTS)) {
                RunnerbursterEntity runnerBurster = (RunnerbursterEntity)GigEntities.RUNNERBURSTER.get().method_5883(entity.method_37908());
                if (runnerBurster != null) {
                    runnerBurster.setHostId("runner");
                    return runnerBurster;
                }
            } else if (entity.method_5864().method_20210(GigTags.AQUATIC_HOSTS)) {
                return (class_1309)GigEntities.AQUATIC_CHESTBURSTER.get().method_5883(entity.method_37908());
            }
        }
        if (GigEntityUtils.convertToNeo(entity)) {
            return (class_1309)GigEntities.NEOBURSTER.get().method_5883(entity.method_37908());
        }
        if (entity.method_6059(GigStatusEffects.DNA)) {
            return (class_1309)GigEntities.SPITTER.get().method_5883(entity.method_37908());
        }
        if (entity.method_5864().method_20210(GigTags.HWG_ENTITIES)) {
            return (class_1309)GigEntities.HELL_BURSTER.get().method_5883(entity.method_37908());
        }
        return defaultBurster;
    }

    private static void moveToAndSpawn(@NotNull class_1309 entity, class_1309 summon) {
        if (entity instanceof class_1309) {
            class_1309 livingEntity = entity;
            for (class_1293 effect : livingEntity.method_6026()) {
                summon.method_6092(new class_1293(effect));
            }
        }
        summon.method_5814(entity.method_23317(), entity.method_23318(), entity.method_23321());
        GigEntityUtils.spawnEffects(entity.method_37908(), entity);
        entity.method_37908().method_8649((class_1297)summon);
    }

    private static void spawnEffects(class_1937 world, class_1309 entity) {
        if (!world.method_8608()) {
            for (int i = 0; i < 2; ++i) {
                ((class_3218)world).method_14199((class_2394)class_2398.field_11203, entity.method_23317() + 0.5, entity.method_23318(), entity.method_23321() + 0.5, 1, entity.method_59922().method_43059() * 0.02, entity.method_59922().method_43059() * 0.02, entity.method_59922().method_43059() * 0.02, (double)0.15f);
            }
        }
    }

    public static void placeInNest(@NotNull class_3218 level, AlienEntity entity, class_1297 passenger) {
        class_2338 test = RandomUtil.getRandomPositionWithinRange((class_2338)entity.method_24515(), (int)3, (int)1, (int)3, (boolean)false, (class_1937)entity.method_37908());
        for (class_2338 testPos : class_2338.method_10097((class_2338)test, (class_2338)test.method_10086(2))) {
            if (!level.method_8320(test).method_26215() || !level.method_8320(test.method_10074()).method_51367() || !level.method_18467(class_1309.class, new class_238(test)).stream().noneMatch(Objects::isNull) || passenger == null) continue;
            passenger.method_33574(class_243.method_24955((class_2382)testPos));
            passenger.method_29239();
            passenger.method_5772();
            entity.animationDispatcher.sendLeftClaw();
            level.method_8501(testPos, GigBlocks.NEST_RESIN_WEB_CROSS.get().method_9564());
            level.method_8501(testPos.method_10084(), GigBlocks.NEST_RESIN_WEB_CROSS.get().method_9564());
            entity.method_5772();
            entity.method_29239();
        }
    }

    public static boolean inResinEnoughToBeEggmorphed(@NotNull class_1297 entity) {
        class_2680 stateAtEntityPos = entity.method_37908().method_8320(entity.method_24515());
        return stateAtEntityPos.method_27852(GigBlocks.NEST_RESIN_WEB_CROSS.get());
    }
}

