/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.mixins.common.entity;

import java.util.Objects;
import mod.azure.azurelib.common.api.client.helper.ClientUtils;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.entity.impl.classic.FacehuggerEntity;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309 {
    @Unique
    private long lastUpdateTime = 0L;

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"wantsToStopRiding"}, at={@At(value="RETURN")}, cancellable=true)
    protected void gigeresque$shouldDismount(CallbackInfoReturnable<Boolean> callbackInfo) {
        if (this.method_5854() instanceof AlienEntity) {
            callbackInfo.setReturnValue((Object)false);
        }
    }

    @Inject(method={"interactOn"}, at={@At(value="HEAD")}, cancellable=true)
    protected void gigeresque$stopPlayerUsing(class_1297 entity, class_1268 hand, CallbackInfoReturnable<class_1269> callbackInfo) {
        if (this.method_5685().stream().anyMatch(FacehuggerEntity.class::isInstance)) {
            callbackInfo.setReturnValue((Object)class_1269.field_5814);
        }
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")}, cancellable=true)
    protected void gigeresque$noAttacking(class_1297 target, CallbackInfo callbackInfo) {
        if (this.method_5685().stream().anyMatch(FacehuggerEntity.class::isInstance)) {
            this.method_6021();
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")}, cancellable=true)
    public void gigeresque$tickMovement(CallbackInfo callbackInfo) {
        if (this.method_5685().stream().anyMatch(FacehuggerEntity.class::isInstance)) {
            callbackInfo.cancel();
        }
    }

    @Unique
    private String gigeresque$generateTimerMessage() {
        float ticksAttached = ((FacehuggerEntity)Objects.requireNonNull(this.method_31483())).ticksAttachedToHost;
        float tickTimer = CommonMod.config.getFacehuggerAttachTickTimer();
        float secondsAttached = CommonMod.config.facehuggerConfigs.enableFacehuggerTimerTicks ? ticksAttached : (float)Math.round(ticksAttached / 20.0f);
        float secondsTimer = CommonMod.config.facehuggerConfigs.enableFacehuggerTimerTicks ? tickTimer : (float)Math.round(tickTimer / 20.0f);
        return "Attachment Timer: " + secondsAttached + " seconds / " + secondsTimer + " seconds";
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void gigeresque$tellPlayer(CallbackInfo ci) {
        if (this.method_37908().method_8608()) {
            long currentTime;
            class_1657 player;
            if (this.method_5685().stream().anyMatch(FacehuggerEntity.class::isInstance) && CommonMod.config.facehuggerConfigs.enableFacehuggerAttachmentTimer && (player = ClientUtils.getClientPlayer()) != null && (currentTime = System.currentTimeMillis()) - this.lastUpdateTime >= 1000L) {
                this.lastUpdateTime = currentTime;
                String timerMessage = this.gigeresque$generateTimerMessage();
                player.method_7353((class_2561)class_2561.method_43470((String)timerMessage), true);
            }
        }
    }
}

