/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd;

import com.bdc.bdd.api.molang.BDDMoLangUtils;
import com.bdc.bdd.registry.BlockRegistry;
import com.bdc.bdd.registry.EntityRegistry;
import com.bdc.bdd.registry.ItemRegistry;
import com.bdc.bdd.registry.MemoryRegistry;
import com.bdc.bdd.registry.NetworkRegistry;
import com.bdc.bdd.registry.TabRegistry;
import com.bdc.bdd.registry.TagRegistry;
import com.bdc.bdd.registry.builders.blocks.BddBlockBuilder;
import com.bdc.bdd.registry.builders.entity.BddEntityBuilder;
import com.bdc.bdd.registry.builders.entity.BddEntityTagBuilder;
import com.bdc.bdd.registry.builders.items.BddItemBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import software.bluelib.api.net.PacketProvider;

public class BddCommon {
    public static void init() {
        BddCommon.doRegistrations();
        BddCommon.doServerRegistration();
    }

    public static NetworkRegistry getRegistry() {
        return new NetworkRegistry();
    }

    public static void doServerRegistration() {
        software.bluelib.api.net.NetworkRegistry.registerC2SPacketProvider((PacketProvider.C2SPacketProvider)BddCommon.getRegistry());
    }

    public static void doClientRegistration() {
        software.bluelib.api.net.NetworkRegistry.registerS2CPacketProvider((PacketProvider.S2CPacketProvider)BddCommon.getRegistry());
    }

    public static void doRegistrations() {
        BDDMoLangUtils.init();
        MemoryRegistry.init();
        TabRegistry.init();
        EntityRegistry.init();
        BlockRegistry.init();
        ItemRegistry.init();
        TagRegistry.init();
    }

    public static void doDatagen() {
        BddItemBuilder.doItemModelGen();
        BddBlockBuilder.doBlockModelGen();
        BddEntityBuilder.doSpawnEggDatagen();
        BddEntityTagBuilder.doTagJsonGen();
    }

    @ApiStatus.Internal
    public static class Translation {
        public static Component translate(String pString) {
            return Component.translatable((String)("bdd." + pString));
        }

        public static Component translate(String pString, Object ... pArgs) {
            return Component.translatable((String)("bdd." + pString), (Object[])pArgs);
        }

        public static Component command(String pString) {
            return Translation.translate("command." + pString);
        }

        public static Component command(String pString, Object ... pArgs) {
            return Translation.translate("command." + pString, pArgs);
        }

        public static Component gui(String pString) {
            return Translation.translate("gui." + pString);
        }

        public static Component gui(String pString, Object ... pArgs) {
            return Translation.translate("gui." + pString, pArgs);
        }
    }

    @ApiStatus.Internal
    public static class Resource {
        public static ResourceLocation resource(String pPath) {
            return ResourceLocation.fromNamespaceAndPath((String)"bdd", (String)pPath);
        }

        public static ResourceLocation guiTexture(String pPath) {
            return Resource.resource("textures/gui/" + pPath + ".png");
        }

        public static ResourceLocation guiIcon(String pPath) {
            return Resource.guiTexture("icons/" + pPath);
        }

        public static ResourceLocation model(boolean pBaby, String pPath) {
            return Resource.resource("model/dragons/" + (pBaby ? "baby/" : "") + pPath + ".geo.json");
        }

        public static ResourceLocation animation(boolean pBaby, String pPath) {
            return Resource.resource("animation/dragons/" + (pBaby ? "baby/" : "") + pPath + ".animation.json");
        }

        protected static class Paths {
            private static final String TEXTURE_PATH = "textures/";
            private static final String GUI_PATH = "gui/";
            private static final String ICON_PATH = "icons/";
            private static final String MODEL_PATH = "model/";
            private static final String ANIMATION_PATH = "animation/";
            private static final String DRAGON_PATH = "dragons/";
            private static final String BABY_PATH = "baby/";
            private static final String IMAGE_SUFFIX = ".png";
            private static final String MODEL_SUFFIX = ".geo.json";
            private static final String ANIMATION_SUFFIX = ".animation.json";

            protected Paths() {
            }
        }
    }
}

