/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd;

import com.bdc.bdd.BddCommon;
import com.bdc.bdd.BddConstants;
import com.bdc.bdd.client.BddClient;
import com.bdc.bdd.config.ConfigHolder;
import com.bdc.bdd.platform.NeoRegistryHelper;
import com.bdc.bdd.registry.BddContainers;
import com.bdc.bdd.registry.EntityRegistry;
import com.bdc.bdd.registry.VariantProvider;
import com.bdc.bdd.registry.builders.entity.BddEntityBuilder;
import java.util.function.Supplier;
import java.util.logging.Level;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import org.spongepowered.asm.launch.MixinBootstrap;
import software.bluelib.api.entity.variant.IVariantProvider;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.config.LoggerConfig;
import software.bluelib.event.ReloadHandler;

@Mod(value="bdd")
public class BddNeo {
    public BddNeo(IEventBus pEventBus, ModContainer pModContainer) {
        BddCommon.init();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            BddClient.init();
        }
        ReloadHandler.registerProvider((IVariantProvider)new VariantProvider());
        MixinBootstrap.init();
        NeoRegistryHelper.register(pEventBus);
        pModContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigHolder.CLIENT_SPEC);
        pModContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigHolder.SERVER_SPEC);
        BddContainers.register(pEventBus);
        pModContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(mc, parent) -> new ConfigurationScreen(pModContainer, parent)));
        pEventBus.addListener(GatherDataEvent.class, this::onGatherData);
        pEventBus.addListener(RegisterSpawnPlacementsEvent.class, this::registerSpawnPlacements);
        pEventBus.addListener(BuildCreativeModeTabContentsEvent.class, this::buildCreativeTabContents);
        LoggerConfig.isLoggingEnabled = BddConstants.enableLogging;
        LoggerConfig.isBlueLibLoggingEnabled = false;
    }

    private void onGatherData(GatherDataEvent event) {
        BddCommon.doDatagen();
    }

    private void buildCreativeTabContents(BuildCreativeModeTabContentsEvent event) {
        CreativeModeTab tab = event.getTab();
        for (Supplier<Item> spawnEgg : BddEntityBuilder.getSpawnEggsForTab(tab)) {
            Item item = spawnEgg.get();
            BaseLogger.log((Level)BaseLogLevel.SUCCESS, (String)("Adding spawn egg to tab: " + String.valueOf(item)));
            event.accept((ItemLike)item);
        }
    }

    public void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        event.register(EntityRegistry.NIGHTFURY.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register(EntityRegistry.GRONCKLE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register(EntityRegistry.DEADLY_NADDER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register(EntityRegistry.HIDEOUS_ZIPPLEBACK.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register(EntityRegistry.MONSTROUS_NIGHTMARE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register(EntityRegistry.TERRIBLE_TERROR.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register(EntityRegistry.SPEED_STINGER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
    }
}

