/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.block;

import com.bdc.bdd.api.entity.core_classes.BddBaseDragon;
import com.bdc.bdd.api.util.interfaces.ILargeEgg;
import com.bdc.bdd.api.util.interfaces.ISmallEgg;
import com.bdc.bdd.blocks.IDragonProof;
import com.bdc.bdd.util.BddUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDragonEgg
extends Block
implements IDragonProof,
SimpleWaterloggedBlock {
    public static final int MAX_HATCH_LEVEL = 3;
    private static final VoxelShape SMALL_EGG_AABB = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0);
    private static final VoxelShape MEDIUM_EGG_AABB = Block.box((double)2.5, (double)0.0, (double)2.5, (double)13.5, (double)12.0, (double)13.5);
    private static final VoxelShape LARGE_EGG_AABB = Block.box((double)0.5, (double)1.0, (double)1.0, (double)15.5, (double)20.0, (double)15.0);
    public static final IntegerProperty HATCH = IntegerProperty.create((String)"hatch", (int)0, (int)3);
    private static final int TICKS_PER_STAGE = BddUtil.mcDaysToMinutes(1) / 4;
    public static final BooleanProperty HATCHED = BooleanProperty.create((String)"hatched");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public BaseDragonEgg(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HATCH, (Comparable)Integer.valueOf(0))).setValue((Property)HATCHED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        boolean isWaterlogged = pContext.getLevel().getFluidState(pContext.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)HATCH, (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
    }

    public void tick(BlockState pState, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        if (((Boolean)pState.getValue((Property)HATCHED)).booleanValue() || !this.isWarmEnvironment((Level)pLevel, pPos)) {
            return;
        }
        int hatchLevel = (Integer)pState.getValue((Property)HATCH);
        if (hatchLevel < 3) {
            pLevel.playSound(null, pPos, SoundEvents.TURTLE_EGG_CRACK, SoundSource.BLOCKS, 0.7f, 0.9f + pRandom.nextFloat() * 0.2f);
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)HATCH, (Comparable)Integer.valueOf(hatchLevel + 1)), 3);
            pLevel.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pPos, GameEvent.Context.of((BlockState)pState));
            pLevel.scheduleTick(pPos, (Block)this, TICKS_PER_STAGE);
        } else {
            pLevel.playSound(null, pPos, SoundEvents.TURTLE_EGG_HATCH, SoundSource.BLOCKS, 0.7f, 0.9f + pRandom.nextFloat() * 0.2f);
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)HATCHED, (Comparable)Boolean.valueOf(true)), 3);
            pLevel.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pPos, GameEvent.Context.of((BlockState)pState));
            pLevel.levelEvent(2001, pPos, Block.getId((BlockState)pState));
            BddBaseDragon dragon = this.getHatchedEntity((Level)pLevel);
            if (dragon != null) {
                dragon.finalizeSpawn((ServerLevelAccessor)pLevel, pLevel.getCurrentDifficultyAt(pPos), MobSpawnType.NATURAL, null);
                dragon.setAgeInDays(0);
                dragon.moveTo((double)pPos.getX() + 0.3, pPos.getY(), (double)pPos.getZ() + 0.3, 0.0f, 0.0f);
                pLevel.addFreshEntity((Entity)dragon);
            }
        }
    }

    public abstract BddBaseDragon getHatchedEntity(Level var1);

    public void onPlace(@NotNull BlockState pState, Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pOldState, boolean pIsMoving) {
        if (!pLevel.isClientSide && this.isWarmEnvironment(pLevel, pPos)) {
            pLevel.levelEvent(2012, pPos, 15);
            pLevel.scheduleTick(pPos, (Block)this, TICKS_PER_STAGE);
        }
    }

    private boolean isWarmEnvironment(Level pLevel, BlockPos pPos) {
        for (BlockPos nearbyPos : BlockPos.betweenClosed((BlockPos)pPos.offset(-1, -1, -1), (BlockPos)pPos.offset(1, 1, 1))) {
            BlockState nearbyState = pLevel.getBlockState(nearbyPos);
            if (!nearbyState.is(Blocks.LAVA) && !nearbyState.is(Blocks.FIRE) && !nearbyState.is(Blocks.MAGMA_BLOCK) && !nearbyState.is(Blocks.TORCH)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<ItemStack> getDrops(BlockState pState, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootParams.Builder pParams) {
        return (Boolean)pState.getValue((Property)HATCHED) != false ? List.of() : super.getDrops(pState, pParams);
    }

    public void playerDestroy(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull BlockPos pPos, @NotNull BlockState pState, @Nullable BlockEntity pBlockEntity, @NotNull ItemStack pStack) {
        super.playerDestroy(pLevel, pPlayer, pPos, pState, pBlockEntity, pStack);
        pLevel.playSound(null, pPos, SoundEvents.TURTLE_EGG_BREAK, SoundSource.BLOCKS, 0.7f, 0.9f + pLevel.random.nextFloat() * 0.2f);
        pLevel.destroyBlock(pPos, false);
        pLevel.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pPos, GameEvent.Context.of((BlockState)pState));
        pLevel.levelEvent(2001, pPos, Block.getId((BlockState)pState));
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        if (this instanceof ISmallEgg) {
            return SMALL_EGG_AABB;
        }
        if (this instanceof ILargeEgg) {
            return LARGE_EGG_AABB;
        }
        return MEDIUM_EGG_AABB;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{HATCH, HATCHED, WATERLOGGED});
    }

    @NotNull
    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    @NotNull
    public BlockState updateShape(BlockState pState, @NotNull Direction pFacing, @NotNull BlockState pFacingState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pFacingPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public boolean propagatesSkylightDown(BlockState pState, @NotNull BlockGetter pReader, @NotNull BlockPos pPos) {
        return pState.getFluidState().isEmpty();
    }
}

