/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.ai.behaviors;

import com.bdc.bdd.api.ai_stuffs.DragonBehavior;
import com.bdc.bdd.api.entity.BddDragon;
import java.util.logging.Level;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;

public class AggressionBehavior
implements DragonBehavior<BddDragon> {
    private static final double AGGRESSION_RADIUS = 3.0;
    private static final double ATTACK_DISTANCE = 2.5;
    private static final int BITE_WINDUP_TICKS = 6;
    private static final int BITE_RECOVERY_TICKS = 8;
    private static final int ATTACK_COOLDOWN_TICKS = 10;
    private LivingEntity targetPlayer = null;
    private int biteTicks = -1;
    private int attackCooldown = 0;

    @Override
    public boolean canStart(BddDragon dragon, net.minecraft.world.level.Level level) {
        if (level.isClientSide) {
            return false;
        }
        AABB searchBox = dragon.getBoundingBox().inflate(3.0);
        this.targetPlayer = level.getEntitiesOfClass(Player.class, searchBox, p -> !p.isCreative() && !p.isSpectator()).stream().findFirst().orElse(null);
        return this.targetPlayer != null && dragon.canMove();
    }

    @Override
    public void start(BddDragon dragon, net.minecraft.world.level.Level level) {
        boolean inRange;
        if (level.isClientSide) {
            return;
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.targetPlayer == null || !this.targetPlayer.isAlive()) {
            this.resetState(dragon);
            return;
        }
        dragon.setTarget(this.targetPlayer);
        double distSqr = dragon.distanceToSqr((Entity)this.targetPlayer);
        boolean bl = inRange = distSqr <= 6.25;
        if (inRange) {
            dragon.getNavigation().stop();
            dragon.setDeltaMovement(Vec3.ZERO);
            dragon.setSprinting(false);
            dragon.getLookControl().setLookAt(this.targetPlayer.getX(), this.targetPlayer.getEyeY(), this.targetPlayer.getZ());
            if (this.biteTicks < 0 && this.attackCooldown == 0) {
                this.biteTicks = 0;
                dragon.setBiting(true);
            }
            if (this.biteTicks >= 0) {
                if (this.biteTicks == 6) {
                    this.applyBiteDamage(dragon, this.targetPlayer, level);
                }
                ++this.biteTicks;
                if (this.biteTicks >= 14) {
                    this.biteTicks = -1;
                    dragon.setBiting(false);
                    this.attackCooldown = 10;
                }
            }
        } else {
            if (this.biteTicks >= 0) {
                this.biteTicks = -1;
                dragon.setBiting(false);
            }
            Vec3 playerPos = this.targetPlayer.position().add(0.0, 0.25, 0.0);
            double speed = dragon.isAbleToFly() && dragon.getAltitude() > 5.0 ? (double)dragon.getFlyingSpeed() : (double)dragon.getSpeed() * 8.0;
            dragon.setSprinting(true);
            dragon.setFlying(dragon.isAbleToFly() && dragon.getAltitude() > 5.0);
            dragon.getNavigation().moveTo(playerPos.x, playerPos.y, playerPos.z, speed);
        }
    }

    @Override
    public void stop(BddDragon dragon, net.minecraft.world.level.Level level) {
        this.resetState(dragon);
    }

    private void resetState(BddDragon dragon) {
        dragon.setTarget(null);
        dragon.getNavigation().stop();
        dragon.setDeltaMovement(Vec3.ZERO);
        dragon.setBiting(false);
        dragon.setFlying(false);
        dragon.setSprinting(false);
        this.targetPlayer = null;
        this.biteTicks = -1;
    }

    private void applyBiteDamage(BddDragon dragon, LivingEntity target, net.minecraft.world.level.Level level) {
        if (level.isClientSide) {
            return;
        }
        if (target == null || !target.isAlive()) {
            return;
        }
        if (dragon.distanceToSqr((Entity)target) > 9.0) {
            return;
        }
        float damage = dragon.getPower();
        boolean hit = target.hurt(level.damageSources().mobAttack((LivingEntity)dragon), damage);
        if (hit) {
            BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Bite damage (vanilla) applied to " + target.getName().getString() + " dmg=" + damage + " hpAfter=" + target.getHealth()));
            return;
        }
        boolean generic = target.hurt(level.damageSources().generic(), damage);
        if (generic) {
            BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Bite damage (generic) applied to " + target.getName().getString() + " dmg=" + damage + " hpAfter=" + target.getHealth()));
            return;
        }
        float remaining = damage;
        float abs = target.getAbsorptionAmount();
        if (abs > 0.0f) {
            float use = Math.min(abs, remaining);
            target.setAbsorptionAmount(abs - use);
            remaining -= use;
        }
        if (remaining > 0.0f) {
            float before = target.getHealth();
            float after = Math.max(0.0f, before - remaining);
            target.setHealth(after);
            BaseLogger.log((Level)BaseLogLevel.WARNING, (String)("Bite damage (brute) applied to " + target.getName().getString() + " dmg=" + remaining + " hpBefore=" + before + " hpAfter=" + after));
        } else {
            BaseLogger.log((Level)BaseLogLevel.WARNING, (String)("Bite damage (brute) fully absorbed by " + target.getName().getString()));
        }
    }
}

