/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.ai.behaviors;

import com.bdc.bdd.api.ai_stuffs.DragonBehavior;
import com.bdc.bdd.api.entity.BddDragon;
import com.bdc.bdd.util.BddUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FollowingBehavior
implements DragonBehavior<BddDragon> {
    protected final double ASCEND_START = 2.0;
    protected final double ASCEND_STOP = 1.0;
    protected final double DESCEND_START = 2.0;
    protected final double DESCEND_STOP = 1.0;
    protected final int VSTATE_MIN_HOLD = BddUtil.secondsToTicks(1) / 2;
    protected final double FOLLOW_RADIUS_SQR = 100.0;
    protected final double HOVER_MIN_DISTANCE_SQR = 4.0;
    protected final double HOVER_START_BELOW = 0.5;
    protected final double HOVER_STOP_BELOW = 1.5;
    protected static final double FOLLOW_STOP_DISTANCE = 5.0;
    protected static final double FOLLOW_START_DISTANCE = 5.5;
    protected static final double FOLLOW_STOP_SQR = 25.0;
    protected static final double FOLLOW_START_SQR = 30.25;
    protected double lastPlayerY = 0.0;
    private VState vState = VState.NEUTRAL;
    protected int vHoldTicks = 0;
    protected boolean followActive = true;

    @Override
    public boolean canStart(BddDragon dragon, Level level) {
        return dragon.isDragonFollowing() && dragon.getOwner() instanceof Player && !dragon.getOwner().isSpectator() && dragon.canMove();
    }

    @Override
    public void start(BddDragon dragon, Level level) {
        boolean canHover;
        boolean withinHoverRange;
        Player owner = (Player)dragon.getOwner();
        if (owner == null) {
            dragon.getNavigation().stop();
            return;
        }
        double distanceToOwnerSqr = dragon.distanceToSqr((Entity)owner);
        double ownerY = owner.getY();
        double dragonY = dragon.getY();
        double verticalDistance = Math.abs(dragonY - ownerY);
        boolean bl = withinHoverRange = distanceToOwnerSqr <= 100.0;
        if (this.followActive) {
            if (distanceToOwnerSqr <= 25.0) {
                this.followActive = false;
            }
        } else if (distanceToOwnerSqr >= 30.25) {
            this.followActive = true;
        }
        if (verticalDistance > 10.0 && dragon.isAbleToFly()) {
            if (!dragon.isFlying()) {
                dragon.jumpFromGround();
                dragon.setFlying(true);
                dragon.ticksSinceLanding = 0;
                dragon.ticksSinceFlying = 0;
            }
            dragon.setHovering(false);
            dragon.getNavigation().moveTo(owner.getX(), owner.getY(), owner.getZ(), (double)dragon.getFlyingSpeed());
            dragon.targetPosition = new BlockPos((int)owner.getX(), (int)owner.getY(), (int)owner.getZ());
            this.lastPlayerY = ownerY;
            return;
        }
        boolean currentlyHovering = dragon.isHovering();
        double yDeltaRelative = dragonY - ownerY;
        boolean bl2 = canHover = dragon.isFlying() && withinHoverRange && distanceToOwnerSqr > 4.0;
        if (!this.followActive) {
            if (currentlyHovering) {
                boolean leaveHover;
                boolean bl3 = leaveHover = !canHover || yDeltaRelative < -1.5;
                if (leaveHover) {
                    dragon.setHovering(false);
                } else {
                    dragon.setGoingUp(false);
                    dragon.setDiving(false);
                    dragon.getNavigation().stop();
                    dragon.setDeltaMovement(Vec3.ZERO);
                    dragon.targetPosition = null;
                    this.lastPlayerY = ownerY;
                    return;
                }
            }
            if (canHover && yDeltaRelative >= -0.5) {
                dragon.setHovering(true);
                dragon.setFlying(true);
                dragon.setGoingUp(false);
                dragon.setDiving(false);
                dragon.getNavigation().stop();
                dragon.setDeltaMovement(Vec3.ZERO);
                dragon.targetPosition = null;
                this.lastPlayerY = ownerY;
                return;
            }
            dragon.setHovering(false);
            dragon.setGoingUp(false);
            dragon.setDiving(false);
            dragon.getNavigation().stop();
            dragon.setDeltaMovement(Vec3.ZERO);
            dragon.targetPosition = null;
            this.lastPlayerY = ownerY;
            return;
        }
        dragon.setHovering(false);
        this.updateVerticalState(dragon, ownerY - dragonY);
        double speed = dragon.isFlying() ? (double)dragon.getFlyingSpeed() * 8.0 : (double)dragon.getSpeed() * 8.0;
        dragon.getNavigation().moveTo(owner.getX(), owner.getY(), owner.getZ(), speed);
        dragon.targetPosition = new BlockPos((int)owner.getX(), (int)owner.getY(), (int)owner.getZ());
        this.lastPlayerY = ownerY;
    }

    private void updateVerticalState(BddDragon dragon, double vDelta) {
        if (this.vHoldTicks > 0) {
            --this.vHoldTicks;
        }
        switch (this.vState.ordinal()) {
            case 1: {
                if (!(vDelta <= 1.0) || this.vHoldTicks != 0) break;
                this.vState = VState.NEUTRAL;
                break;
            }
            case 2: {
                if (!(vDelta >= -1.0) || this.vHoldTicks != 0) break;
                this.vState = VState.NEUTRAL;
                break;
            }
            case 0: {
                if (vDelta >= 2.0) {
                    this.vState = VState.ASCEND;
                    this.vHoldTicks = this.VSTATE_MIN_HOLD;
                    break;
                }
                if (!(vDelta <= -2.0)) break;
                this.vState = VState.DESCEND;
                this.vHoldTicks = this.VSTATE_MIN_HOLD;
            }
        }
        if (this.vState == VState.ASCEND) {
            dragon.setGoingUp(true);
            dragon.setDiving(false);
        } else if (this.vState == VState.DESCEND) {
            dragon.setGoingUp(false);
            dragon.setDiving(true);
        } else {
            dragon.setGoingUp(false);
            dragon.setDiving(false);
        }
    }

    @Override
    public void stop(BddDragon dragon, Level level) {
        dragon.getNavigation().stop();
        dragon.setDeltaMovement(dragon.getDeltaMovement().x, 0.0, dragon.getDeltaMovement().z);
        dragon.setFlying(false);
        dragon.setHovering(false);
        dragon.setGoingUp(false);
        dragon.setDiving(false);
        dragon.targetPosition = null;
        this.lastPlayerY = 0.0;
        this.vState = VState.NEUTRAL;
        this.vHoldTicks = 0;
        this.followActive = true;
    }

    private static enum VState {
        NEUTRAL,
        ASCEND,
        DESCEND;

    }
}

