/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.ai.behaviors;

import com.bdc.bdd.api.ai_stuffs.DragonBehavior;
import com.bdc.bdd.api.entity.BddDragon;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;

public class FoodSeekingBehavior
implements DragonBehavior<BddDragon> {
    private static final double SEARCH_RADIUS = 16.0;
    private static final double EAT_DISTANCE = 2.5;
    private static final int EATING_DURATION_TICKS = 20;
    private int eatingTicks = 0;
    private ItemEntity targetFood = null;

    @Override
    public boolean canStart(BddDragon dragon, net.minecraft.world.level.Level level) {
        if (dragon.isEating() && this.eatingTicks > 0) {
            return true;
        }
        if (!dragon.needsFood() || !dragon.canMove()) {
            return false;
        }
        this.targetFood = this.findClosestFood(dragon, level);
        return this.targetFood != null && this.targetFood.isAlive();
    }

    @Override
    public void start(BddDragon dragon, net.minecraft.world.level.Level level) {
        if (this.eatingTicks > 0 || dragon.isEating()) {
            ++this.eatingTicks;
            if (this.eatingTicks >= 20 && this.targetFood != null) {
                if (this.targetFood.isAlive()) {
                    dragon.onFoodEaten();
                    this.targetFood.getItem().shrink(1);
                    BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Dragon consumed food item: " + this.targetFood.getItem().getDisplayName().getString() + " at position: " + String.valueOf(this.targetFood.position())));
                    if (this.targetFood.getItem().isEmpty()) {
                        this.targetFood.discard();
                        this.targetFood.setRemoved(Entity.RemovalReason.DISCARDED);
                        BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Food item removed from world at: " + String.valueOf(this.targetFood.position())));
                    }
                    this.targetFood = null;
                }
                dragon.setEating(false);
                this.eatingTicks = 0;
                dragon.getNavigation().stop();
                return;
            }
            dragon.setEating(true);
            dragon.getNavigation().stop();
            dragon.setDeltaMovement(Vec3.ZERO);
            return;
        }
        if (this.targetFood != null && this.targetFood.isAlive()) {
            Vec3 foodPos = this.targetFood.position().add(0.0, 0.25, 0.0);
            double distanceToFood = dragon.distanceToSqr((Entity)this.targetFood);
            if (distanceToFood <= 6.25) {
                dragon.setEating(true);
                dragon.getNavigation().stop();
                dragon.setDeltaMovement(Vec3.ZERO);
                this.eatingTicks = 1;
                BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Dragon started eating at distance: " + Math.sqrt(distanceToFood) + " from item at: " + String.valueOf(foodPos)));
            } else {
                double speed;
                double d = speed = dragon.isAbleToFly() && dragon.getAltitude() > 5.0 ? (double)dragon.getFlyingSpeed() : (double)dragon.getSpeed() * 8.0;
                if (dragon.isAbleToFly() && dragon.getAltitude() > 5.0) {
                    dragon.setFlying(true);
                    dragon.getNavigation().moveTo(foodPos.x, foodPos.y, foodPos.z, speed);
                } else {
                    dragon.setFlying(false);
                    dragon.getNavigation().moveTo(foodPos.x, foodPos.y, foodPos.z, speed);
                }
                BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Dragon moving to food item at: " + String.valueOf(foodPos) + ", distance: " + Math.sqrt(distanceToFood)));
            }
        } else {
            this.targetFood = null;
            this.eatingTicks = 0;
            dragon.setEating(false);
            dragon.getNavigation().stop();
        }
    }

    @Override
    public void stop(BddDragon dragon, net.minecraft.world.level.Level level) {
        dragon.setEating(false);
        this.eatingTicks = 0;
        this.targetFood = null;
        dragon.getNavigation().stop();
        dragon.setDeltaMovement(Vec3.ZERO);
    }

    private ItemEntity findClosestFood(BddDragon dragon, net.minecraft.world.level.Level level) {
        AABB searchBox = dragon.getBoundingBox().inflate(16.0);
        List items = level.getEntitiesOfClass(ItemEntity.class, searchBox, item -> item.isAlive() && dragon.isFood(item.getItem()));
        return items.stream().min(Comparator.comparingDouble(arg_0 -> ((BddDragon)dragon).distanceToSqr(arg_0))).orElse(null);
    }
}

