/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.ai.behaviors;

import com.bdc.bdd.api.ai_stuffs.DragonBehavior;
import com.bdc.bdd.api.entity.BddDragon;
import com.bdc.bdd.api.entity.core_classes.BddBaseDragon;
import com.bdc.bdd.registry.TagRegistry;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;

public class HuntingBehavior
implements DragonBehavior<BddDragon> {
    private static final double SEARCH_RADIUS = 16.0;
    private static final double ATTACK_DISTANCE = 2.2;
    private LivingEntity targetPrey = null;

    @Override
    public boolean canStart(BddDragon dragon, net.minecraft.world.level.Level level) {
        boolean canMove = dragon.canMove();
        int currentHunger = dragon.getHunger();
        boolean isHungryEnoughToHunt = currentHunger <= BddBaseDragon.MIN_HUNGER;
        BaseLogger.log((Level)BaseLogLevel.INFO, (String)("HuntingBehavior: Dragon Hunger: " + currentHunger + ", MIN_HUNGER: " + BddBaseDragon.MIN_HUNGER + ", CanMove: " + canMove + ", IsHungryEnoughToHunt: " + isHungryEnoughToHunt));
        if (!isHungryEnoughToHunt || !canMove) {
            return false;
        }
        this.targetPrey = this.findClosestPrey(dragon, level);
        BaseLogger.log((Level)BaseLogLevel.INFO, (String)("HuntingBehavior: Target Prey found: " + (this.targetPrey != null ? this.targetPrey.getName().getString() : "None")));
        return this.targetPrey != null && this.targetPrey.isAlive();
    }

    @Override
    public void start(BddDragon dragon, net.minecraft.world.level.Level level) {
        if (this.targetPrey != null && this.targetPrey.isAlive()) {
            dragon.setTarget(this.targetPrey);
            double distanceToPrey = dragon.distanceToSqr((Entity)this.targetPrey);
            if (distanceToPrey <= 4.840000000000001) {
                float damage = dragon.getPower();
                this.targetPrey.hurt(level.damageSources().mobAttack((LivingEntity)dragon), damage);
                BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Dragon attacked prey: " + this.targetPrey.getName().getString() + " for " + damage + " damage at position: " + String.valueOf(this.targetPrey.position())));
                if (!this.targetPrey.isAlive()) {
                    dragon.onFoodEaten();
                    this.targetPrey = null;
                    dragon.setTarget(null);
                    dragon.getNavigation().stop();
                    dragon.setSprinting(false);
                    BaseLogger.log((Level)BaseLogLevel.INFO, (String)"Prey killed, clearing target");
                } else {
                    dragon.getNavigation().stop();
                    dragon.setDeltaMovement(Vec3.ZERO);
                    dragon.setSprinting(false);
                }
            } else {
                Vec3 preyPos = this.targetPrey.position().add(0.0, 0.25, 0.0);
                double speed = dragon.isAbleToFly() && dragon.getAltitude() > 5.0 ? (double)dragon.getFlyingSpeed() : (double)dragon.getSpeed() * 8.0;
                dragon.setSprinting(true);
                if (dragon.isAbleToFly() && dragon.getAltitude() > 5.0) {
                    dragon.setFlying(true);
                    dragon.getNavigation().moveTo(preyPos.x, preyPos.y, preyPos.z, speed);
                } else {
                    dragon.setFlying(false);
                    dragon.getNavigation().moveTo(preyPos.x, preyPos.y, preyPos.z, speed);
                }
                BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Dragon moving to prey: " + this.targetPrey.getName().getString() + " at position: " + String.valueOf(preyPos) + ", distance: " + Math.sqrt(distanceToPrey)));
            }
        } else {
            this.targetPrey = null;
            dragon.setTarget(null);
            dragon.getNavigation().stop();
            dragon.setSprinting(false);
            BaseLogger.log((Level)BaseLogLevel.INFO, (String)"No valid prey found, stopping hunting");
        }
    }

    @Override
    public void stop(BddDragon dragon, net.minecraft.world.level.Level level) {
        dragon.setTarget(null);
        this.targetPrey = null;
        dragon.getNavigation().stop();
        dragon.setDeltaMovement(Vec3.ZERO);
        dragon.setFlying(false);
        dragon.setSprinting(false);
    }

    private LivingEntity findClosestPrey(BddDragon dragon, net.minecraft.world.level.Level level) {
        AABB searchBox = dragon.getBoundingBox().inflate(16.0);
        List preyEntities = level.getEntitiesOfClass(LivingEntity.class, searchBox, entity -> entity.isAlive() && entity.getType().is(TagRegistry.PREY) && entity != dragon);
        return preyEntities.stream().min(Comparator.comparingDouble(arg_0 -> ((BddDragon)dragon).distanceToSqr(arg_0))).orElse(null);
    }
}

