/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.ai.behaviors;

import com.bdc.bdd.api.ai_stuffs.DragonBehavior;
import com.bdc.bdd.api.entity.BddDragon;
import com.bdc.bdd.dragons.SpeedStinger;
import java.util.logging.Level;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;

public class SpeedstingerAttackBehavior
implements DragonBehavior<BddDragon> {
    private static final double AGGRESSION_RADIUS = 5.0;
    private static final double ATTACK_DISTANCE = 2.5;
    private static final double JUMP_ATTACK_CHANCE = 0.3;
    private static final double POISON_CHANCE = 0.5;
    private static final int POISON_DURATION = 100;
    private static final int POISON_AMPLIFIER = 1;
    private Player targetPlayer = null;

    @Override
    public boolean canStart(BddDragon dragon, net.minecraft.world.level.Level level) {
        if (dragon instanceof SpeedStinger) {
            BaseLogger.log((Level)BaseLogLevel.INFO, (String)"SpeedstingerAttackBehavior: Dragon is not wild or cautious, cannot execute");
            return false;
        }
        AABB searchBox = dragon.getBoundingBox().inflate(5.0);
        this.targetPlayer = level.getEntitiesOfClass(Player.class, searchBox, player -> player.isAlive() && !player.isCreative() && !player.isSpectator() && dragon.isArmedWithinRange(5.0)).stream().findFirst().orElse(null);
        boolean canStart = this.targetPlayer != null && dragon.canMove();
        BaseLogger.log((Level)BaseLogLevel.INFO, (String)("SpeedstingerAttackBehavior: canStart: " + canStart + ", Target Player: " + (this.targetPlayer != null ? this.targetPlayer.getName().getString() : "None")));
        return canStart;
    }

    @Override
    public void start(BddDragon dragon, net.minecraft.world.level.Level level) {
        if (this.targetPlayer != null && this.targetPlayer.isAlive()) {
            dragon.setTarget((LivingEntity)this.targetPlayer);
            double distanceToPlayer = dragon.distanceToSqr((Entity)this.targetPlayer);
            dragon.setSprinting(true);
            if (distanceToPlayer <= 6.25) {
                Player player;
                boolean isJumpAttack;
                boolean bl = isJumpAttack = dragon.random.nextDouble() < 0.3;
                if (isJumpAttack) {
                    dragon.setDeltaMovement(dragon.getDeltaMovement().add(0.0, 0.6, 0.0));
                    BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Speedstinger performing jump attack on player: " + this.targetPlayer.getName().getString()));
                } else {
                    BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Speedstinger performing run attack on player: " + this.targetPlayer.getName().getString()));
                }
                this.targetPlayer.hurt(level.damageSources().mobAttack((LivingEntity)dragon), dragon.getPower());
                if (dragon.random.nextDouble() < 0.5 && (player = this.targetPlayer) instanceof LivingEntity) {
                    Player livingTarget = player;
                    livingTarget.addEffect(new MobEffectInstance(MobEffects.POISON, 100, 1));
                    BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Applied poison to player: " + this.targetPlayer.getName().getString()));
                }
                dragon.getNavigation().stop();
                dragon.setDeltaMovement(Vec3.ZERO);
                dragon.setSprinting(false);
            } else {
                double speed;
                Vec3 playerPos = this.targetPlayer.position().add(0.0, 0.25, 0.0);
                double d = speed = dragon.isAbleToFly() && dragon.getAltitude() > 5.0 ? (double)dragon.getFlyingSpeed() : (double)dragon.getSpeed() * 10.0;
                if (dragon.isAbleToFly() && dragon.getAltitude() > 5.0) {
                    dragon.setFlying(true);
                    dragon.getNavigation().moveTo(playerPos.x, playerPos.y, playerPos.z, speed);
                } else {
                    dragon.setFlying(false);
                    dragon.getNavigation().moveTo(playerPos.x, playerPos.y, playerPos.z, speed);
                }
                BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Speedstinger moving to player: " + this.targetPlayer.getName().getString() + " at position: " + String.valueOf(playerPos) + ", distance: " + Math.sqrt(distanceToPlayer)));
            }
        } else {
            this.targetPlayer = null;
            dragon.setTarget(null);
            dragon.getNavigation().stop();
            dragon.setSprinting(false);
            BaseLogger.log((Level)BaseLogLevel.INFO, (String)"No valid player target found, stopping Speedstinger attack");
        }
    }

    @Override
    public void stop(BddDragon dragon, net.minecraft.world.level.Level level) {
        dragon.setTarget(null);
        this.targetPlayer = null;
        dragon.getNavigation().stop();
        dragon.setDeltaMovement(Vec3.ZERO);
        dragon.setFlying(false);
        dragon.setSprinting(false);
        BaseLogger.log((Level)BaseLogLevel.INFO, (String)"SpeedstingerAttackBehavior stopped");
    }
}

