/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.core_classes;

import com.bdc.bdd.BddCommon;
import com.bdc.bdd.BddConstants;
import com.bdc.bdd.api.entity.util.BddLogic;
import com.bdc.bdd.api.entity.util.HomePosition;
import com.bdc.bdd.api.util.DragonAbilities;
import com.bdc.bdd.api.util.DragonAggressionTypes;
import com.bdc.bdd.api.util.DragonCommands;
import com.bdc.bdd.api.util.interfaces.IDragonAbilty;
import com.bdc.bdd.api.util.interfaces.IFlyingDragon;
import com.bdc.bdd.api.util.interfaces.ISaddleableDragon;
import com.bdc.bdd.net.messages.server.DragonHoverPacket;
import com.bdc.bdd.net.messages.server.abilities.DragonAbilityPacket;
import com.bdc.bdd.net.messages.server.abilities.DragonBitePacket;
import com.bdc.bdd.net.messages.server.abilities.DragonRoarPacket;
import com.bdc.bdd.registry.ItemRegistry;
import com.bdc.bdd.registry.builders.entity.BddEntityBuilder;
import com.bdc.bdd.util.BDDKeyMappings;
import com.bdc.bdd.util.BddUtil;
import com.google.gson.JsonElement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Level;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import software.bluelib.api.entity.variant.IVariantEntity;
import software.bluelib.api.net.NetworkPacket;
import software.bluelib.api.net.NetworkRegistry;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.api.utils.variant.ParameterUtils;
import software.bluelib.loader.animatable.entity.BlueEntity;

public abstract class BddBaseDragon
extends TamableAnimal
implements IVariantEntity<BddBaseDragon>,
IFlyingDragon,
OwnableEntity,
IDragonAbilty,
ISaddleableDragon,
PlayerRideable,
BlueEntity {
    private static final EntityDataAccessor<Integer> HUNGER = SynchedEntityData.defineId(BddBaseDragon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> AGE_TICKS = SynchedEntityData.defineId(BddBaseDragon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> GENDER = SynchedEntityData.defineId(BddBaseDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.defineId(BddBaseDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> DRAGON_BOND = SynchedEntityData.defineId(BddBaseDragon.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> COMMANDS = SynchedEntityData.defineId(BddBaseDragon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> TITAN_WING = SynchedEntityData.defineId(BddBaseDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> EATING = SynchedEntityData.defineId(BddBaseDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DISTURB_TICKS = SynchedEntityData.defineId(BddBaseDragon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_IS_SPRINTING = SynchedEntityData.defineId(BddBaseDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DRAGON_STAMINA = SynchedEntityData.defineId(BddBaseDragon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DRAGON_SPEED = SynchedEntityData.defineId(BddBaseDragon.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> IS_ROPED = SynchedEntityData.defineId(BddBaseDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> CAN_FLY = SynchedEntityData.defineId(BddBaseDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DISABLE_AI = SynchedEntityData.defineId(BddBaseDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> TAILFIN = SynchedEntityData.defineId(BddBaseDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FAKE_TAILFIN = SynchedEntityData.defineId(BddBaseDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> LOCKED = SynchedEntityData.defineId(BddBaseDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> TAME_PROGRESS = SynchedEntityData.defineId(BddBaseDragon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static int MAX_HUNGER = 200;
    public static int MIN_HUNGER = 30;
    public static float DEFAULT_FLYING_SPEED = 0.1f;
    public static float MAX_FLYING_SPEED = 0.3f;
    public static float DEFAULT_ATTACK_DAMAGE = 5.0f;
    public static final int MAX_TAME_PROGRESS = 100;
    public final Random random = new Random();
    public BddLogic logic;
    public long eatingStartTime = 0L;
    @Nullable
    public Matrix4f riderMatrix = null;
    @Nullable
    public Matrix4f headMatrix = null;
    @Nullable
    public Matrix4f headMatrix2 = null;
    @Nullable
    public Matrix4f tailMatrix = null;
    public ItemStack lastFedItem = ItemStack.EMPTY;
    public Player lastFeederPlayer = null;
    public HomePosition homePosition;
    public boolean hasHomePosition = false;
    public boolean isAggro = false;
    private boolean initialDimensionsRefreshed = false;
    private float bodyRoll = 0.0f;
    public BlockPos targetPosition = null;
    private DragonAggressionTypes aggressionType = DragonAggressionTypes.NEUTRAL;
    public int ticksSinceLanding = 0;
    public int ticksSinceFlying = 0;
    private boolean awaitingAcceptance = false;
    @Nullable
    private UUID candidateOwner = null;
    private boolean tamingProcessStarted = false;
    private int awaitingTicks = 0;
    @Nullable
    private UUID tamingInitiator = null;
    private static final Map<String, Integer> RARITY_WEIGHTS = new HashMap<String, Integer>();

    public BddBaseDragon(EntityType<? extends TamableAnimal> entityType, net.minecraft.world.level.Level level) {
        super(entityType, level);
        this.noCulling = true;
        this.maxUpStep();
        this.logic = this.createDragonLogic();
        this.refreshDimensions();
    }

    public DragonAggressionTypes getAggressionType() {
        return this.aggressionType;
    }

    public void setAggressionType(DragonAggressionTypes aggressionType) {
        this.aggressionType = aggressionType;
    }

    public float getBodyRoll() {
        return this.bodyRoll;
    }

    public void setBodyRoll(float roll) {
        this.bodyRoll = roll;
    }

    protected BddLogic createDragonLogic() {
        return new BddLogic(this);
    }

    public ResourceLocation returnDragonType() {
        String typeName = BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getType()).getPath();
        List<String> dragonNames = BddEntityBuilder.getDragonNames();
        if (dragonNames.contains(typeName)) {
            return BddCommon.Resource.resource(typeName);
        }
        throw new IllegalStateException("Entity type " + typeName + " is not a registered dragon. Registered dragons: " + String.valueOf(dragonNames));
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HUNGER, (Object)MAX_HUNGER);
        builder.define(AGE_TICKS, (Object)0);
        builder.define(GENDER, (Object)false);
        builder.define(SLEEPING, (Object)false);
        builder.define(COMMANDS, (Object)DragonCommands.WANDERING.ordinal());
        builder.define(DRAGON_BOND, (Object)Float.valueOf(0.0f));
        builder.define(TITAN_WING, (Object)false);
        builder.define(EATING, (Object)false);
        builder.define(DISTURB_TICKS, (Object)0);
        builder.define(DATA_IS_SPRINTING, (Object)false);
        builder.define(DRAGON_STAMINA, (Object)100);
        builder.define(DRAGON_SPEED, (Object)Float.valueOf(DEFAULT_FLYING_SPEED));
        builder.define(IS_ROPED, (Object)false);
        builder.define(CAN_FLY, (Object)true);
        builder.define(DISABLE_AI, (Object)false);
        builder.define(TAILFIN, (Object)true);
        builder.define(FAKE_TAILFIN, (Object)false);
        builder.define(LOCKED, (Object)false);
        builder.define(TAME_PROGRESS, (Object)0);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Hunger", this.getHunger());
        compound.putInt("AgeTicks", this.getAgeInTicks());
        compound.putBoolean("Gender", this.isMale());
        compound.putBoolean("Sleeping", this.isDragonSleeping());
        compound.putInt("DisturbTicks", this.getSleepDisturbTicks());
        compound.putString("DragonCommand", this.getCommand().name());
        compound.putBoolean("TitanWing", this.isTitanWing());
        compound.putFloat("DragonBond", this.getDragonBond());
        compound.putInt("DragonStamina", this.getDragonStamina());
        compound.putFloat("DragonSpeed", this.getFlyingSpeed());
        compound.putBoolean("Roped", this.isRoped());
        compound.putBoolean("CanFly", this.canFly());
        compound.putBoolean("DisableAI", this.isAIDisabled());
        compound.putBoolean("Tailfin", this.hasTailFin());
        compound.putBoolean("FakeTailfin", this.hasFakeTailFin());
        compound.putBoolean("HasHomePosition", this.hasHomePosition);
        compound.putBoolean("Locked", this.isLocked());
        compound.putInt("TameProgress", this.getTameProgress());
        compound.putBoolean("TamingStarted", this.tamingProcessStarted);
        if (this.tamingInitiator != null) {
            compound.putUUID("TamingInitiator", this.tamingInitiator);
        }
        if (this.homePosition != null && this.hasHomePosition) {
            this.homePosition.write(compound);
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setHunger(compound.getInt("Hunger"));
        this.setAgeInTicks(compound.getInt("AgeTicks"));
        this.setGender(compound.getBoolean("Gender"));
        this.setIsDragonSleeping(compound.getBoolean("Sleeping"));
        this.setTitanWing(compound.getBoolean("TitanWing"));
        this.setDragonBond(compound.getFloat("DragonBond"));
        this.setSleepDisturbTicks(compound.getInt("DisturbTicks"));
        this.setDragonStamina(compound.getInt("DragonStamina"));
        this.setRoped(compound.getBoolean("Roped"));
        this.setCanFly(compound.getBoolean("CanFly"));
        this.setAIDisabled(compound.getBoolean("DisableAI"));
        this.setTailFin(compound.getBoolean("Tailfin"));
        this.setFakeTailFin(compound.getBoolean("FakeTailfin"));
        this.setLocked(compound.getBoolean("Locked"));
        this.tamingProcessStarted = compound.getBoolean("TamingStarted");
        this.setTameProgress(compound.getInt("TameProgress"));
        this.setFlyingSpeed(compound.getFloat("DragonSpeed"));
        this.tamingInitiator = compound.hasUUID("TamingInitiator") ? compound.getUUID("TamingInitiator") : null;
        if (compound.contains("DragonCommand")) {
            try {
                this.setCommand(DragonCommands.valueOf(compound.getString("DragonCommand")));
            }
            catch (IllegalArgumentException e) {
                this.setCommand(DragonCommands.WANDERING);
                BaseLogger.log((Level)BaseLogLevel.WARNING, (String)("Invalid command in NBT: " + compound.getString("DragonCommand") + ", defaulting to WANDERING"));
            }
        }
        this.hasHomePosition = compound.getBoolean("HasHomePosition");
        if (this.hasHomePosition && compound.getInt("HomeAreaX") != 0 && compound.getInt("HomeAreaY") != 0 && compound.getInt("HomeAreaZ") != 0) {
            this.homePosition = new HomePosition(compound, this.level());
        }
        this.refreshDimensions();
    }

    @NotNull
    public BlockPos getRestrictCenter() {
        return this.homePosition == null ? super.getRestrictCenter() : this.homePosition.getPosition();
    }

    public float getRestrictRadius() {
        return this.isTame() ? 50.0f : 100.0f;
    }

    public String getHomeDimensionName() {
        return this.homePosition == null ? "" : this.homePosition.getDimension();
    }

    public boolean hasRestriction() {
        return this.hasHomePosition && this.getHomeDimensionName().equals(HomePosition.getDimensionName(this.level())) || super.hasRestriction();
    }

    public DragonCommands getCommand() {
        return DragonCommands.values()[(Integer)this.entityData.get(COMMANDS)];
    }

    public void setCommand(DragonCommands command) {
        this.entityData.set(COMMANDS, (Object)command.ordinal());
    }

    public void tame(Player player) {
        super.tame(player);
    }

    public boolean isDragonWandering() {
        return this.getCommand() == DragonCommands.WANDERING;
    }

    public boolean isDragonSitting() {
        return this.getCommand() == DragonCommands.SITTING;
    }

    public boolean isDragonFollowing() {
        return this.getCommand() == DragonCommands.FOLLOWING;
    }

    public void setIsDragonWandering(boolean wandering) {
        if (wandering) {
            this.setCommand(DragonCommands.WANDERING);
        }
    }

    public void setIsDragonSitting(boolean sitting) {
        if (sitting) {
            this.setCommand(DragonCommands.SITTING);
        }
    }

    public void setIsDragonFollowing(boolean following) {
        if (following) {
            this.setCommand(DragonCommands.FOLLOWING);
        }
    }

    public boolean isDragonSleeping() {
        return (Boolean)this.entityData.get(SLEEPING);
    }

    public void setIsDragonSleeping(boolean sleeping) {
        this.entityData.set(SLEEPING, (Object)sleeping);
    }

    public void setSprinting(boolean sprinting) {
        this.entityData.set(DATA_IS_SPRINTING, (Object)sprinting);
    }

    public boolean isSprinting() {
        return (Boolean)this.entityData.get(DATA_IS_SPRINTING);
    }

    public boolean isAggro() {
        return this.isAggro;
    }

    public void setAggro(boolean sleeping) {
        this.isAggro = sleeping;
    }

    public float getDragonBond() {
        return ((Float)this.entityData.get(DRAGON_BOND)).floatValue();
    }

    public void setDragonBond(float bond) {
        this.entityData.set(DRAGON_BOND, (Object)Float.valueOf(Mth.clamp((float)bond, (float)0.0f, (float)1.0f)));
    }

    public int getAgeInDays() {
        return (Integer)this.entityData.get(AGE_TICKS) / 24000;
    }

    public void setAgeInDays(int age) {
        this.entityData.set(AGE_TICKS, (Object)(age * 24000));
        this.refreshDimensions();
    }

    @NotNull
    protected EntityDimensions getDefaultDimensions(@NotNull Pose pose) {
        int stage = this.getDragonStage();
        float[] dimensions = this.getBoundingBoxDimensions(stage);
        float width = dimensions[0];
        float height = dimensions[1];
        return EntityDimensions.scalable((float)width, (float)height);
    }

    protected float[] getBoundingBoxDimensions(int stage) {
        float[] fArray;
        switch (stage) {
            case 1: {
                float[] fArray2 = new float[2];
                fArray2[0] = 0.5f;
                fArray = fArray2;
                fArray2[1] = 0.7f;
                break;
            }
            case 2: {
                float[] fArray3 = new float[2];
                fArray3[0] = 0.9f;
                fArray = fArray3;
                fArray3[1] = 1.1f;
                break;
            }
            case 3: {
                float[] fArray4 = new float[2];
                fArray4[0] = 1.3f;
                fArray = fArray4;
                fArray4[1] = 1.7f;
                break;
            }
            case 4: {
                float[] fArray5 = new float[2];
                fArray5[0] = 1.7f;
                fArray = fArray5;
                fArray5[1] = 2.2f;
                break;
            }
            default: {
                float[] fArray6 = new float[2];
                fArray6[0] = 1.7f;
                fArray = fArray6;
                fArray6[1] = 2.2f;
            }
        }
        return fArray;
    }

    public void refreshDimensions() {
        double oldX = this.getX();
        double oldY = this.getY();
        double oldZ = this.getZ();
        super.refreshDimensions();
        this.setPos(oldX, oldY, oldZ);
        float[] dimensions = this.getBoundingBoxDimensions(this.getDragonStage());
        this.getAttribute(Attributes.FOLLOW_RANGE).setBaseValue((double)(dimensions[0] * 8.0f));
    }

    public int getAgeInTicks() {
        return (Integer)this.entityData.get(AGE_TICKS);
    }

    public void setAgeInTicks(int age) {
        this.entityData.set(AGE_TICKS, (Object)Math.max(age, 0));
    }

    public boolean isMale() {
        return (Boolean)this.entityData.get(GENDER);
    }

    public void setGender(boolean male) {
        this.entityData.set(GENDER, (Object)male);
    }

    public boolean isTitanWing() {
        return (Boolean)this.entityData.get(TITAN_WING);
    }

    public void setTitanWing(boolean titanWing) {
        this.entityData.set(TITAN_WING, (Object)titanWing);
    }

    public int getHunger() {
        return (Integer)this.entityData.get(HUNGER);
    }

    public void setHunger(int hunger) {
        this.entityData.set(HUNGER, (Object)Mth.clamp((int)hunger, (int)0, (int)MAX_HUNGER));
    }

    public boolean isEating() {
        return (Boolean)this.entityData.get(EATING);
    }

    public void setEating(boolean eating) {
        this.entityData.set(EATING, (Object)eating);
    }

    public int getSleepDisturbTicks() {
        return (Integer)this.entityData.get(DISTURB_TICKS);
    }

    public void setSleepDisturbTicks(int disturbTicks) {
        this.entityData.set(DISTURB_TICKS, (Object)Math.max(disturbTicks, 0));
    }

    public int getDragonStamina() {
        return (Integer)this.entityData.get(DRAGON_STAMINA);
    }

    public void setDragonStamina(int stamina) {
        this.entityData.set(DRAGON_STAMINA, (Object)Mth.clamp((int)stamina, (int)0, (int)100));
    }

    public boolean isRoped() {
        return (Boolean)this.entityData.get(IS_ROPED);
    }

    public void setRoped(boolean roped) {
        this.entityData.set(IS_ROPED, (Object)roped);
    }

    public boolean hasTailFin() {
        return (Boolean)this.entityData.get(TAILFIN);
    }

    public void setTailFin(boolean tailFin) {
        this.entityData.set(TAILFIN, (Object)tailFin);
    }

    public boolean hasFakeTailFin() {
        return (Boolean)this.entityData.get(FAKE_TAILFIN);
    }

    public void setFakeTailFin(boolean fakeTailFin) {
        this.entityData.set(FAKE_TAILFIN, (Object)fakeTailFin);
    }

    public boolean isLocked() {
        return (Boolean)this.entityData.get(LOCKED);
    }

    public void setLocked(boolean locked) {
        this.entityData.set(LOCKED, (Object)locked);
    }

    public void modifyCommand(Player player) {
        DragonCommands currentCommand = this.getCommand();
        DragonCommands[] commands = DragonCommands.values();
        int nextIndex = (currentCommand.ordinal() + 1) % commands.length;
        this.setCommand(commands[nextIndex]);
        String[] commandMessages = new String[]{"follow", "sit", "wander"};
        player.displayClientMessage(BddCommon.Translation.command(commandMessages[nextIndex], commands[nextIndex].name()), true);
    }

    public void growDragon(int ageInDays) {
        this.setAgeInDays(this.getAgeInDays() + ageInDays);
        this.refreshDimensions();
    }

    public int getDragonStage() {
        int age = this.getAgeInDays();
        if (age >= 100) {
            return 5;
        }
        if (age >= 75) {
            return 4;
        }
        if (age >= 50) {
            return 3;
        }
        if (age >= 25) {
            return 2;
        }
        return 1;
    }

    public boolean isAdult() {
        return this.getDragonStage() == 4;
    }

    public boolean isTeen() {
        return this.getDragonStage() == 3;
    }

    public boolean isJuvenile() {
        return this.getDragonStage() == 2;
    }

    public boolean isBaby() {
        return this.getDragonStage() == 1;
    }

    public int getMaxHeadYRot() {
        return 90;
    }

    public int getMaxHeadXRot() {
        return 75;
    }

    public void tick() {
        super.tick();
        this.logic.manageDragonBehavior();
        this.logic.updateDragonServer();
        this.logic.handleDragonStamina();
        if (this.isAwaitingAcceptance()) {
            ++this.awaitingTicks;
            if (this.awaitingTicks > BddUtil.secondsToTicks(5)) {
                this.resetTamingProgress();
            }
        } else {
            this.awaitingTicks = 0;
        }
        if (this.level.isClientSide()) {
            if (!this.initialDimensionsRefreshed && this.getAgeInDays() >= 100) {
                BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Client: Performing initial dimension refresh in tick for " + this.getDisplayName().getString() + " (ID: " + this.getId() + ")"));
                this.refreshDimensions();
                this.initialDimensionsRefreshed = true;
            }
            this.updateClientControls();
        }
        if (!this.level.isClientSide() && this.isTamingProcessStarted()) {
            Player toCheck = null;
            if (this.isAwaitingAcceptance() && this.candidateOwner != null) {
                toCheck = this.level.getPlayerByUUID(this.candidateOwner);
            } else if (this.tamingInitiator != null) {
                toCheck = this.level.getPlayerByUUID(this.tamingInitiator);
            }
            if (toCheck != null) {
                double maxDistSqr = 144.0;
                if (toCheck.distanceToSqr((Entity)this) <= maxDistSqr && (this.isPlayerArmed(toCheck) || this.isPlayerWearingArmor(toCheck))) {
                    toCheck.displayClientMessage((Component)Component.literal((String)"The dragon senses your aggression and backs away. Taming failed."), true);
                    this.resetTamingProgress();
                }
            }
        }
        if (!this.canMove()) {
            this.navigation.stop();
        }
        if (this.isEating() && (long)this.tickCount - this.eatingStartTime >= (long)BddUtil.secondsToTicks(2)) {
            this.setEating(false);
        }
    }

    public void updateClientControls() {
        NetworkRegistry.sendToServer((NetworkPacket)new DragonAbilityPacket(BddConstants.PlatformHelper.MISC.getKey(BDDKeyMappings.SPEED_UP).isDown(), DragonAbilities.SPEED_UP, this.getId()));
        NetworkRegistry.sendToServer((NetworkPacket)new DragonAbilityPacket(BddConstants.PlatformHelper.MISC.getKey(BDDKeyMappings.SPEED_DOWN).isDown(), DragonAbilities.SPEED_DOWN, this.getId()));
        if (BddConstants.PlatformHelper.MISC.getKey(BDDKeyMappings.HOVER).consumeClick()) {
            NetworkRegistry.sendToServer((NetworkPacket)new DragonHoverPacket(this.getId()));
        }
        NetworkRegistry.sendToServer((NetworkPacket)new DragonAbilityPacket(BddConstants.PlatformHelper.MISC.getKey(BDDKeyMappings.BLAST).isDown(), DragonAbilities.FIRE_BREATH, this.getId()));
        NetworkRegistry.sendToServer((NetworkPacket)new DragonAbilityPacket(BddConstants.PlatformHelper.MISC.getKey(BDDKeyMappings.BLAST).isDown(), DragonAbilities.FIRE_BLAST, this.getId()));
        NetworkRegistry.sendToServer((NetworkPacket)new DragonAbilityPacket(BddConstants.PlatformHelper.MISC.getKey(BDDKeyMappings.BLAST).isDown(), DragonAbilities.PLASMA_BLAST, this.getId()));
        NetworkRegistry.sendToServer((NetworkPacket)new DragonAbilityPacket(BddConstants.PlatformHelper.MISC.getKey(BDDKeyMappings.BLAST).isDown(), DragonAbilities.GAS_BOMB, this.getId()));
        NetworkRegistry.sendToServer((NetworkPacket)new DragonAbilityPacket(BddConstants.PlatformHelper.MISC.getKey(BDDKeyMappings.SECONDARY_ABILITY).isDown(), DragonAbilities.GAS_SPARK, this.getId()));
        NetworkRegistry.sendToServer((NetworkPacket)new DragonAbilityPacket(BddConstants.PlatformHelper.MISC.getKey(BDDKeyMappings.TAIL_WHIP).isDown(), DragonAbilities.TAIL_WHIP, this.getId()));
        if (BddConstants.PlatformHelper.MISC.getKey(BDDKeyMappings.ROAR).consumeClick()) {
            NetworkRegistry.sendToServer((NetworkPacket)new DragonRoarPacket(this.getId()));
        }
        if (BddConstants.PlatformHelper.MISC.getKey(BDDKeyMappings.BITE).consumeClick()) {
            NetworkRegistry.sendToServer((NetworkPacket)new DragonBitePacket(this.getId()));
        }
    }

    public boolean hurt(@NotNull DamageSource damage, float amount) {
        Entity entity;
        if (!this.isAlive() && damage != this.level.damageSources().fellOutOfWorld()) {
            return false;
        }
        if (this.isVehicle() && damage.getEntity() != null && this.getControllingPassenger() == damage.getEntity()) {
            return false;
        }
        if ((damage.is(DamageTypes.ARROW) || this.getVehicle() != null && damage.getEntity() != null && damage.getEntity().is(this.getVehicle())) && this.isPassenger()) {
            return false;
        }
        if (damage == this.level.damageSources().inWall() || damage == this.level.damageSources().fallingBlock((Entity)this) || damage == this.level.damageSources().cramming()) {
            return false;
        }
        if (damage == this.level.damageSources().inFire() || damage == this.level.damageSources().onFire() || damage == this.level.damageSources().dragonBreath()) {
            return false;
        }
        if (amount > 0.0f && !this.isTame() && (entity = damage.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            this.setTarget((LivingEntity)player);
        }
        if (damage.getEntity() != null && damage.getEntity().getVehicle() == this) {
            return false;
        }
        this.setSleepDisturbTicks(500);
        return super.hurt(damage, amount);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ItemTags.FISHES) || stack.is(ItemTags.MEAT) || this.isFavoriteFood(stack);
    }

    public boolean isFavoriteFood(ItemStack stack) {
        return this.getFavoriteFoods().contains(stack.getItem());
    }

    public boolean isBreedingFood(ItemStack stack) {
        return stack.is(Items.SUSPICIOUS_STEW);
    }

    public List<Item> getFavoriteFoods() {
        return List.of(Items.SALMON);
    }

    public boolean needsFood() {
        return (double)this.getHunger() < (double)MAX_HUNGER / 1.5;
    }

    public boolean canMove() {
        return !this.isDragonSitting() && !this.isDragonSleeping() && !this.isEating() && !this.isVehicle() && !this.isAIDisabled();
    }

    public boolean canFly() {
        return (Boolean)this.entityData.get(CAN_FLY);
    }

    public void setCanFly(boolean canFly) {
        this.entityData.set(CAN_FLY, (Object)canFly);
    }

    public boolean isAIDisabled() {
        return (Boolean)this.entityData.get(DISABLE_AI);
    }

    public void setAIDisabled(boolean disableAI) {
        this.entityData.set(DISABLE_AI, (Object)disableAI);
    }

    public boolean isAwaitingAcceptance() {
        return this.awaitingAcceptance;
    }

    public void setAwaitingAcceptance(boolean awaiting) {
        this.awaitingAcceptance = awaiting;
    }

    public void setCandidateOwner(@Nullable Player player) {
        this.candidateOwner = player != null ? player.getUUID() : null;
    }

    public boolean isCandidateOwner(Player player) {
        return this.candidateOwner != null && this.candidateOwner.equals(player.getUUID());
    }

    public int getTameProgress() {
        return (Integer)this.entityData.get(TAME_PROGRESS);
    }

    public void setTameProgress(int value) {
        this.entityData.set(TAME_PROGRESS, (Object)Mth.clamp((int)value, (int)0, (int)100));
    }

    public boolean isTamingProcessStarted() {
        return this.tamingProcessStarted;
    }

    public void setTamingProcessStarted(boolean started) {
        this.tamingProcessStarted = started;
    }

    public void resetTamingProgress() {
        net.minecraft.world.level.Level level;
        this.setTameProgress(0);
        this.setAwaitingAcceptance(false);
        this.setCandidateOwner(null);
        this.awaitingTicks = 0;
        this.setTamingProcessStarted(false);
        this.standUp();
        if (!this.level.isClientSide && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY() + 1.0, this.getZ(), 10, 0.5, 0.5, 0.5, 0.1);
        }
        this.playSound(SoundEvents.ENDER_DRAGON_GROWL, 1.0f, 0.8f);
    }

    public void standUp() {
        if (this.isDragonSitting()) {
            this.setCommand(DragonCommands.WANDERING);
        }
        this.setInSittingPose(false);
    }

    public boolean isDragonMoving() {
        return this.getX() != this.xOld || this.getZ() != this.zOld;
    }

    public boolean isMovingOnGround() {
        return this.isBlockBelowSolid() && this.getDeltaMovement().horizontalDistanceSqr() > 0.001;
    }

    public boolean isBlockBelowSolid() {
        BlockPos entityPos = this.blockPosition();
        BlockPos blockBelowPos = entityPos.below();
        return !this.level.getBlockState(blockBelowPos).isAir();
    }

    public float getPower() {
        return (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
    }

    public float getSpeed() {
        return (this.isSprinting() ? 1.25f : 1.0f) * (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED);
    }

    public float getFlyingSpeed() {
        return ((Float)this.entityData.get(DRAGON_SPEED)).floatValue();
    }

    public void setFlyingSpeed(float speed) {
        this.entityData.set(DRAGON_SPEED, (Object)Float.valueOf(Mth.clamp((float)speed, (float)0.02f, (float)MAX_FLYING_SPEED)));
    }

    protected void checkFallDamage(double y, boolean onGround, @NotNull BlockState state, @NotNull BlockPos pos) {
    }

    @NotNull
    public InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        this.lastFeederPlayer = player;
        this.lastFedItem = player.getItemInHand(hand);
        ItemStack stack = player.getItemInHand(hand);
        if (!this.isAlive()) {
            this.setSleepDisturbTicks(BddUtil.minutesToSeconds(4));
            return super.mobInteract(player, hand);
        }
        if (this.isBreedingFood(stack)) {
            return this.handleBreeding(player, hand, stack);
        }
        if (stack.isEmpty()) {
            if (player.isShiftKeyDown() && this.isOwnedBy((LivingEntity)player)) {
                this.setLocked(!this.isLocked());
                player.displayClientMessage((Component)Component.literal((String)("Dragon is now " + (this.isLocked() ? "Locked" : "Unlocked"))), true);
                return InteractionResult.SUCCESS;
            }
            return this.handleEmptyStack(player);
        }
        if (player.isCreative()) {
            if (stack.getItem() == ItemRegistry.SLEEP_STICK.get()) {
                this.setIsDragonSleeping(!this.isDragonSleeping());
                player.displayClientMessage((Component)Component.literal((String)("Dragon Is Now " + (this.isDragonSleeping() ? "Sleeping" : "Awake"))), true);
            }
            if (stack.getItem() == ItemRegistry.GROW_STICK.get()) {
                this.growDragon(1);
                player.displayClientMessage((Component)Component.literal((String)("Dragon aged up one day and is now " + this.getAgeInDays() + " old")), true);
            }
            if (stack.getItem() == ItemRegistry.TAME_STICK.get()) {
                this.tame(player);
                if (this.getOwner() != null) {
                    player.displayClientMessage((Component)Component.literal((String)("You now own this dragon: " + this.getOwner().getName().getString())), true);
                }
                return InteractionResult.SUCCESS;
            }
            if (stack.getItem() == ItemRegistry.DISABLE_AI_STICK.get()) {
                this.setAIDisabled(!this.isAIDisabled());
                player.displayClientMessage((Component)Component.literal((String)("Dragon AI " + (this.isAIDisabled() ? "Disabled" : "Enabled"))), true);
            }
            if (stack.getItem() == ItemRegistry.DERPY_STICK.get()) {
                this.setTailFin(!this.hasTailFin());
                player.displayClientMessage((Component)Component.literal((String)"Derpy Stick Used"), true);
            }
        }
        if (stack.getItem() == Items.STICK && this.isTame() && player.isShiftKeyDown()) {
            if (this.hasHomePosition) {
                this.hasHomePosition = false;
                player.displayClientMessage((Component)Component.literal((String)"Removed Dragon Home Position"), true);
                return InteractionResult.SUCCESS;
            }
            BlockPos pos = this.blockPosition();
            this.homePosition = new HomePosition(pos, this.level());
            this.hasHomePosition = true;
            player.displayClientMessage((Component)Component.literal((String)("Added Dragon New Dragon Home Position To: " + pos.getX() + pos.getY() + pos.getZ() + this.homePosition.getDimension())), true);
            return InteractionResult.SUCCESS;
        }
        if (stack.getItem() == Items.STICK && this.isTame()) {
            return this.handleCommands(player);
        }
        if (stack.getItem() == Items.SADDLE && !this.isSaddled() && this.isTame() && this.isSaddleable()) {
            this.equipSaddle(stack, this.getSoundSource());
            stack.shrink(1);
            player.displayClientMessage((Component)Component.literal((String)"Your Dragon is now saddled"), true);
            return InteractionResult.SUCCESS;
        }
        if (stack.getItem() == ItemRegistry.PROSTHETIC_TAILFIN.get() && !this.hasTailFin() && !this.hasFakeTailFin() && this.isSaddled()) {
            this.equipTail(stack, this.getSoundSource());
            stack.shrink(1);
            player.displayClientMessage((Component)Component.literal((String)"Prosthetic Tail Equipped"), true);
            return InteractionResult.SUCCESS;
        }
        if (this.isFood(stack)) {
            return this.handleFeedOrTame(player, stack);
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResult handleBreeding(Player player, InteractionHand hand, ItemStack stack) {
        if (this.isOwnedBy((LivingEntity)player) && this.getDragonBond() >= 69.0f) {
            if (!this.level.isClientSide && this.getAge() == 0 && this.canFallInLove()) {
                this.usePlayerItem(player, hand, stack);
                this.setInLove(player);
                this.gameEvent((Holder)GameEvent.ENTITY_INTERACT, (Entity)this);
                return InteractionResult.SUCCESS;
            }
        } else {
            player.displayClientMessage((Component)Component.literal((String)(this.getDragonBond() <= 68.0f ? "bdd.dragonbond.low" : "bdd.only.owner.breed")), false);
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public abstract InteractionResult handleSpecialInteractions(Player var1, @NotNull InteractionHand var2, ItemStack var3);

    public abstract void handleRiding(Player var1);

    @NotNull
    public abstract InteractionResult handleEmptyStack(Player var1);

    @NotNull
    public InteractionResult handleCommands(Player player) {
        this.modifyCommand(player);
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResult handleFeedOrTame(Player player, ItemStack stack) {
        if (!this.isTame()) {
            ServerLevel serverLevel;
            net.minecraft.world.level.Level level;
            if (!this.isFood(stack)) {
                net.minecraft.world.level.Level level2;
                player.displayClientMessage((Component)Component.literal((String)"The dragon refuses to eat that!"), true);
                this.playSound(SoundEvents.VILLAGER_NO, 1.0f, 1.0f);
                if (!this.level.isClientSide && (level2 = this.level) instanceof ServerLevel) {
                    ServerLevel serverLevel2 = (ServerLevel)level2;
                    serverLevel2.sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, this.getX(), this.getY() + 1.0, this.getZ(), 6, 0.5, 0.5, 0.5, 0.1);
                }
                return InteractionResult.FAIL;
            }
            if (!this.isTamingProcessStarted() && (this.isPlayerArmed(player) || this.isPlayerWearingArmor(player))) {
                net.minecraft.world.level.Level level3;
                player.displayClientMessage((Component)Component.literal((String)"The dragon refuses while you are armed or armored."), true);
                this.playSound(SoundEvents.VILLAGER_NO, 1.0f, 1.0f);
                if (!this.level.isClientSide && (level3 = this.level) instanceof ServerLevel) {
                    ServerLevel serverLevel3 = (ServerLevel)level3;
                    serverLevel3.sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, this.getX(), this.getY() + 1.0, this.getZ(), 6, 0.5, 0.5, 0.5, 0.1);
                }
                return InteractionResult.FAIL;
            }
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            this.playSound(SoundEvents.GENERIC_EAT, this.getSoundVolume(), this.getVoicePitch());
            if (!this.isTamingProcessStarted()) {
                this.setTamingProcessStarted(true);
                this.tamingInitiator = player.getUUID();
            }
            this.setTamingProcessStarted(true);
            int bondGain = this.isFavoriteFood(stack) ? 10 : this.random.nextInt(1, 5);
            this.setTameProgress(this.getTameProgress() + bondGain);
            player.displayClientMessage((Component)Component.literal((String)("Tame Progress: " + this.getTameProgress() + "/100")), true);
            if (!this.level.isClientSide && (level = this.level) instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.HEART, this.getX(), this.getY() + 1.0, this.getZ(), this.isFavoriteFood(stack) ? 6 : 3, 0.5, 0.5, 0.5, 0.1);
            }
            if (this.getTameProgress() >= 100 && !this.isAwaitingAcceptance()) {
                this.navigation.stop();
                this.setTarget(null);
                this.setIsDragonSitting(true);
                this.setAwaitingAcceptance(true);
                this.setCandidateOwner(player);
                this.awaitingTicks = 0;
                player.displayClientMessage((Component)Component.literal((String)"The dragon seems calm... crouch and bond with it."), true);
                if (!this.level.isClientSide && (level = this.level) instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 12; ++i) {
                        double dx = (this.random.nextDouble() - 0.5) * (double)this.getBbWidth();
                        double dy = this.random.nextDouble() * (double)this.getBbHeight();
                        double dz = (this.random.nextDouble() - 0.5) * (double)this.getBbWidth();
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.HEART, this.getX() + dx, this.getY() + dy, this.getZ() + dz, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (this.isEating()) {
            player.displayClientMessage((Component)Component.literal((String)"This dragon is still chewing."), true);
            return InteractionResult.PASS;
        }
        if (this.getHunger() == MAX_HUNGER) {
            player.displayClientMessage((Component)Component.literal((String)"This dragon is already full."), true);
            return InteractionResult.PASS;
        }
        int hungerGain = this.isFavoriteFood(stack) ? 8 : 3;
        this.setHunger(this.getHunger() + hungerGain);
        if (this.isFavoriteFood(stack)) {
            this.setDragonBond(this.getDragonBond() + 0.01f);
        }
        this.playSound(SoundEvents.GENERIC_EAT, this.getSoundVolume(), this.getVoicePitch());
        this.setEating(true);
        this.eatingStartTime = this.tickCount;
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return InteractionResult.SUCCESS;
    }

    public void onFoodEaten() {
        this.setHunger(this.getHunger() + 1);
        this.level.broadcastEntityEvent((Entity)this, (byte)-67);
    }

    @NotNull
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType type, @Nullable SpawnGroupData spawnDataIn) {
        this.setGender(this.random.nextBoolean());
        this.setAgeInDays(100);
        this.setInSittingPose(false);
        this.setFlyingSpeed(DEFAULT_FLYING_SPEED);
        this.setDragonStamina(100);
        this.setTailFin(true);
        this.setFakeTailFin(false);
        this.setLocked(false);
        if (this.getVariantName().isEmpty() || BddBaseDragon.handleSpawnTypes(type)) {
            this.setVariantName(Objects.requireNonNull(this.getRandomVariant(this.getEntityVariants(this.returnDragonType()), this.returnDragonType().getPath())));
        }
        BaseLogger.log((Level)BaseLogLevel.SUCCESS, (String)("Dragon Spawned with Variant: " + this.getVariantName()));
        this.setHunger(MAX_HUNGER);
        BlockPos pos = this.blockPosition();
        this.homePosition = new HomePosition(pos, this.level());
        this.hasHomePosition = true;
        this.refreshDimensions();
        return super.finalizeSpawn(level, difficulty, type, spawnDataIn);
    }

    public static boolean handleSpawnTypes(@NotNull MobSpawnType type) {
        return type.equals((Object)MobSpawnType.SPAWN_EGG) || type.equals((Object)MobSpawnType.MOB_SUMMONED) || type.equals((Object)MobSpawnType.SPAWNER) || type.equals((Object)MobSpawnType.CHUNK_GENERATION) || type.equals((Object)MobSpawnType.BREEDING);
    }

    public String getRandomVariant(List<String> variantNamesList, String defaultVariant) {
        if (variantNamesList == null || variantNamesList.isEmpty()) {
            BaseLogger.log((Level)BaseLogLevel.WARNING, (String)("No variants found for dragon type: " + String.valueOf(this.returnDragonType()) + ". Returning default variant: " + defaultVariant));
            return defaultVariant;
        }
        String currentBiome = this.level.getBiome(this.blockPosition()).unwrapKey().map(key -> key.location().toString()).orElse("");
        boolean isOverworld = this.level.dimension() == net.minecraft.world.level.Level.OVERWORLD;
        ArrayList<String> filteredVariants = new ArrayList<String>();
        for (String variant : variantNamesList) {
            boolean biomeAllowed;
            JsonElement biomesElement = BddBaseDragon.getParameterDataForVariant(this.returnDragonType(), variant, "biomes");
            if (biomesElement == null || biomesElement.isJsonArray() && biomesElement.getAsJsonArray().isEmpty()) {
                biomeAllowed = isOverworld;
            } else if (biomesElement.isJsonArray()) {
                ArrayList allowedBiomes = new ArrayList();
                biomesElement.getAsJsonArray().forEach(biomeJson -> allowedBiomes.add(biomeJson.getAsString()));
                biomeAllowed = allowedBiomes.contains(currentBiome);
            } else {
                biomeAllowed = false;
            }
            if (!biomeAllowed) continue;
            filteredVariants.add(variant);
        }
        if (filteredVariants.isEmpty()) {
            BaseLogger.log((Level)BaseLogLevel.WARNING, (String)("No valid variants for this biome. Returning default variant: " + defaultVariant));
            return defaultVariant;
        }
        ArrayList<AbstractMap.SimpleEntry<String, Integer>> weightedVariants = new ArrayList<AbstractMap.SimpleEntry<String, Integer>>();
        HashMap<String, String> variantRarities = new HashMap<String, String>();
        int totalWeight = 0;
        for (String variant : filteredVariants) {
            String string = Objects.requireNonNullElse(BddBaseDragon.getParameterDataForVariant(this.returnDragonType(), variant, "enabled"), "true").toString().trim();
            String rarityParam = Objects.requireNonNullElse(BddBaseDragon.getParameterDataForVariant(this.returnDragonType(), variant, "rarity"), "common").toString().trim();
            if (rarityParam.startsWith("\"") && rarityParam.endsWith("\"") && rarityParam.length() > 1) {
                rarityParam = rarityParam.substring(1, rarityParam.length() - 1).trim();
            }
            boolean isEnabled = Boolean.parseBoolean(string);
            String rarityKey = rarityParam.toLowerCase();
            Integer rarityWeight = RARITY_WEIGHTS.get(rarityKey);
            if (rarityWeight == null) {
                BaseLogger.log((Level)BaseLogLevel.WARNING, (String)("Invalid rarity value '" + rarityParam + "' for variant: " + variant + ". Using default rarity 'common'."));
                rarityKey = "common";
                rarityWeight = RARITY_WEIGHTS.get("common");
            }
            if (!isEnabled || rarityWeight <= 0) continue;
            totalWeight += rarityWeight.intValue();
            weightedVariants.add(new AbstractMap.SimpleEntry<String, Integer>(variant, rarityWeight));
            variantRarities.put(variant, rarityKey);
        }
        if (totalWeight > 0) {
            int randomWeight = this.random.nextInt(totalWeight);
            for (AbstractMap.SimpleEntry simpleEntry : weightedVariants) {
                if ((randomWeight -= ((Integer)simpleEntry.getValue()).intValue()) >= 0) continue;
                String selectedVariant = (String)simpleEntry.getKey();
                String selectedRarity = variantRarities.getOrDefault(selectedVariant, "common");
                BaseLogger.log((Level)BaseLogLevel.SUCCESS, (String)("Successfully spawned variant: " + selectedVariant + " with rarity: " + selectedRarity));
                return selectedVariant;
            }
        }
        BaseLogger.log((Level)BaseLogLevel.WARNING, (String)("No valid variants found. Returning default variant: " + defaultVariant));
        return defaultVariant;
    }

    @NotNull
    public ResourceLocation getDragonLocation() {
        String adultPath = String.valueOf(BddBaseDragon.getParameterDataForVariant(this.returnDragonType(), this.getVariantName(), "adult")).trim();
        String childPath = String.valueOf(BddBaseDragon.getParameterDataForVariant(this.returnDragonType(), this.getVariantName(), "child")).trim();
        adultPath = this.sanitizePath(adultPath);
        childPath = this.sanitizePath(childPath);
        String texturePath = this.isBaby() ? "dragons/" + childPath + ".png" : "dragons/" + adultPath + ".png";
        return ResourceLocation.fromNamespaceAndPath((String)"bdd", (String)texturePath);
    }

    private String sanitizePath(String path) {
        return path.replace("\\", "/").replace("\"", "").trim();
    }

    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageableMob) {
        String babyVariant;
        if (!(ageableMob instanceof BddBaseDragon)) {
            return null;
        }
        BddBaseDragon otherParent = (BddBaseDragon)ageableMob;
        if (!this.returnDragonType().equals((Object)otherParent.returnDragonType())) {
            BaseLogger.log((Level)BaseLogLevel.ERROR, (String)("Breeding failed: Parents are of different species (" + String.valueOf(this.returnDragonType()) + " and " + String.valueOf(otherParent.returnDragonType()) + ")"));
            return null;
        }
        if (!this.isAdult() || !otherParent.isAdult()) {
            BaseLogger.log((Level)BaseLogLevel.ERROR, (String)"Breeding failed: Both parents must be adults");
            return null;
        }
        if (this.isMale() == otherParent.isMale()) {
            BaseLogger.log((Level)BaseLogLevel.ERROR, (String)"Breeding failed: One parent must be male and the other female");
            return null;
        }
        BddBaseDragon baby = (BddBaseDragon)this.getType().create((net.minecraft.world.level.Level)serverLevel);
        if (baby == null) {
            return null;
        }
        baby.setGender(baby.random.nextBoolean());
        baby.growDragon(100);
        baby.setInSittingPose(false);
        int randomHunger = MIN_HUNGER + baby.random.nextInt(MAX_HUNGER - MIN_HUNGER + 1);
        baby.setHunger(randomHunger);
        String parent1Variant = this.getVariantName();
        String parent2Variant = otherParent.getVariantName();
        int parent1Rarity = this.getVariantRarity(this.returnDragonType(), parent1Variant);
        int parent2Rarity = this.getVariantRarity(otherParent.returnDragonType(), parent2Variant);
        if (parent1Variant != null && parent1Variant.equals(parent2Variant)) {
            babyVariant = parent1Variant;
        } else if (parent1Rarity == 100 && parent2Rarity != 100) {
            boolean useParent2 = baby.random.nextInt(100) < parent2Rarity;
            babyVariant = useParent2 ? parent2Variant : parent1Variant;
        } else if (parent2Rarity == 100 && parent1Rarity != 100) {
            boolean useParent1 = baby.random.nextInt(100) < parent1Rarity;
            babyVariant = useParent1 ? parent1Variant : parent2Variant;
        } else {
            int randomPoint;
            int totalRarity;
            babyVariant = parent1Rarity == 100 ? (baby.random.nextBoolean() ? parent1Variant : parent2Variant) : ((totalRarity = parent1Rarity + parent2Rarity) > 0 ? ((randomPoint = baby.random.nextInt(totalRarity)) < parent1Rarity ? parent1Variant : parent2Variant) : this.getRandomVariant(this.getEntityVariants(baby.returnDragonType()), baby.returnDragonType().getPath()));
        }
        baby.setVariantName(babyVariant);
        BaseLogger.log((Level)BaseLogLevel.SUCCESS, (String)("Baby Dragon Spawned with Variant: " + babyVariant));
        return baby;
    }

    private int getVariantRarity(ResourceLocation dragonType, String variantName) {
        JsonElement rarityObj = ParameterUtils.getParameterDataForVariant((ResourceLocation)dragonType, (String)variantName, (String)"rarity");
        String rarityParam = rarityObj != null ? rarityObj.toString().trim() : "common";
        Integer rarityWeight = RARITY_WEIGHTS.get(rarityParam.toLowerCase());
        if (rarityWeight == null) {
            BaseLogger.log((Level)BaseLogLevel.WARNING, (String)("Invalid rarity value '" + rarityParam + "' for variant: " + variantName + ". Using default rarity 'common'."));
            return RARITY_WEIGHTS.get("common");
        }
        return rarityWeight;
    }

    public boolean fireImmune() {
        return true;
    }

    @Nullable
    public static JsonElement getParameterDataForVariant(ResourceLocation entityName, String variantName, String parameter) {
        return ParameterUtils.getParameterDataForVariant((ResourceLocation)entityName, (String)variantName, (String)parameter, (String)entityName.getPath());
    }

    public abstract float backCameraIncrease();

    @NotNull
    public BddBaseDragon getEntity() {
        return this;
    }

    public boolean isPushedByFluid() {
        return true;
    }

    public boolean canBeLeashed() {
        return true;
    }

    @NotNull
    public ResourceLocation getControllerResource() {
        return BddCommon.Resource.resource("controller/" + this.returnDragonType().getPath() + ".controller.json");
    }

    public boolean isArmedWithinRange(double range) {
        List nearbyPlayers = this.level.getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(range), player -> player.isAlive() && !player.isSpectator());
        for (Player player2 : nearbyPlayers) {
            if (!this.isPlayerArmed(player2)) continue;
            return true;
        }
        return false;
    }

    public boolean isArmed() {
        return this.isArmedWithinRange(10.0) && !this.isArmedWithinRange(3.0);
    }

    protected boolean isPlayerArmed(Player player) {
        if (this.isWeaponOrShield(player.getOffhandItem())) {
            return true;
        }
        Inventory inv = player.getInventory();
        for (int i = 0; i < 9; ++i) {
            if (!this.isWeaponOrShield(inv.getItem(i))) continue;
            return true;
        }
        return false;
    }

    protected boolean isWeaponOrShield(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        return item instanceof SwordItem || item instanceof AxeItem || item instanceof BowItem || item instanceof CrossbowItem || item instanceof TridentItem || item instanceof ShieldItem;
    }

    protected boolean isPlayerWearingArmor(Player player) {
        for (ItemStack armor : player.getArmorSlots()) {
            if (armor.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Vec3 getMatrixPos(BddBaseDragon entity, Matrix4f matrix) {
        if (this.level.isClientSide && matrix != null) {
            Vector3f bonePos = new Vector3f(0.0f, 0.0f, 0.0f);
            matrix.transformPosition(bonePos);
            Vec3 entityPos = entity.position();
            return new Vec3(entityPos.x + (double)bonePos.x(), entityPos.y + (double)bonePos.y(), entityPos.z + (double)bonePos.z());
        }
        Vec3 rotVector = Vec3.directionFromRotation((float)(this.getXRot() * 0.2f), (float)this.getYRot());
        Vec3 position = this.getEyePosition().add(0.0, 0.0, 0.0);
        return position.add(rotVector.scale((double)this.getBbWidth()));
    }

    public Vec3 adjustFirstPersonCamera(Vec3 rideOffset, Matrix4f boneMatrix) {
        if (boneMatrix != null) {
            Vector3f offset = new Vector3f((float)rideOffset.x(), (float)rideOffset.y(), (float)rideOffset.z());
            boneMatrix.transformPosition(offset);
            return new Vec3((double)offset.x(), (double)offset.y(), (double)offset.z());
        }
        return rideOffset;
    }

    static {
        RARITY_WEIGHTS.put("common", 100);
        RARITY_WEIGHTS.put("uncommon", 50);
        RARITY_WEIGHTS.put("rare", 15);
        RARITY_WEIGHTS.put("epic", 5);
        RARITY_WEIGHTS.put("legendary", 1);
    }
}

