/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.core_classes;

import com.bdc.bdd.api.entity.core_classes.BddSaddleDragon;
import com.bdc.bdd.api.entity.util.DragonMoveControl;
import com.bdc.bdd.api.entity.util.DragonPathNavigation;
import com.bdc.bdd.util.BddUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BddFlyingDragon
extends BddSaddleDragon {
    public static final float MIN_FLYING_SPEED = 0.02f;
    private static final float GLIDE_SPEED_BOOST_MULTIPLIER = 2.7f;
    private static final float PITCH_THRESHOLD = 10.0f;
    private static final float DIVE_SPEED_INCREMENT = 0.002f;
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.defineId(BddFlyingDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HOVERING = SynchedEntityData.defineId(BddFlyingDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> GOING_UP = SynchedEntityData.defineId(BddFlyingDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> GOING_DOWN = SynchedEntityData.defineId(BddFlyingDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> FLIGHT_ANIMATION_TIMER = SynchedEntityData.defineId(BddFlyingDragon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DIVE_TIMER = SynchedEntityData.defineId(BddFlyingDragon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> FORCE_GLIDE = SynchedEntityData.defineId(BddFlyingDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> TURN_ANIMATION_TIMER = SynchedEntityData.defineId(BddFlyingDragon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> SPEEDING_UP = SynchedEntityData.defineId(BddFlyingDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SPEEDING_DOWN = SynchedEntityData.defineId(BddFlyingDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final GroundPathNavigation groundNavigation;
    private final FlyingPathNavigation flyingNavigation;
    public float lastYaw;
    private float bodyPitch = 0.0f;
    private int postDismountNoTakeoffTicks = 0;
    private int takeoffLatchTicks = 0;
    private int takeoffBoostTicks = 0;
    private int groundContactTicks = 0;
    private static final double AI_ASCEND_Y_PER_TICK = 0.28;
    private static final double AI_DIVE_Y_PER_TICK = 0.36;

    public BddFlyingDragon(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new DragonMoveControl(this);
        this.flyingNavigation = new FlyingPathNavigation((Mob)this, level);
        this.groundNavigation = new GroundPathNavigation((Mob)this, level);
        this.flyingNavigation.setCanFloat(true);
        this.groundNavigation.setCanFloat(true);
        this.navigation = this.groundNavigation;
        this.lastYaw = this.getYRot();
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level level) {
        DragonPathNavigation dragonNavigation = new DragonPathNavigation((Mob)this, level);
        dragonNavigation.setCanFloat(true);
        return dragonNavigation;
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FLYING, (Object)false);
        builder.define(HOVERING, (Object)false);
        builder.define(GOING_UP, (Object)false);
        builder.define(GOING_DOWN, (Object)false);
        builder.define(FLIGHT_ANIMATION_TIMER, (Object)0);
        builder.define(DIVE_TIMER, (Object)0);
        builder.define(FORCE_GLIDE, (Object)false);
        builder.define(TURN_ANIMATION_TIMER, (Object)0);
        builder.define(SPEEDING_UP, (Object)false);
        builder.define(SPEEDING_DOWN, (Object)false);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Flying", this.isFlying());
        compound.putBoolean("Hovering", this.isHovering());
        compound.putBoolean("GoingUp", this.isGoingUp());
        compound.putBoolean("Diving", this.isDiving());
        compound.putInt("FlightAnimationTimer", this.getFlightAnimationTimer());
        compound.putInt("DiveTimer", this.getDiveTimer());
        compound.putBoolean("ForceGlide", this.isForceGlide());
        compound.putInt("TurnAnimationTimer", this.getTurnAnimationTimer());
        compound.putBoolean("SpeedUp", this.isSpeedingUp());
        compound.putBoolean("SpeedDown", this.isSpeedingDown());
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setFlying(compound.getBoolean("Flying"));
        this.setHovering(compound.getBoolean("Hovering"));
        this.setGoingUp(compound.getBoolean("GoingUp"));
        this.setDiving(compound.getBoolean("Diving"));
        this.setFlightAnimationTimer(compound.getInt("FlightAnimationTimer"));
        this.setDiveTimer(compound.getInt("DiveTimer"));
        this.setForceGlide(compound.getBoolean("ForceGlide"));
        this.setTurnAnimationTimer(compound.getInt("TurnAnimationTimer"));
        this.setSpeedingUp(compound.getBoolean("SpeedUp"));
        this.setSpeedingDown(compound.getBoolean("SpeedDown"));
    }

    @Override
    public boolean isFlying() {
        return (Boolean)this.entityData.get(FLYING);
    }

    @Override
    public void setFlying(boolean flying) {
        this.entityData.set(FLYING, (Object)flying);
        this.setNoGravity(flying);
        if (flying) {
            if (!this.level.isClientSide()) {
                this.setNavigation(true);
            }
        } else if (!this.level.isClientSide()) {
            this.setNavigation(false);
        }
    }

    public void jumpFromGround() {
        super.jumpFromGround();
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, 1.5, 0.0));
        this.takeoffLatchTicks = 14;
        this.takeoffBoostTicks = 12;
    }

    @Override
    public void removePassenger(Entity passenger) {
        super.removePassenger(passenger);
        if (passenger instanceof Player) {
            this.postDismountNoTakeoffTicks = BddUtil.secondsToTicks(4);
            this.takeoffLatchTicks = 0;
            this.takeoffBoostTicks = 0;
            this.setGoingUp(false);
            this.setDiving(false);
            if (this.onGround()) {
                this.setFlying(false);
                this.setHovering(false);
                this.setNoGravity(false);
                if (!this.level.isClientSide()) {
                    this.setNavigation(false);
                }
            }
        }
    }

    public boolean isAbleToFly() {
        return this.canFly() && !this.isBaby() && (this.hasTailFin() || this.hasFakeTailFin());
    }

    @Override
    public boolean isHovering() {
        return (Boolean)this.entityData.get(HOVERING);
    }

    @Override
    public void setHovering(boolean hovering) {
        this.entityData.set(HOVERING, (Object)hovering);
        this.setNoGravity(hovering || this.isFlying());
    }

    @Override
    public boolean isGoingUp() {
        return (Boolean)this.entityData.get(GOING_UP);
    }

    @Override
    public void setGoingUp(boolean goingUp) {
        this.entityData.set(GOING_UP, (Object)goingUp);
    }

    @Override
    public boolean isDiving() {
        return (Boolean)this.entityData.get(GOING_DOWN);
    }

    @Override
    public void setDiving(boolean diving) {
        this.entityData.set(GOING_DOWN, (Object)diving);
        if (!diving) {
            this.setDiveTimer(0);
        }
    }

    public float getBodyPitch() {
        return this.bodyPitch;
    }

    public void setBodyPitch(float pitch) {
        this.bodyPitch = pitch;
    }

    public boolean isSpeedingUp() {
        return (Boolean)this.entityData.get(SPEEDING_UP);
    }

    public void setSpeedingUp(boolean speedingUp) {
        this.entityData.set(SPEEDING_UP, (Object)speedingUp);
    }

    public boolean isSpeedingDown() {
        return (Boolean)this.entityData.get(SPEEDING_DOWN);
    }

    public void setSpeedingDown(boolean speedingDown) {
        this.entityData.set(SPEEDING_DOWN, (Object)speedingDown);
    }

    public int getFlightAnimationTimer() {
        return (Integer)this.entityData.get(FLIGHT_ANIMATION_TIMER);
    }

    public void setFlightAnimationTimer(int timer) {
        this.entityData.set(FLIGHT_ANIMATION_TIMER, (Object)timer);
    }

    public int getDiveTimer() {
        return (Integer)this.entityData.get(DIVE_TIMER);
    }

    public void setDiveTimer(int timer) {
        this.entityData.set(DIVE_TIMER, (Object)timer);
    }

    public boolean isForceGlide() {
        return (Boolean)this.entityData.get(FORCE_GLIDE);
    }

    public void setForceGlide(boolean forceGlide) {
        this.entityData.set(FORCE_GLIDE, (Object)forceGlide);
    }

    public int getTurnAnimationTimer() {
        return (Integer)this.entityData.get(TURN_ANIMATION_TIMER);
    }

    public void setTurnAnimationTimer(int timer) {
        this.entityData.set(TURN_ANIMATION_TIMER, (Object)timer);
    }

    protected float getJumpPower() {
        return super.getJumpPower() / 7.0f;
    }

    public boolean shouldFly() {
        return this.isFlying() ? !this.onGround() : this.isAbleToFly() && !this.isInWater();
    }

    public void setNavigation(boolean flying) {
        this.navigation = flying ? this.flyingNavigation : this.groundNavigation;
    }

    @Override
    public void tick() {
        boolean shouldKeepFlying;
        boolean airborne;
        super.tick();
        this.groundContactTicks = this.onGround() ? ++this.groundContactTicks : 0;
        boolean bl = airborne = !this.onGround();
        if (airborne) {
            if (this.takeoffLatchTicks > 0) {
                --this.takeoffLatchTicks;
            }
            if (this.takeoffBoostTicks > 0) {
                --this.takeoffBoostTicks;
            }
        }
        boolean bl2 = shouldKeepFlying = this.isAbleToFly() && airborne && (this.takeoffLatchTicks > 0 || this.isHighEnough(2) || this.getDeltaMovement().y > 0.08);
        if (shouldKeepFlying) {
            if (!this.isFlying()) {
                this.setFlying(true);
            }
            this.setNoGravity(true);
            if (!this.level.isClientSide()) {
                this.setNavigation(true);
            }
            if (this.takeoffBoostTicks > 0) {
                Vec3 dm = this.getDeltaMovement();
                double minUp = 0.34;
                if (dm.y < minUp) {
                    this.setDeltaMovement(dm.x, minUp, dm.z);
                }
            }
        } else {
            boolean LAND_GROUND_TICKS = true;
            if ((this.groundContactTicks >= 1 || !this.isAbleToFly()) && this.isFlying()) {
                this.setFlying(false);
                this.setHovering(false);
                this.setNoGravity(false);
                this.setGoingUp(false);
                this.setDiving(false);
                this.setDiveTimer(0);
                Vec3 dm = this.getDeltaMovement();
                this.setDeltaMovement(dm.x * 0.6, 0.0, dm.z * 0.6);
                if (!this.level.isClientSide()) {
                    this.setNavigation(false);
                }
            }
        }
        if (this.isDiving() && this.isFlying()) {
            this.setDiveTimer(this.getDiveTimer() + 1);
        }
    }

    public boolean isPostDismountCooldownActive() {
        return this.postDismountNoTakeoffTicks > 0;
    }

    public boolean hasHeadroom(Level level, BlockPos pos, int height) {
        BlockPos.MutableBlockPos m = new BlockPos.MutableBlockPos();
        for (int dy = 1; dy <= height; ++dy) {
            m.set(pos.getX(), pos.getY() + dy, pos.getZ());
            if (level.getBlockState((BlockPos)m).isAir()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private Vec3 getAutopilotTargetVec() {
        Path path;
        if (this.getNavigation().isInProgress() && (path = this.getNavigation().getPath()) != null) {
            try {
                BlockPos nodePos = path.getNextNodePos();
                if (nodePos != null) {
                    return new Vec3((double)nodePos.getX() + 0.5, (double)nodePos.getY(), (double)nodePos.getZ() + 0.5);
                }
            }
            catch (Throwable nodePos) {
                // empty catch block
            }
            try {
                Node node = path.getNextNode();
                if (node != null) {
                    return new Vec3((double)node.x + 0.5, (double)node.y, (double)node.z + 0.5);
                }
            }
            catch (Throwable node) {
                // empty catch block
            }
            try {
                BlockPos target = path.getTarget();
                if (target != null) {
                    return new Vec3((double)target.getX() + 0.5, (double)target.getY(), (double)target.getZ() + 0.5);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.targetPosition != null) {
            return new Vec3((double)this.targetPosition.getX() + 0.5, (double)this.targetPosition.getY() + 0.5, (double)this.targetPosition.getZ() + 0.5);
        }
        return null;
    }

    public void travel(@NotNull Vec3 travelVector) {
        Vec3 movement;
        LivingEntity driver = this.getControllingPassenger();
        boolean flown = this.isFlying();
        Vec3 vec3 = movement = driver != null ? this.handleRiddenMovement(driver, travelVector) : this.handleUnriddenMovement(travelVector);
        if (driver != null && flown && this.isControlledByLocalInstance()) {
            this.handleFlightMovement(driver, movement);
            if (this.getDeltaMovement().y < 0.1 && !this.isGoingUp()) {
                Vec3 dm = this.getDeltaMovement();
                this.setDeltaMovement(dm.x * 0.9, dm.y, dm.z * 0.9);
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.calculateEntityAnimation(true);
        } else {
            double yBefore = this.getY();
            super.travel(movement);
            if (flown && driver == null) {
                this.applyUnriddenVerticalOverride(this.getFlyingSpeed(), yBefore);
            }
        }
        this.adjustFlyingSpeed(driver);
    }

    private void applyUnriddenVerticalOverride(double flightSpeed, double yBefore) {
        if (!this.isFlying()) {
            return;
        }
        double navVyApplied = this.getY() - yBefore;
        if (this.isHovering()) {
            if (Math.abs(navVyApplied) > 1.0E-4) {
                this.move(MoverType.SELF, new Vec3(0.0, -navVyApplied, 0.0));
            }
            Vec3 dm = this.getDeltaMovement();
            this.setDeltaMovement(dm.x, 0.0, dm.z);
            return;
        }
        double desiredVy = this.isGoingUp() ? Math.max(0.28, flightSpeed * 0.85) : (this.isDiving() ? -Math.max(0.36, flightSpeed * 1.25) : 0.0);
        double correction = desiredVy - navVyApplied;
        if (Math.abs(correction) > 1.0E-4) {
            this.move(MoverType.SELF, new Vec3(0.0, correction, 0.0));
        }
        Vec3 dm = this.getDeltaMovement();
        this.setDeltaMovement(dm.x, desiredVy, dm.z);
    }

    private Vec3 handleRiddenMovement(LivingEntity driver, Vec3 travelVector) {
        double moveSideways = travelVector.x;
        double moveY = travelVector.y;
        double moveForward = Math.min(Math.abs(driver.zza) + Math.abs(driver.xxa), 1.0f);
        float yaw = driver.yHeadRot;
        if (moveForward > 0.0) {
            yaw += (float)Mth.atan2((double)driver.zza, (double)driver.xxa) * 57.295776f - 90.0f;
        }
        this.yHeadRot = yaw;
        this.setXRot(driver.getXRot() * 0.68f);
        this.setYRot(Mth.rotateIfNecessary((float)this.yHeadRot, (float)this.getYRot(), (float)4.0f));
        if (!this.isControlledByLocalInstance()) {
            this.setDeltaMovement(Vec3.ZERO);
            this.calculateEntityAnimation(true);
            return Vec3.ZERO;
        }
        if (this.isFlying()) {
            if (moveForward > 0.0 && driver instanceof Player) {
                Player player = (Player)driver;
                float pitch = player.getXRot();
                this.setGoingUp(pitch < -10.0f);
                this.setDiving(pitch > 10.0f);
            } else {
                this.setGoingUp(false);
                this.setDiving(false);
            }
            moveForward = this.isHovering() ? 0.0 : 1.0;
            moveSideways = 0.0;
            moveY = 0.0;
        }
        this.handleRiddenStateTransitions(driver);
        return new Vec3(moveSideways, moveY, moveForward);
    }

    private void handleRiddenStateTransitions(LivingEntity driver) {
        if (this.onGround()) {
            if (this.isFlying()) {
                this.setFlying(false);
            }
            if (driver instanceof Player) {
                Player player = (Player)driver;
                if (player.jumping) {
                    this.jumpFromGround();
                }
            }
        }
    }

    private Vec3 handleUnriddenMovement(Vec3 travelVector) {
        return travelVector;
    }

    private void handleFlightMovement(@Nullable LivingEntity driver, Vec3 movement) {
        Vec3 forwardDir;
        if (this.isHovering()) {
            this.setDeltaMovement(Vec3.ZERO);
            return;
        }
        double flightSpeed = this.getFlyingSpeed();
        if (this.isForceGlide()) {
            flightSpeed *= (double)2.7f;
        }
        if (this.isDiving()) {
            flightSpeed += (double)((float)this.getDiveTimer() * 0.002f);
        }
        double verticalSpeed = this.getVerticalSpeed(driver, flightSpeed);
        if (driver == null) {
            Vec3 target = this.getAutopilotTargetVec();
            if (target != null) {
                Vec3 to = target.subtract(this.position());
                double dx = to.x;
                double dz = to.z;
                double horizDist = Math.sqrt(dx * dx + dz * dz);
                float desiredYaw = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                this.setYRot(Mth.rotateIfNecessary((float)desiredYaw, (float)this.getYRot(), (float)6.0f));
                this.yHeadRot = this.getYRot();
                forwardDir = Vec3.directionFromRotation((float)0.0f, (float)this.getYRot()).normalize();
                double slowFactor = horizDist < 4.0 ? horizDist / 4.0 : 1.0;
                flightSpeed *= Mth.clamp((double)slowFactor, (double)0.25, (double)1.0);
            } else {
                forwardDir = Vec3.directionFromRotation((float)0.0f, (float)this.getYRot()).normalize();
            }
        } else {
            forwardDir = Vec3.directionFromRotation((float)0.0f, (float)this.getYRot()).normalize();
        }
        Vec3 forwardMovement = forwardDir.scale(flightSpeed);
        Vec3 totalMovement = new Vec3(forwardMovement.x, verticalSpeed, forwardMovement.z);
        this.setDeltaMovement(this.getDeltaMovement().scale((double)0.9f).add(totalMovement));
    }

    private double getVerticalSpeed(@Nullable LivingEntity driver, double flightSpeed) {
        if (this.isHovering()) {
            return 0.0;
        }
        if (driver == null) {
            return 0.0;
        }
        if (this.isGoingUp()) {
            return flightSpeed * 0.4;
        }
        if (this.isDiving()) {
            return -flightSpeed * 0.6;
        }
        return 0.0;
    }

    private void handleGroundMovement(LivingEntity driver, Vec3 travelVector) {
        Vec3 riddenInput = driver != null ? this.getRiddenInput((Player)driver, travelVector) : travelVector;
        Vec3 adjustedMovement = this.rotateMovementToEntity(riddenInput, this.getYRot());
        double baseSpeedMultiplier = this.getAttributeValue(Attributes.MOVEMENT_SPEED) * 4.0;
        double sprintSpeedMultiplier = this.getAttributeValue(Attributes.MOVEMENT_SPEED) * 5.0;
        double effectiveSpeedMultiplier = this.isSprinting() ? sprintSpeedMultiplier : baseSpeedMultiplier;
        double currentY = this.getDeltaMovement().y;
        Vec3 newMovement = new Vec3(adjustedMovement.x * effectiveSpeedMultiplier, currentY, adjustedMovement.z * effectiveSpeedMultiplier).scale(0.9);
        this.setDeltaMovement(newMovement);
    }

    public void adjustFlyingSpeed(LivingEntity driver) {
        block9: {
            block8: {
                if (!(driver instanceof Player)) break block8;
                Player player = (Player)driver;
                if (this.isFlying()) break block9;
            }
            return;
        }
        float currentFlyingSpeed = this.getFlyingSpeed();
        float speedIncrement = 0.001f;
        if (this.isSpeedingUp()) {
            if (currentFlyingSpeed < MAX_FLYING_SPEED) {
                this.setFlyingSpeed(currentFlyingSpeed + speedIncrement);
            }
        } else if (this.isSpeedingDown() && currentFlyingSpeed > 0.02f) {
            this.setFlyingSpeed(currentFlyingSpeed - speedIncrement);
        }
    }

    public double getAltitude(int limit) {
        BlockPos.MutableBlockPos pointer = this.blockPosition().mutable().move(0, -1, 0);
        int min = this.level.dimensionType().minY();
        int i = 0;
        while (i <= limit && pointer.getY() > min && !this.level.getBlockState((BlockPos)pointer).isSolid()) {
            pointer.setY(this.getBlockY() - ++i);
        }
        return i;
    }

    public double getAltitude() {
        return this.getAltitude(this.level.getMaxBuildHeight());
    }

    public boolean isHighEnough(int height) {
        return this.getAltitude(height) >= (double)height;
    }
}

