/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.util;

import com.bdc.bdd.api.entity.core_classes.BddBaseDragon;
import com.bdc.bdd.util.BddUtil;
import java.util.Random;
import net.minecraft.world.entity.Entity;

public class BddLogic {
    private static final int MIN_WANDERING_TIME = BddUtil.minutesToSeconds(10);
    private static final int MAX_REST_TIME = BddUtil.minutesToSeconds(5);
    private final BddBaseDragon dragon;
    public int wanderingTime = 0;
    public int restingTime = 0;
    public boolean isResting = false;
    public int dragonHungerTickRate = 3000;
    private double staminaAccumulator = 0.0;

    public BddLogic(BddBaseDragon dragon) {
        this.dragon = dragon;
    }

    public void updateDragonServer() {
        if (this.dragon.level.isClientSide()) {
            if (this.dragon.isInLove()) {
                this.dragon.level.broadcastEntityEvent((Entity)this.dragon, (byte)18);
            }
            if (this.dragon.getHunger() == 0) {
                this.dragon.setDragonBond(this.dragon.getDragonBond() - 1.0f);
            }
        }
        if (this.dragon.getSleepDisturbTicks() > 0) {
            this.dragon.setSleepDisturbTicks(this.dragon.getSleepDisturbTicks() - 1);
        }
        if (this.dragon.tickCount % this.dragonHungerTickRate == 0 && this.dragonHungerTickRate > 0 && this.dragon.getHunger() > 0) {
            this.dragon.setHunger(this.dragon.getHunger() - 1);
        }
    }

    public void manageDragonBehavior() {
        if (!this.dragon.level.isClientSide()) {
            if (this.isResting) {
                ++this.restingTime;
                if (this.restingTime >= MAX_REST_TIME) {
                    boolean shouldWakeUp;
                    Random random = new Random();
                    boolean bl = shouldWakeUp = (double)random.nextFloat() < 0.7;
                    if (shouldWakeUp) {
                        this.dragon.setIsDragonSleeping(false);
                        this.isResting = false;
                        this.wanderingTime = 0;
                    }
                }
            } else {
                ++this.wanderingTime;
                if (this.wanderingTime >= MIN_WANDERING_TIME) {
                    boolean shouldRest;
                    Random random = new Random();
                    boolean bl = shouldRest = (double)random.nextFloat() < 0.35;
                    if (shouldRest) {
                        if (this.dragon.isDragonSleeping()) {
                            return;
                        }
                        this.dragon.setIsDragonSleeping(true);
                        this.isResting = true;
                        this.restingTime = 0;
                    }
                }
            }
        }
    }

    public void handleDragonStamina() {
        int currentStamina = this.dragon.getDragonStamina();
        double staminaChangePerTick = this.getStaminaChangePerTick();
        this.staminaAccumulator += staminaChangePerTick;
        if (Math.abs(this.staminaAccumulator) >= 1.0) {
            int wholeStaminaChange = (int)this.staminaAccumulator;
            this.dragon.setDragonStamina(currentStamina + wholeStaminaChange);
            this.staminaAccumulator -= (double)wholeStaminaChange;
        }
    }

    private double getStaminaChangePerTick() {
        double staminaChangePerMinute = this.dragon.isDragonSleeping() || this.dragon.isDragonSitting() ? 5.0 : (this.dragon.getFlyingSpeed() == BddBaseDragon.MAX_FLYING_SPEED && this.dragon.isFlying() ? -300.0 : (this.dragon.isFlying() ? -2.0 : (this.dragon.isMovingOnGround() ? -1.0 : -0.02)));
        return staminaChangePerMinute / (double)BddUtil.minutesToSeconds(1);
    }
}

